/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import java.util.Collections;
import java.util.Set;
import org.jdom.Element;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.integrate.AbstractXmlPublisherExtensionPoint;
import org.jumpmind.symmetric.load.DataLoaderContext;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;
import org.jumpmind.symmetric.service.INodeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPublisherDataRouter
extends AbstractXmlPublisherExtensionPoint
implements IDataRouter {
    boolean onePerBatch = false;
    private INodeService nodeService;

    public void contextCommitted(IRouterContext context) {
        if (this.doesXmlExistToPublish((ICacheContext)context)) {
            this.finalizeXmlAndPublish((ICacheContext)context);
        }
    }

    public void completeBatch(IRouterContext context, OutgoingBatch batch) {
        DataLoaderContext contextForPublishing = new DataLoaderContext(this.nodeService, context.getJdbcTemplate());
        contextForPublishing.setSourceNodeId(batch.getNodeId());
        contextForPublishing.setBatchId(batch.getBatchId());
        if (this.onePerBatch && this.doesXmlExistToPublish((ICacheContext)contextForPublishing)) {
            this.finalizeXmlAndPublish((ICacheContext)contextForPublishing);
        }
    }

    public Set<String> routeToNodes(IRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad) {
        if (this.tableNamesToPublishAsGroup == null || this.tableNamesToPublishAsGroup.contains(dataMetaData.getData().getTableName())) {
            Element xml = this.getXmlFromCache((ICacheContext)context, dataMetaData.getTriggerHistory().getParsedColumnNames(), dataMetaData.getData().toParsedRowData(), dataMetaData.getTriggerHistory().getParsedPkColumnNames(), dataMetaData.getData().toParsedPkData());
            if (xml != null) {
                this.toXmlElement(dataMetaData.getData().getEventType(), xml, dataMetaData.getData().getTableName(), dataMetaData.getTriggerHistory().getParsedColumnNames(), dataMetaData.getData().toParsedRowData(), dataMetaData.getTriggerHistory().getParsedPkColumnNames(), dataMetaData.getData().toParsedPkData());
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("XmlPublisherTableNotFound", new Object[]{dataMetaData.getData().getTableName()});
        }
        return Collections.emptySet();
    }

    public void setOnePerBatch(boolean onePerBatch) {
        this.onePerBatch = onePerBatch;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }
}

