/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.map;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.ITableColumnFilter;
import org.jumpmind.symmetric.load.StatementBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnsFilter
implements ITableColumnFilter,
INodeGroupExtensionPoint {
    private static final ILog log = LogFactory.getLog(AddColumnsFilter.class);
    private String[] tables;
    private Map<String, String> additionalColumns;
    private boolean autoRegister = true;
    private String[] nodeGroupIdsToApplyTo;

    public String[] getTables() {
        return this.tables;
    }

    public void setTables(String[] tables) {
        this.tables = tables;
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdsToApplyTo(String[] nodeGroupIdsToApplyTo) {
        this.nodeGroupIdsToApplyTo = nodeGroupIdsToApplyTo;
    }

    public Map<String, String> getAdditionalColumns() {
        return this.additionalColumns;
    }

    public void setAdditionalColumns(Map<String, String> columns) {
        this.additionalColumns = new TreeMap<String, String>(columns);
    }

    public String[] filterColumnsNames(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnNames) {
        if (this.additionalColumns != null) {
            int i;
            String[] columnNamesPlus = new String[columnNames.length + this.additionalColumns.size()];
            for (i = 0; i < columnNames.length; ++i) {
                columnNamesPlus[i] = columnNames[i];
            }
            i = columnNames.length;
            for (String extraCol : this.additionalColumns.keySet()) {
                columnNamesPlus[i++] = extraCol;
            }
            return columnNamesPlus;
        }
        return columnNames;
    }

    public String[] filterColumnsValues(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnValues) {
        if (this.additionalColumns != null) {
            int i;
            String[] columnValuesPlus = new String[columnValues.length + this.additionalColumns.size()];
            for (i = 0; i < columnValues.length; ++i) {
                columnValuesPlus[i] = columnValues[i];
            }
            i = columnValues.length;
            for (String extraCol : this.additionalColumns.keySet()) {
                String extraValue = this.additionalColumns.get(extraCol);
                if (":EXTERNAL_ID".equals(extraValue)) {
                    extraValue = ctx.getSourceNode() != null ? ctx.getSourceNode().getExternalId() : null;
                } else if (":NODE_ID".equals(extraValue)) {
                    extraValue = ctx.getSourceNode().getNodeId();
                } else if (":NODE_GROUP_ID".equals(extraValue)) {
                    extraValue = ctx.getSourceNode() != null ? ctx.getSourceNode().getNodeGroupId() : null;
                } else if (extraValue instanceof String && extraValue.toString().startsWith(":")) {
                    String extraColumnName = extraValue.toString().substring(1);
                    int index = ctx.getFilteredColumnIndex(extraColumnName);
                    if (index >= 0) {
                        if (columnValues.length > index) {
                            extraValue = columnValues[index];
                        } else {
                            log.error("Message", new Object[]{String.format("The column name of %s was found, but the index, %d, was greater than the array of values.\n The column names were: %s\n The column values were: %s", extraColumnName, index, ArrayUtils.toString((Object)ctx.getFilteredColumnNames()), ArrayUtils.toString((Object)columnValues))});
                            extraValue = null;
                        }
                    } else {
                        log.error("Message", new Object[]{String.format("Could not find a column with the name of %s", extraColumnName, index)});
                        extraValue = null;
                    }
                }
                columnValuesPlus[i++] = extraValue;
            }
            return columnValuesPlus;
        }
        return columnValues;
    }
}

