/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.ITableColumnFilter;
import org.jumpmind.symmetric.load.StatementBuilder;

public class RemoveColumnsFilter
implements ITableColumnFilter,
INodeGroupExtensionPoint {
    private String[] columnsToRemove;
    private String[] tables;
    private String[] nodeGroupsToApplyTo;
    final String cacheKey = this.getClass().getName() + ".columnIndex";
    private boolean autoRegister = true;

    public String[] getTables() {
        return this.tables;
    }

    public void setColumnToRemove(String column) {
        this.columnsToRemove = new String[]{column};
    }

    public void setColumnsToRemove(String[] columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    public void setTables(String[] tables) {
        this.tables = tables;
    }

    public void setTable(String table) {
        this.tables = new String[]{table};
    }

    public void setNodeGroupsToApplyTo(String[] nodeGroupsToApplyTo) {
        this.nodeGroupsToApplyTo = nodeGroupsToApplyTo;
    }

    public void setNodeGroupToApplyTo(String nodeGroupToApplyTo) {
        this.nodeGroupsToApplyTo = new String[]{nodeGroupToApplyTo};
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupsToApplyTo;
    }

    public String[] filterColumnsNames(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnNames) {
        if (dml != StatementBuilder.DmlType.DELETE) {
            HashMap columnIndex = (HashMap)ctx.getContextCache().get(this.cacheKey);
            if (columnIndex == null) {
                columnIndex = new HashMap(4);
                ctx.getContextCache().put(this.cacheKey, columnIndex);
            }
            ArrayList<String> columns = new ArrayList<String>();
            int index = 0;
            for (String col : columnNames) {
                if (ArrayUtils.contains((Object[])this.columnsToRemove, (Object)col)) {
                    Integer putValue = index;
                    if (columnIndex.get(dml) == null) {
                        columnIndex.put(dml, new ArrayList());
                    }
                    ((List)columnIndex.get(dml)).add(putValue);
                } else {
                    columns.add(col);
                }
                ++index;
            }
            return columns.toArray(new String[columns.size()]);
        }
        return columnNames;
    }

    public String[] filterColumnsValues(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnValues) {
        List indexes;
        Map columnIndex;
        if (dml != StatementBuilder.DmlType.DELETE && (columnIndex = (Map)ctx.getContextCache().get(this.cacheKey)) != null && (indexes = (List)columnIndex.get(dml)) != null) {
            String[] sourceValues = columnValues;
            columnValues = new String[columnValues.length - indexes.size()];
            int targetIndex = 0;
            int sourceIndex = 0;
            for (String sourceValue : sourceValues) {
                if (!indexes.contains(sourceIndex)) {
                    columnValues[targetIndex++] = sourceValue;
                }
                ++sourceIndex;
            }
        }
        return columnValues;
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }
}

