/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.compression.CompressionServletResponseWrapper;

public abstract class AbstractCompressionUriHandler
extends AbstractUriHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        boolean compressionEnabled;
        boolean bl = compressionEnabled = !this.parameterService.is("web.compression.disabled");
        if (compressionEnabled) {
            int compressionLevel = this.parameterService.getInt("compression.level");
            int compressionStrategy = this.parameterService.getInt("compression.strategy");
            this.log.debug("CompressionFilterStarting");
            boolean supportCompression = false;
            this.log.debug("CompressionFilterURI", new Object[]{req.getRequestURI()});
            String s = req.getParameter("gzip");
            if ("false".equals(s)) {
                this.log.debug("CompressionFilterNotCompressing");
                this.handleWithCompression(req, res);
                return;
            }
            Enumeration e = req.getHeaders("Accept-Encoding");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.indexOf("gzip") != -1) {
                    this.log.debug("CompressionFilterSupportsCompression");
                    supportCompression = true;
                    continue;
                }
                this.log.debug("CompressionFilterDoesNotSupportsCompression");
            }
            if (!supportCompression) {
                this.log.debug("CompressionFilterCalledNotCompressing");
                this.handleWithCompression(req, res);
                return;
            }
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(res, compressionLevel, compressionStrategy);
            this.log.debug("CompressionFilterCalledCompressing");
            try {
                this.handleWithCompression(req, (HttpServletResponse)wrappedResponse);
            }
            finally {
                wrappedResponse.finishResponse();
            }
            return;
        }
        this.handleWithCompression(req, res);
    }

    protected abstract void handleWithCompression(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
}

