/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class AuthenticationInterceptor
implements IInterceptor {
    private INodeService nodeService;

    public boolean before(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String securityToken = req.getParameter("securityToken");
        String nodeId = req.getParameter("nodeId");
        if (StringUtils.isEmpty((String)securityToken) || StringUtils.isEmpty((String)nodeId)) {
            ServletUtils.sendError(resp, 403);
            return false;
        }
        AuthenticationStatus status = this.getAuthenticationStatus(nodeId, securityToken);
        if (AuthenticationStatus.ACCEPTED.equals((Object)status)) {
            return true;
        }
        if (AuthenticationStatus.REGISTRATION_REQUIRED.equals((Object)status)) {
            ServletUtils.sendError(resp, 657);
            return false;
        }
        if (AuthenticationStatus.SYNC_DISABLED.equals((Object)status)) {
            ServletUtils.sendError(resp, 658);
            return false;
        }
        ServletUtils.sendError(resp, 403);
        return false;
    }

    public void after(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
    }

    protected AuthenticationStatus getAuthenticationStatus(String nodeId, String securityToken) {
        AuthenticationStatus retVal = AuthenticationStatus.ACCEPTED;
        if (this.nodeService.findNode(nodeId) == null) {
            retVal = AuthenticationStatus.REGISTRATION_REQUIRED;
        } else if (!this.syncEnabled(nodeId)) {
            retVal = AuthenticationStatus.SYNC_DISABLED;
        } else if (!this.nodeService.isNodeAuthorized(nodeId, securityToken)) {
            retVal = AuthenticationStatus.FORBIDDEN;
        }
        return retVal;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected boolean syncEnabled(String nodeId) {
        boolean syncEnabled = false;
        Node node = this.nodeService.findNode(nodeId);
        if (node != null) {
            syncEnabled = node.isSyncEnabled();
        }
        return syncEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationStatus {
        SYNC_DISABLED,
        REGISTRATION_REQUIRED,
        FORBIDDEN,
        ACCEPTED;

    }
}

