/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.web.AbstractUriHandler;

public class BandwidthSamplerUriHandler
extends AbstractUriHandler {
    private static final long serialVersionUID = 1L;
    protected long defaultTestSlowBandwidthDelay = 0L;

    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        long testSlowBandwidthDelay = this.parameterService != null ? this.parameterService.getLong("test.slow.bandwidth.delay") : this.defaultTestSlowBandwidthDelay;
        long sampleSize = 1000L;
        try {
            sampleSize = Long.parseLong(req.getParameter("sampleSize"));
        }
        catch (Exception ex) {
            this.log.warn("BandwidthSampleSizeParsingFailed", new Object[]{req.getParameter("sampleSize")});
        }
        ServletOutputStream os = res.getOutputStream();
        int i = 0;
        while ((long)i < sampleSize) {
            os.write(1);
            if (testSlowBandwidthDelay > 0L) {
                AppUtils.sleep((long)testSlowBandwidthDelay);
            }
            ++i;
        }
    }

    public void setDefaultTestSlowBandwidthDelay(long defaultTestSlowBandwidthDelay) {
        this.defaultTestSlowBandwidthDelay = defaultTestSlowBandwidthDelay;
    }
}

