/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.web.AbstractUriHandler;

public class InfoUriHandler
extends AbstractUriHandler {
    private static final long serialVersionUID = 1L;
    private INodeService nodeService;
    private IConfigurationService configurationService;

    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        res.setContentType("text/plain");
        Node node = this.nodeService.findIdentity();
        List nodeGroups = this.configurationService.getNodeGroups();
        Properties properties = new Properties();
        properties.setProperty("external.id", this.parameterService.getExternalId());
        properties.setProperty("group.id", this.parameterService.getNodeGroupId());
        properties.setProperty("external.id", this.parameterService.getExternalId());
        if (nodeGroups != null) {
            StringBuilder b = new StringBuilder();
            for (NodeGroup nodeGroup : nodeGroups) {
                b.append(nodeGroup.getNodeGroupId());
                b.append(",");
            }
            properties.setProperty("group.ids", b.substring(0, b.length() - 1));
        }
        if (node != null) {
            properties.setProperty("node.id", node.getNodeId());
            properties.setProperty("database.type", node.getDatabaseType());
            properties.setProperty("database.version", node.getDatabaseVersion());
            properties.setProperty("deployment.type", node.getDeploymentType());
            properties.setProperty("timezone.offset", node.getTimezoneOffset());
            properties.setProperty("symmetric.version", node.getSymmetricVersion());
        }
        properties.store((OutputStream)res.getOutputStream(), "SymmetricDS");
        res.flushBuffer();
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

