/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.web.AbstractCompressionUriHandler;
import org.jumpmind.symmetric.web.ServletUtils;

public class PullUriHandler
extends AbstractCompressionUriHandler {
    private INodeService nodeService;
    private IConfigurationService configurationService;
    private IDataExtractorService dataExtractorService;
    private IRegistrationService registrationService;
    private IStatisticManager statisticManager;

    public void handleWithCompression(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        this.log.debug("ServletPulling", new Object[]{nodeId});
        if (StringUtils.isBlank((String)nodeId)) {
            ServletUtils.sendError(res, 400, "Node must be specified");
            return;
        }
        ChannelMap map = new ChannelMap();
        map.addSuspendChannels(req.getHeader("Suspended-Channels"));
        map.addIgnoreChannels(req.getHeader("Ignored-Channels"));
        this.pull(nodeId, req.getRemoteHost(), req.getRemoteAddr(), (OutputStream)res.getOutputStream(), map);
        this.log.debug("ServletPulled", new Object[]{nodeId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(String nodeId, String remoteHost, String remoteAddress, OutputStream outputStream, ChannelMap map) throws IOException {
        INodeService nodeService = this.getNodeService();
        NodeSecurity nodeSecurity = nodeService.findNodeSecurity(nodeId);
        long ts = System.currentTimeMillis();
        try {
            ChannelMap remoteSuspendIgnoreChannelsList = this.configurationService.getSuspendIgnoreChannelLists(nodeId);
            map.addSuspendChannels((Collection)remoteSuspendIgnoreChannelsList.getSuspendChannels());
            map.addIgnoreChannels((Collection)remoteSuspendIgnoreChannelsList.getIgnoreChannels());
            if (nodeSecurity != null) {
                if (nodeSecurity.isRegistrationEnabled()) {
                    this.registrationService.registerNode(nodeService.findNode(nodeId), remoteHost, remoteAddress, outputStream, false);
                } else {
                    IOutgoingTransport outgoingTransport = this.createOutgoingTransport(outputStream, map);
                    this.dataExtractorService.extract(nodeService.findNode(nodeId), outgoingTransport);
                    outgoingTransport.close();
                }
            } else {
                this.log.warn("NodeMissing", new Object[]{nodeId});
            }
        }
        finally {
            this.statisticManager.incrementNodesPulled(1L);
            this.statisticManager.incrementTotalNodesPulledTime(System.currentTimeMillis() - ts);
        }
    }

    private INodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public IConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }
}

