/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.ServletUtils;

public class PushUriHandler
extends AbstractUriHandler {
    private IDataLoaderService dataLoaderService;
    private IStatisticManager statisticManager;

    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        this.log.debug("DataPushing", new Object[]{nodeId});
        InputStream inputStream = this.createInputStream(req);
        ServletOutputStream outputStream = res.getOutputStream();
        this.push(inputStream, (OutputStream)outputStream);
        res.flushBuffer();
        this.log.debug("DataPushingCompleted", new Object[]{nodeId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(InputStream inputStream, OutputStream outputStream) throws IOException {
        long ts = System.currentTimeMillis();
        try {
            this.getDataLoaderService().loadData(inputStream, outputStream);
        }
        finally {
            this.statisticManager.incrementNodesPushed(1L);
            this.statisticManager.incrementTotalNodesPushedTime(System.currentTimeMillis() - ts);
        }
    }

    protected InputStream createInputStream(HttpServletRequest req) throws IOException {
        Object is = null;
        String contentType = req.getHeader("Content-Type");
        boolean useCompression = contentType != null && contentType.equalsIgnoreCase("gzip");
        is = req.getInputStream();
        if (useCompression) {
            is = new GZIPInputStream((InputStream)is);
        }
        return is;
    }

    private IDataLoaderService getDataLoaderService() {
        return this.dataLoaderService;
    }

    public void setDataLoaderService(IDataLoaderService dataLoaderService) {
        this.dataLoaderService = dataLoaderService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }
}

