/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.RegistrationRedirectException;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.ServletUtils;

public class RegistrationUriHandler
extends AbstractUriHandler {
    private IRegistrationService registrationService;

    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Node node = this.transform(req);
        try {
            ServletOutputStream outputStream = res.getOutputStream();
            if (!this.registerNode(node, req.getRemoteHost(), req.getRemoteAddr(), (OutputStream)outputStream)) {
                this.log.warn("RegistrationNotAllowed", new Object[]{node});
                ServletUtils.sendError(res, 656, String.format("%s was not allowed to register.", node));
            }
        }
        catch (RegistrationRedirectException e) {
            res.sendRedirect(HttpTransportManager.buildRegistrationUrl((String)e.getRedirectionUrl(), (Node)node));
        }
    }

    private Node transform(HttpServletRequest req) {
        Node node = new Node();
        node.setNodeGroupId(ServletUtils.getParameter(req, "nodeGroupId"));
        node.setSymmetricVersion(ServletUtils.getParameter(req, "symmetricVersion"));
        node.setExternalId(ServletUtils.getParameter(req, "externalId"));
        String syncUrlString = ServletUtils.getParameter(req, "syncURL");
        if (StringUtils.isNotBlank((String)syncUrlString)) {
            node.setSyncUrl(syncUrlString);
        }
        node.setSchemaVersion(ServletUtils.getParameter(req, "schemaVersion"));
        node.setDatabaseType(ServletUtils.getParameter(req, "databaseType"));
        node.setDatabaseVersion(ServletUtils.getParameter(req, "databaseVersion"));
        return node;
    }

    protected boolean registerNode(Node node, String remoteHost, String remoteAddress, OutputStream outputStream) throws IOException {
        return this.getRegistrationService().registerNode(node, remoteHost, remoteAddress, outputStream, true);
    }

    private IRegistrationService getRegistrationService() {
        return this.registrationService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }
}

