/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricEngineHolder;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.IUriHandler;
import org.jumpmind.symmetric.web.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected final ILog log = LogFactory.getLog(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String method = req.getMethod();
        ISymmetricEngine engine = this.findEngine(req);
        IUriHandler handler = this.findMatchingHandler(engine, req);
        if (handler != null) {
            List<IInterceptor> interceptors = handler.getInterceptors();
            try {
                if (interceptors != null) {
                    for (IInterceptor interceptor : interceptors) {
                        if (interceptor.before(req, res)) continue;
                        return;
                    }
                }
                handler.handle(req, res);
                return;
            }
            catch (Exception e) {
                this.logException(req, e, !(e instanceof IOException) || !StringUtils.isNotBlank((String)e.getMessage()));
                if (!res.isCommitted()) {
                    ServletUtils.sendError(res, 500);
                }
            }
            finally {
                if (interceptors == null) return;
                for (IInterceptor interceptor : interceptors) {
                    interceptor.after(req, res);
                }
                return;
            }
        }
        this.log.error("HandlerNotFound", new Object[]{ServletUtils.normalizeRequestUri(req), req.getRemoteHost(), req.getRemoteAddr(), req.getQueryString()});
        if (method.equals("GET")) {
            res.sendRedirect("/");
            return;
        } else {
            ServletUtils.sendError(res, 403);
        }
    }

    protected ISymmetricEngine findEngine(HttpServletRequest req) {
        String engineName = SymmetricServlet.getEngineNameFromUrl(req);
        ISymmetricEngine engine = null;
        SymmetricEngineHolder holder = ServletUtils.getSymmetricEngineHolder(this.getServletContext());
        if (holder != null) {
            if (engineName != null) {
                engine = (ISymmetricEngine)holder.getEngines().get(engineName);
            }
            if (engine == null && holder.getEngines().size() > 0) {
                engine = (ISymmetricEngine)holder.getEngines().values().iterator().next();
            }
        }
        return engine;
    }

    protected static String getEngineNameFromUrl(HttpServletRequest req) {
        String normalizedUri;
        String engineName = null;
        int startIndex = (normalizedUri = ServletUtils.normalizeRequestUri(req)).startsWith("/") ? 1 : 0;
        int endIndex = normalizedUri.indexOf("/", startIndex);
        if (endIndex > 0) {
            engineName = normalizedUri.substring(startIndex, endIndex);
        }
        return engineName;
    }

    protected Collection<IUriHandler> getUriHandlersFrom(ISymmetricEngine engine) {
        if (engine != null) {
            return engine.getApplicationContext().getBeansOfType(IUriHandler.class).values();
        }
        return null;
    }

    protected IUriHandler findMatchingHandler(ISymmetricEngine engine, HttpServletRequest req) throws ServletException {
        Collection<IUriHandler> handlers = this.getUriHandlersFrom(engine);
        if (handlers != null) {
            for (IUriHandler handler : handlers) {
                if (!this.matchesUriPattern(this.normalizeUri(engine, req), handler.getUriPattern()) || !handler.isEnabled()) continue;
                return handler;
            }
        }
        return null;
    }

    protected boolean matchesUriPattern(String uri, String uriPattern) {
        boolean retVal = false;
        String path = StringUtils.defaultIfEmpty((String)uri, (String)"/");
        String pattern = StringUtils.defaultIfEmpty((String)uriPattern, (String)"/");
        if ("/".equals(pattern) || "/*".equals(pattern) || pattern.equals(path)) {
            retVal = true;
        } else {
            String[] patternParts = StringUtils.split((String)pattern, (String)"/");
            String[] pathParts = StringUtils.split((String)path, (String)"/");
            boolean matches = true;
            for (int i = 0; i < patternParts.length && i < pathParts.length && matches; ++i) {
                String patternPart = patternParts[i];
                matches = "*".equals(patternPart) || patternPart.equals(pathParts[i]);
            }
            retVal = matches;
        }
        return retVal;
    }

    protected String normalizeUri(ISymmetricEngine engine, HttpServletRequest req) {
        String removeString;
        String uri = ServletUtils.normalizeRequestUri(req);
        if (engine != null && uri.startsWith(removeString = "/" + engine.getEngineName())) {
            uri = uri.substring(removeString.length());
        }
        return uri;
    }

    protected void logException(HttpServletRequest req, Exception ex, boolean isError) {
        String method;
        String nodeId = req.getParameter("nodeId");
        String externalId = req.getParameter("externalId");
        String address = req.getRemoteAddr();
        String hostName = req.getRemoteHost();
        String string = method = req instanceof HttpServletRequest ? req.getMethod() : "";
        if (this.log.isErrorEnabled() && isError) {
            this.log.error("ServletProcessingFailedError", (Throwable)ex, new Object[]{method, externalId, nodeId, address, hostName, ServletUtils.normalizeRequestUri(req)});
        } else if (this.log.isWarnEnabled()) {
            this.log.warn("ServletProcessingFailedWarning", new Object[]{method, externalId, nodeId, address, hostName, ex.getMessage()});
        }
    }
}

