/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.web.compression.CompressionResponseStream;

public class CompressionServletResponseWrapper
extends HttpServletResponseWrapper {
    static final ILog log = LogFactory.getLog(CompressionServletResponseWrapper.class);
    int compressionLevel = -1;
    int compressionStrategy = 0;
    protected HttpServletResponse origResponse = null;
    protected static final String info = "CompressionServletResponseWrapper";
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    protected String contentType = null;

    public CompressionServletResponseWrapper(HttpServletResponse response, int compressionLevel, int compressionStrategy) {
        super(response);
        this.compressionLevel = compressionLevel;
        this.compressionStrategy = compressionStrategy;
        this.origResponse = response;
        log.debug("CompressionServletStarting");
    }

    public void setContentType(String contentType) {
        log.debug("CompressionServletSettingType", new Object[]{contentType});
        this.contentType = contentType;
        this.origResponse.setContentType(contentType);
    }

    public ServletOutputStream createOutputStream() throws IOException {
        log.debug("CompressionServletCreatingStream");
        CompressionResponseStream stream = new CompressionResponseStream(this.origResponse, this.compressionLevel, this.compressionStrategy);
        return stream;
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        log.debug("CompressionServletFlushingBuffer");
        ((CompressionResponseStream)this.stream).flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        log.debug("CompressionServletStreamSettingOutput", new Object[]{this.stream});
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        log.debug("CompressionServletStreamSettingWriter", new Object[]{this.stream});
        String charEnc = this.origResponse.getCharacterEncoding();
        log.debug("CompressionServletCharacterEncoding", new Object[]{charEnc});
        this.writer = charEnc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, charEnc)) : new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    public void setContentLength(int length) {
    }
}

