/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constant;

import org.h2.util.MathUtils;

public class SysProperties {
    public static final String H2_SCRIPT_DIRECTORY = "h2.scriptDirectory";
    public static final String H2_MAX_QUERY_TIMEOUT = "h2.maxQueryTimeout";
    public static final String H2_COLLATOR_CACHE_SIZE = "h2.collatorCacheSize";
    public static final String FILE_ENCODING = SysProperties.getStringSetting("file.encoding", "Cp1252");
    public static final String FILE_SEPARATOR = SysProperties.getStringSetting("file.separator", "/");
    public static final String JAVA_SPECIFICATION_VERSION = SysProperties.getStringSetting("java.specification.version", "1.4");
    public static final String LINE_SEPARATOR = SysProperties.getStringSetting("line.separator", "\n");
    public static final String USER_HOME = SysProperties.getStringSetting("user.home", "");
    public static final int ANALYZE_SAMPLE = SysProperties.getIntSetting("h2.analyzeSample", 10000);
    public static final int ANALYZE_AUTO = SysProperties.getIntSetting("h2.analyzeAuto", 0);
    public static final boolean ALIAS_COLUMN_NAME = SysProperties.getBooleanSetting("h2.aliasColumnName", false);
    public static final boolean ALLOW_BIG_DECIMAL_EXTENSIONS = SysProperties.getBooleanSetting("h2.allowBigDecimalExtensions", false);
    public static final String ALLOWED_CLASSES = SysProperties.getStringSetting("h2.allowedClasses", "*");
    public static final String BROWSER = SysProperties.getStringSetting("h2.browser", null);
    public static final boolean ENABLE_ANONYMOUS_SSL = SysProperties.getBooleanSetting("h2.enableAnonymousSSL", true);
    public static final String BIND_ADDRESS = SysProperties.getStringSetting("h2.bindAddress", null);
    public static final int CACHE_SIZE_DEFAULT = SysProperties.getIntSetting("h2.cacheSizeDefault", 16384);
    public static final String CACHE_TYPE_DEFAULT = SysProperties.getStringSetting("h2.cacheTypeDefault", "LRU");
    public static final boolean CHECK = SysProperties.getBooleanSetting("h2.check", true);
    public static final boolean CHECK2 = SysProperties.getBooleanSetting("h2.check2", false);
    public static final String CLIENT_TRACE_DIRECTORY = SysProperties.getStringSetting("h2.clientTraceDirectory", "trace.db/");
    public static final int QUERY_CACHE_SIZE = SysProperties.getIntSetting("h2.queryCacheSize", 0);
    public static final boolean CONSOLE_STREAM = SysProperties.getBooleanSetting("h2.consoleStream", true);
    public static final boolean DATABASE_TO_UPPER = SysProperties.getBooleanSetting("h2.databaseToUpper", true);
    public static final String DEFAULT_ESCAPE = SysProperties.getStringSetting("h2.defaultEscape", "\\");
    public static final int DEFAULT_MAX_OPERATION_MEMORY = SysProperties.getIntSetting("h2.defaultMaxOperationMemory", 100000);
    public static final int DEFAULT_MAX_LENGTH_INPLACE_LOB = SysProperties.getIntSetting("h2.defaultMaxLengthInplaceLob", 4096);
    public static final int DEFAULT_MAX_LENGTH_INPLACE_LOB2 = SysProperties.getIntSetting("h2.defaultMaxLengthInplaceLob2", 128);
    public static final int DEFAULT_RESULT_SET_CONCURRENCY = SysProperties.getIntSetting("h2.defaultResultSetConcurrency", 1007);
    public static final int DATASOURCE_TRACE_LEVEL = SysProperties.getIntSetting("h2.dataSourceTraceLevel", 1);
    public static final int DEFAULT_MAX_MEMORY_UNDO = SysProperties.getIntSetting("h2.defaultMaxMemoryUndo", 50000);
    public static final int DEFAULT_LOCK_MODE = SysProperties.getIntSetting("h2.defaultLockMode", 3);
    public static final int DELAY_WRONG_PASSWORD_MIN = SysProperties.getIntSetting("h2.delayWrongPasswordMin", 250);
    public static final int DELAY_WRONG_PASSWORD_MAX = SysProperties.getIntSetting("h2.delayWrongPasswordMax", 4000);
    public static final boolean DROP_RESTRICT = SysProperties.getBooleanSetting("h2.dropRestrict", false);
    public static final int ESTIMATED_FUNCTION_TABLE_ROWS = SysProperties.getIntSetting("h2.estimatedFunctionTableRows", 1000);
    public static final boolean FUNCTIONS_IN_SCHEMA = SysProperties.getBooleanSetting("h2.functionsInSchema", false);
    public static final boolean IDENTIFIERS_TO_UPPER = SysProperties.getBooleanSetting("h2.identifiersToUpper", true);
    public static final int LARGE_RESULT_BUFFER_SIZE = SysProperties.getIntSetting("h2.largeResultBufferSize", 4096);
    public static final boolean LARGE_TRANSACTIONS = SysProperties.getBooleanSetting("h2.largeTransactions", false);
    public static boolean lobCloseBetweenReads = SysProperties.getBooleanSetting("h2.lobCloseBetweenReads", false);
    public static final int LOB_FILES_PER_DIRECTORY = SysProperties.getIntSetting("h2.lobFilesPerDirectory", 256);
    public static final boolean LOB_IN_DATABASE = SysProperties.getBooleanSetting("h2.lobInDatabase", false);
    public static final boolean LOG_ALL_ERRORS = SysProperties.getBooleanSetting("h2.logAllErrors", false);
    public static final String LOG_ALL_ERRORS_FILE = SysProperties.getStringSetting("h2.logAllErrorsFile", "h2errors.txt");
    public static final int MAX_COMPACT_COUNT = SysProperties.getIntSetting("h2.maxCompactCount", Integer.MAX_VALUE);
    public static final int MAX_COMPACT_TIME = SysProperties.getIntSetting("h2.maxCompactTime", 1000);
    public static final int MAX_FILE_RETRY = Math.max(1, SysProperties.getIntSetting("h2.maxFileRetry", 16));
    public static final int MAX_MEMORY_ROWS_DISTINCT = SysProperties.getIntSetting("h2.maxMemoryRowsDistinct", Integer.MAX_VALUE);
    public static final int MAX_RECONNECT = SysProperties.getIntSetting("h2.maxReconnect", 3);
    public static final long MAX_TRACE_DATA_LENGTH = SysProperties.getIntSetting("h2.maxTraceDataLength", 65535);
    public static final int MIN_COLUMN_NAME_MAP = SysProperties.getIntSetting("h2.minColumnNameMap", 3);
    public static final int MIN_WRITE_DELAY = SysProperties.getIntSetting("h2.minWriteDelay", 5);
    public static final boolean NESTED_JOINS = SysProperties.getBooleanSetting("h2.nestedJoins", false);
    public static final boolean NIO_LOAD_MAPPED = SysProperties.getBooleanSetting("h2.nioLoadMapped", false);
    public static final boolean NIO_CLEANER_HACK = SysProperties.getBooleanSetting("h2.nioCleanerHack", false);
    public static final boolean OBJECT_CACHE = SysProperties.getBooleanSetting("h2.objectCache", true);
    public static final int OBJECT_CACHE_MAX_PER_ELEMENT_SIZE = SysProperties.getIntSetting("h2.objectCacheMaxPerElementSize", 4096);
    public static final int OBJECT_CACHE_SIZE = MathUtils.nextPowerOf2(SysProperties.getIntSetting("h2.objectCacheSize", 1024));
    public static final boolean OPTIMIZE_DISTINCT = SysProperties.getBooleanSetting("h2.optimizeDistinct", true);
    public static final boolean OPTIMIZE_EVALUATABLE_SUBQUERIES = SysProperties.getBooleanSetting("h2.optimizeEvaluatableSubqueries", true);
    public static final boolean OPTIMIZE_IN_LIST = SysProperties.getBooleanSetting("h2.optimizeInList", true);
    public static final boolean OPTIMIZE_IS_NULL = SysProperties.getBooleanSetting("h2.optimizeIsNull", true);
    public static final boolean OPTIMIZE_OR = SysProperties.getBooleanSetting("h2.optimizeOr", false);
    public static final boolean OPTIMIZE_SUBQUERY_CACHE = SysProperties.getBooleanSetting("h2.optimizeSubqueryCache", true);
    public static final boolean OPTIMIZE_TWO_EQUALS = SysProperties.getBooleanSetting("h2.optimizeTwoEquals", true);
    public static final int PAGE_SIZE = SysProperties.getIntSetting("h2.pageSize", 2048);
    public static final boolean PAGE_STORE_TRIM = SysProperties.getBooleanSetting("h2.pageStoreTrim", true);
    public static final boolean PAGE_STORE_INTERNAL_COUNT = SysProperties.getBooleanSetting("h2.pageStoreInternalCount", false);
    public static final String PG_DEFAULT_CLIENT_ENCODING = SysProperties.getStringSetting("h2.pgClientEncoding", "UTF-8");
    public static final String PREFIX_TEMP_FILE = SysProperties.getStringSetting("h2.prefixTempFile", "h2.temp");
    public static final boolean RECOMPILE_ALWAYS = SysProperties.getBooleanSetting("h2.recompileAlways", false);
    public static final int RECONNECT_CHECK_DELAY = SysProperties.getIntSetting("h2.reconnectCheckDelay", 200);
    public static final int REDO_BUFFER_SIZE = SysProperties.getIntSetting("h2.redoBufferSize", 262144);
    public static final int RESERVE_MEMORY = SysProperties.getIntSetting("h2.reserveMemory", 524288);
    public static final boolean RETURN_LOB_OBJECTS = SysProperties.getBooleanSetting("h2.returnLobObjects", true);
    public static boolean runFinalize = SysProperties.getBooleanSetting("h2.runFinalize", true);
    public static final boolean SELECT_FOR_UPDATE_MVCC = SysProperties.getBooleanSetting("h2.selectForUpdateMvcc", false);
    public static final int SERVER_CACHED_OBJECTS = SysProperties.getIntSetting("h2.serverCachedObjects", 64);
    public static final int SERVER_RESULT_SET_FETCH_SIZE = SysProperties.getIntSetting("h2.serverResultSetFetchSize", 100);
    public static final boolean SHARE_LINKED_CONNECTIONS = SysProperties.getBooleanSetting("h2.shareLinkedConnections", true);
    public static final int SOCKET_CONNECT_RETRY = SysProperties.getIntSetting("h2.socketConnectRetry", 16);
    public static final int SOCKET_CONNECT_TIMEOUT = SysProperties.getIntSetting("h2.socketConnectTimeout", 2000);
    public static final boolean SORT_NULLS_HIGH = SysProperties.getBooleanSetting("h2.sortNullsHigh", false);
    public static final long SPLIT_FILE_SIZE_SHIFT = SysProperties.getIntSetting("h2.splitFileSizeShift", 30);
    public static final String SYNC_METHOD = SysProperties.getStringSetting("h2.syncMethod", "sync");
    public static final boolean TRACE_IO = SysProperties.getBooleanSetting("h2.traceIO", false);
    public static final int WEB_MAX_VALUE_LENGTH = SysProperties.getIntSetting("h2.webMaxValueLength", 100000);
    private static final String H2_BASE_DIR = "h2.baseDir";

    private SysProperties() {
    }

    private static boolean getBooleanSetting(String string, boolean bl) {
        String string2 = SysProperties.getProperty(string);
        if (string2 != null) {
            try {
                return Boolean.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static String getProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getStringSetting(String string, String string2) {
        String string3 = SysProperties.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public static int getIntSetting(String string, int n) {
        String string2 = SysProperties.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static void setBaseDir(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        System.setProperty(H2_BASE_DIR, string);
    }

    public static String getBaseDir() {
        return SysProperties.getStringSetting(H2_BASE_DIR, null);
    }

    public static String getScriptDirectory() {
        return SysProperties.getStringSetting(H2_SCRIPT_DIRECTORY, "");
    }

    public static int getMaxQueryTimeout() {
        return SysProperties.getIntSetting(H2_MAX_QUERY_TIMEOUT, 0);
    }

    public static int getCollatorCacheSize() {
        return SysProperties.getIntSetting(H2_COLLATOR_CACHE_SIZE, 32000);
    }
}

