/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.DeploymentType;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.config.PropertiesFactoryBean;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ext.IExtensionPointManager;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IBandwidthService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IPullService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IPushService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ISecurityService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.IUpgradeService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transform.ITransformService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSymmetricEngine
implements ISymmetricEngine {
    protected ILog log = LogFactory.getLog(this.getClass());
    private static Map<String, ISymmetricEngine> registeredEnginesByUrl = new HashMap<String, ISymmetricEngine>();
    private static Map<String, ISymmetricEngine> registeredEnginesByName = new HashMap<String, ISymmetricEngine>();
    private ApplicationContext applicationContext;
    private JdbcTemplate jdbcTemplate;
    private boolean started = false;
    private boolean starting = false;
    private boolean setup = false;
    private IDbDialect dbDialect;
    private IJobManager jobManager;

    protected AbstractSymmetricEngine() {
    }

    public static ISymmetricEngine findEngineByUrl(String url) {
        if (registeredEnginesByUrl != null && url != null) {
            return registeredEnginesByUrl.get(url);
        }
        return null;
    }

    public static ISymmetricEngine findEngineByName(String name) {
        if (registeredEnginesByName != null && name != null) {
            return registeredEnginesByName.get(name);
        }
        return null;
    }

    public static ISymmetricEngine getEngine() {
        int numberOfEngines = registeredEnginesByName.size();
        if (numberOfEngines == 0) {
            return null;
        }
        if (numberOfEngines > 1) {
            throw new IllegalStateException("More than one SymmetricEngine is currently registered");
        }
        return registeredEnginesByName.values().iterator().next();
    }

    @Override
    public synchronized boolean start() {
        return this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean start(boolean startJobs) {
        this.setup();
        if (this.isConfigured()) {
            if (!this.starting && !this.started) {
                try {
                    this.starting = true;
                    Node node = this.getNodeService().findIdentity();
                    if (node != null) {
                        this.log.info("RegisteredNodeStarting", node.getNodeGroupId(), node.getNodeId(), node.getExternalId());
                    } else {
                        this.log.info("UnregisteredNodeStarting", this.getParameterService().getNodeGroupId(), this.getParameterService().getExternalId());
                    }
                    this.getTriggerRouterService().syncTriggers();
                    this.heartbeat(false);
                    if (startJobs) {
                        this.jobManager.startJobs();
                    }
                    this.log.info("SymmetricDSStarted");
                    this.started = true;
                    Object var4_3 = null;
                    this.starting = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.starting = false;
                    throw throwable;
                }
            }
        } else {
            this.log.warn("SymmetricDSNotStarted");
        }
        this.log.info("SymmetricDSInfo", this.getDeploymentType().getDeploymentType(), this.getEngineName(), Version.version(), this.getParameterService().getNodeGroupId(), this.getParameterService().getExternalId(), this.dbDialect.getName(), this.dbDialect.getVersion(), this.dbDialect.getDriverName(), this.dbDialect.getDriverVersion());
        return this.started;
    }

    @Override
    public synchronized void stop() {
        this.log.info("SymmetricDSClosing", this.getParameterService().getExternalId(), Version.version(), this.dbDialect.getName());
        this.jobManager.stopJobs();
        this.getRouterService().stop();
        this.started = false;
        this.starting = false;
    }

    @Override
    public synchronized void destroy() {
        this.stop();
        this.jobManager.destroy();
        this.getRouterService().destroy();
        this.removeMeFromMap(registeredEnginesByName);
        this.removeMeFromMap(registeredEnginesByUrl);
        DataSource ds = this.jdbcTemplate.getDataSource();
        if (ds instanceof BasicDataSource) {
            try {
                ((BasicDataSource)ds).close();
            }
            catch (SQLException ex) {
                this.log.error(ex);
            }
        }
        this.applicationContext = null;
        this.jdbcTemplate = null;
        this.dbDialect = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(ApplicationContext ctx, boolean isParentContext, Properties overrideProperties, String overridePropertiesResource1, String overridePropertiesResource2) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            try {
                if (overrideProperties != null) {
                    PropertiesFactoryBean.setLocalProperties(overrideProperties);
                }
                if (!StringUtils.isBlank((String)overridePropertiesResource1)) {
                    System.setProperty("symmetric.override.properties.file.1", overridePropertiesResource1);
                }
                if (!StringUtils.isBlank((String)overridePropertiesResource2)) {
                    System.setProperty("symmetric.override.properties.file.2", overridePropertiesResource2);
                }
                if (isParentContext || ctx == null) {
                    this.init(this.createContext(ctx));
                } else {
                    this.init(ctx);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                PropertiesFactoryBean.clearLocalProperties();
                throw throwable;
            }
            PropertiesFactoryBean.clearLocalProperties();
        }
    }

    protected void init(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.log = LogFactory.getLog(this.getParameterService());
        this.dbDialect = (IDbDialect)AppUtils.find("dbDialect", this);
        this.jobManager = (IJobManager)AppUtils.find("jobManager", this);
        this.jdbcTemplate = (JdbcTemplate)AppUtils.find("jdbcTemplate", this);
        IExtensionPointManager extMgr = (IExtensionPointManager)this.applicationContext.getBean("extensionManager");
        extMgr.register();
        this.getDeploymentType().setEngineRegistered(true);
    }

    protected abstract ApplicationContext createContext(ApplicationContext var1);

    private void removeMeFromMap(Map<String, ISymmetricEngine> map) {
        HashSet<String> keys = new HashSet<String>(map.keySet());
        for (String key : keys) {
            if (!map.get(key).equals(this)) continue;
            map.remove(key);
        }
    }

    private void registerEngine() {
        String url = this.getSyncUrl();
        ISymmetricEngine alreadyRegister = registeredEnginesByUrl.get(url);
        if (alreadyRegister == null || alreadyRegister.equals(this)) {
            if (url != null) {
                registeredEnginesByUrl.put(url, this);
            }
        } else {
            throw new IllegalStateException("Could not register engine.  There was already an engine registered under the url: " + this.getSyncUrl());
        }
        alreadyRegister = registeredEnginesByName.get(this.getEngineName());
        if (alreadyRegister != null && !alreadyRegister.equals(this)) {
            throw new IllegalStateException("Could not register engine.  There was already an engine registered under the name: " + this.getEngineName());
        }
        registeredEnginesByName.put(this.getEngineName(), this);
    }

    @Override
    public String getSyncUrl() {
        Node node = this.getNodeService().findIdentity();
        if (node != null) {
            return node.getSyncUrl();
        }
        return this.getParameterService().getSyncUrl();
    }

    @Override
    public Properties getProperties() {
        Properties p = new Properties();
        p.putAll(this.getParameterService().getAllParameters());
        return p;
    }

    @Override
    public String getEngineName() {
        return this.dbDialect.getEngineName();
    }

    @Override
    public synchronized void setup() {
        AppUtils.cleanupTempFiles();
        this.getParameterService().rereadParameters();
        if (!this.setup) {
            this.setupDatabase(false);
            this.setup = true;
        }
        this.registerEngine();
    }

    @Override
    public String reloadNode(String nodeId) {
        return this.getDataService().reloadNode(nodeId);
    }

    @Override
    public String sendSQL(String nodeId, String catalogName, String schemaName, String tableName, String sql) {
        return this.getDataService().sendSQL(nodeId, catalogName, schemaName, tableName, sql, false);
    }

    @Override
    public RemoteNodeStatuses push() {
        return this.getPushService().pushData();
    }

    @Override
    public void syncTriggers() {
        this.getTriggerRouterService().syncTriggers();
    }

    @Override
    public NodeStatus getNodeStatus() {
        return this.getNodeService().getNodeStatus();
    }

    @Override
    public RemoteNodeStatuses pull() {
        return this.getPullService().pullData();
    }

    @Override
    public void route() {
        this.getRouterService().routeData();
    }

    @Override
    public void purge() {
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.getParameterService().getString("start.purge.job"))) {
            throw new UnsupportedOperationException("Cannot actuate a purge if it is already scheduled.");
        }
        this.getPurgeService().purgeOutgoing();
    }

    @Override
    public void setupDatabase(boolean force) {
        this.getConfigurationService().autoConfigDatabase(force);
        if (this.getUpgradeService().isUpgradeNecessary()) {
            if (this.getParameterService().is("auto.upgrade")) {
                try {
                    if (!this.getUpgradeService().isUpgradePossible()) {
                        throw new SymmetricException("SymmetricDSManualUpgradeNeeded", this.getNodeService().findSymmetricVersion(), Version.version());
                    }
                    this.getUpgradeService().upgrade();
                    this.getConfigurationService().autoConfigDatabase(force);
                }
                catch (RuntimeException ex) {
                    this.log.fatal("SymmetricDSUpgradeFailed", ex);
                    throw ex;
                }
            } else {
                throw new SymmetricException("SymmetricDSUpgradeNeeded");
            }
        }
        this.getClusterService().initLockTable();
    }

    @Override
    public boolean isConfigured() {
        boolean configurationValid = false;
        IDbDialect dbDialect = this.getDbDialect();
        boolean isRegistrationServer = this.getNodeService().isRegistrationServer();
        boolean isSelfConfigurable = isRegistrationServer && (this.getParameterService().is("auto.insert.registration.svr.if.not.found", false) || StringUtils.isNotBlank((String)this.getParameterService().getString("auto.config.registration.svr.sql.script")));
        Table symNodeTable = dbDialect.getTable(dbDialect.getDefaultCatalog(), dbDialect.getDefaultSchema(), TableConstants.getTableName(dbDialect.getTablePrefix(), "node"), false);
        Node node = symNodeTable != null ? this.getNodeService().findIdentity() : null;
        long offlineNodeDetectionPeriodSeconds = this.getParameterService().getLong("offline.node.detection.period.minutes") * 60L;
        long heartbeatSeconds = this.getParameterService().getLong("heartbeat.sync.on.push.period.sec");
        String registrationUrl = this.getParameterService().getRegistrationUrl();
        if (!isSelfConfigurable && node == null && isRegistrationServer) {
            this.log.warn("ValidationRegServerIsMissingConfiguration", "registration.url");
        } else if (!isSelfConfigurable && node == null && StringUtils.isBlank((String)this.getParameterService().getRegistrationUrl())) {
            this.log.warn("ValidationSetRegistrationUrl", "registration.url");
        } else if ("please set me".equals(this.getParameterService().getExternalId()) || "please set me".equals(registrationUrl) || "please set me".equals(this.getParameterService().getNodeGroupId())) {
            this.log.warn("ValidationPleaseSetMe");
        } else if (!(node == null || node.getExternalId().equals(this.getParameterService().getExternalId()) && node.getNodeGroupId().equals(this.getParameterService().getNodeGroupId()))) {
            this.log.warn("ValidationComparePropertiesToDatabase", node.getExternalId(), this.getParameterService().getExternalId(), node.getNodeGroupId(), this.getParameterService().getNodeGroupId());
        } else if (node != null && StringUtils.isBlank((String)this.getParameterService().getRegistrationUrl()) && StringUtils.isBlank((String)this.getParameterService().getSyncUrl())) {
            this.log.warn("ValidationMakeSureSyncUrlIsSet");
        } else if (offlineNodeDetectionPeriodSeconds > 0L && offlineNodeDetectionPeriodSeconds <= heartbeatSeconds) {
            this.log.warn("ValidationOfflineSettings", "offline.node.detection.period.minutes", "heartbeat.sync.on.push.period.sec");
        } else {
            configurationValid = true;
        }
        return configurationValid;
    }

    @Override
    public void heartbeat(boolean force) {
        this.getDataService().heartbeat(force);
    }

    @Override
    public void openRegistration(String groupId, String externalId) {
        this.getRegistrationService().openRegistration(groupId, externalId);
    }

    @Override
    public void reOpenRegistration(String nodeId) {
        this.getRegistrationService().reOpenRegistration(nodeId);
    }

    @Override
    public boolean isRegistered() {
        return this.getNodeService().findIdentity() != null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStarting() {
        return this.starting;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public IConfigurationService getConfigurationService() {
        return (IConfigurationService)AppUtils.find("configurationService", this);
    }

    @Override
    public IParameterService getParameterService() {
        return (IParameterService)AppUtils.find("parameterService", this);
    }

    @Override
    public INodeService getNodeService() {
        return (INodeService)AppUtils.find("nodeService", this);
    }

    @Override
    public DeploymentType getDeploymentType() {
        return (DeploymentType)AppUtils.find("deploymentType", this);
    }

    @Override
    public IRegistrationService getRegistrationService() {
        return (IRegistrationService)AppUtils.find("registrationService", this);
    }

    @Override
    public IUpgradeService getUpgradeService() {
        return (IUpgradeService)AppUtils.find("upgradeService", this);
    }

    @Override
    public IClusterService getClusterService() {
        return (IClusterService)AppUtils.find("clusterService", this);
    }

    @Override
    public IPurgeService getPurgeService() {
        return (IPurgeService)AppUtils.find("purgeService", this);
    }

    @Override
    public IDataService getDataService() {
        return (IDataService)AppUtils.find("dataService", this);
    }

    @Override
    public IDbDialect getDbDialect() {
        return this.dbDialect;
    }

    @Override
    public IJobManager getJobManager() {
        return this.jobManager;
    }

    @Override
    public IOutgoingBatchService getOutgoingBatchService() {
        return (IOutgoingBatchService)AppUtils.find("outgoingBatchService", this);
    }

    @Override
    public IAcknowledgeService getAcknowledgeService() {
        return (IAcknowledgeService)AppUtils.find("acknowledgeService", this);
    }

    @Override
    public IBandwidthService getBandwidthService() {
        return (IBandwidthService)AppUtils.find("bandwidthService", this);
    }

    @Override
    public IDataExtractorService getDataExtractorService() {
        return (IDataExtractorService)AppUtils.find("dataExtractorService", this);
    }

    @Override
    public IDataLoaderService getDataLoaderService() {
        return (IDataLoaderService)AppUtils.find("dataLoaderService", this);
    }

    @Override
    public IIncomingBatchService getIncomingBatchService() {
        return (IIncomingBatchService)AppUtils.find("incomingBatchService", this);
    }

    @Override
    public IPullService getPullService() {
        return (IPullService)AppUtils.find("pullService", this);
    }

    @Override
    public IPushService getPushService() {
        return (IPushService)AppUtils.find("pushService", this);
    }

    @Override
    public IRouterService getRouterService() {
        return (IRouterService)AppUtils.find("routingService", this);
    }

    @Override
    public ISecurityService getSecurityService() {
        return (ISecurityService)AppUtils.find("securityService", this);
    }

    @Override
    public IStatisticManager getStatisticManager() {
        return (IStatisticManager)AppUtils.find("statisticManager", this);
    }

    @Override
    public IStatisticService getStatisticService() {
        return (IStatisticService)AppUtils.find("statisticService", this);
    }

    @Override
    public ITriggerRouterService getTriggerRouterService() {
        return (ITriggerRouterService)AppUtils.find("triggerRouterService", this);
    }

    @Override
    public DataSource getDataSource() {
        return (DataSource)AppUtils.find("dataSource", this);
    }

    @Override
    public ITransformService getTransformService() {
        return (ITransformService)AppUtils.find("transformService", this);
    }

    @Override
    public String getTablePrefix() {
        return this.getParameterService().getTablePrefix();
    }
}

