/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.DbNotSupportedException;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.PlatformFactory;
import org.jumpmind.symmetric.ddl.PlatformUtils;
import org.jumpmind.symmetric.ddl.platform.db2.Db2Platform;
import org.jumpmind.symmetric.ddl.platform.derby.DerbyPlatform;
import org.jumpmind.symmetric.ddl.platform.firebird.FirebirdPlatform;
import org.jumpmind.symmetric.ddl.platform.greenplum.GreenplumPlatform;
import org.jumpmind.symmetric.ddl.platform.h2.H2Platform;
import org.jumpmind.symmetric.ddl.platform.hsqldb.HsqlDbPlatform;
import org.jumpmind.symmetric.ddl.platform.hsqldb2.HsqlDb2Platform;
import org.jumpmind.symmetric.ddl.platform.informix.InformixPlatform;
import org.jumpmind.symmetric.ddl.platform.interbase.InterbasePlatform;
import org.jumpmind.symmetric.ddl.platform.mssql.MSSqlPlatform;
import org.jumpmind.symmetric.ddl.platform.mysql.MySqlPlatform;
import org.jumpmind.symmetric.ddl.platform.oracle.Oracle10Platform;
import org.jumpmind.symmetric.ddl.platform.oracle.Oracle8Platform;
import org.jumpmind.symmetric.ddl.platform.oracle.Oracle9Platform;
import org.jumpmind.symmetric.ddl.platform.postgresql.PostgreSqlPlatform;
import org.jumpmind.symmetric.ddl.platform.sqlite.SqLitePlatform;
import org.jumpmind.symmetric.ddl.platform.sybase.SybasePlatform;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbDialectFactory
implements FactoryBean<IDbDialect>,
BeanFactoryAware {
    private static final ILog log = LogFactory.getLog(DbDialectFactory.class);
    private String db2zSeriesProductVersion;
    private JdbcTemplate jdbcTemplate;
    private BeanFactory beanFactory;
    private int queryTimeout;
    private boolean forceDelimitedIdentifierModeOn = false;
    private boolean forceDelimitedIdentifierModeOff = false;

    public IDbDialect getObject() throws Exception {
        this.waitForAvailableDatabase();
        Platform pf = PlatformFactory.createNewPlatformInstance((DataSource)this.jdbcTemplate.getDataSource());
        if (this.forceDelimitedIdentifierModeOn) {
            pf.setDelimitedIdentifierModeOn(true);
        }
        if (this.forceDelimitedIdentifierModeOff) {
            pf.setDelimitedIdentifierModeOn(false);
        }
        AbstractDbDialect dialect = null;
        if (pf instanceof MySqlPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("mysqlDialect");
        } else if (pf instanceof Oracle8Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("oracleDialect");
        } else if (pf instanceof Oracle9Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("oracleDialect");
        } else if (pf instanceof Oracle10Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("oracleDialect");
        } else if (pf instanceof MSSqlPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("msSqlDialect");
        } else if (pf instanceof GreenplumPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("greenplumDialect");
        } else if (pf instanceof PostgreSqlPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("postgresqlDialect");
        } else if (pf instanceof DerbyPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("derbyDialect");
        } else if (pf instanceof H2Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("h2Dialect");
        } else if (pf instanceof SqLitePlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("sqliteDialect");
        } else if (pf instanceof HsqlDbPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("hsqldbDialect");
        } else if (pf instanceof HsqlDb2Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("hsqldb2Dialect");
        } else if (pf instanceof InformixPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("informixDialect");
        } else if (pf instanceof Db2Platform) {
            String currentDbProductVersion = PlatformUtils.getDatabaseProductVersion((DataSource)this.jdbcTemplate.getDataSource());
            if (currentDbProductVersion.equals(this.db2zSeriesProductVersion)) {
                dialect = (AbstractDbDialect)this.beanFactory.getBean("db2zSeriesDialect");
            } else {
                int dbMajorVersion = PlatformUtils.getDatabaseMajorVersion((DataSource)this.jdbcTemplate.getDataSource());
                int dbMinorVersion = PlatformUtils.getDatabaseMinorVersion((DataSource)this.jdbcTemplate.getDataSource());
                dialect = dbMajorVersion < 9 || dbMajorVersion == 9 && dbMinorVersion < 5 ? (AbstractDbDialect)this.beanFactory.getBean("db2Dialect") : (AbstractDbDialect)this.beanFactory.getBean("db2v9Dialect");
            }
        } else if (pf instanceof FirebirdPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("firebirdDialect");
        } else if (pf instanceof SybasePlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("sybaseDialect");
        } else if (pf instanceof InterbasePlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("interbaseDialect");
        } else {
            throw new DbNotSupportedException();
        }
        dialect.init(pf, this.queryTimeout, this.jdbcTemplate);
        return dialect;
    }

    private void waitForAvailableDatabase() {
        boolean success = false;
        while (!success) {
            try {
                this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                    public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                        return null;
                    }
                });
                success = true;
            }
            catch (CannotGetJdbcConnectionException ex) {
                log.error("DatabaseConnectionException", ex.getMessage());
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Class<IDbDialect> getObjectType() {
        return IDbDialect.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setDb2zSeriesProductVersion(String version) {
        this.db2zSeriesProductVersion = version;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setForceDelimitedIdentifierModeOn(boolean forceDelimitedIdentifierModeOn) {
        this.forceDelimitedIdentifierModeOn = forceDelimitedIdentifierModeOn;
    }

    public void setForceDelimitedIdentifierModeOff(boolean forceDelimitedIdentifierModeOff) {
        this.forceDelimitedIdentifierModeOff = forceDelimitedIdentifierModeOff;
    }
}

