/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ext.IDatabaseUpgradeListener;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.lob.LobHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDbDialect {
    public void createTrigger(StringBuilder var1, DataEventType var2, Trigger var3, TriggerHistory var4, Channel var5, String var6, Table var7);

    public String getEngineName();

    public void removeTrigger(StringBuilder var1, String var2, String var3, String var4, String var5, TriggerHistory var6);

    public boolean doesTriggerExist(String var1, String var2, String var3, String var4);

    public void allowIdentityInserts(JdbcTemplate var1, Table var2);

    public void revertAllowIdentityInserts(JdbcTemplate var1, Table var2);

    public Database readPlatformDatabase(boolean var1);

    public void resetCachedTableModel();

    public boolean doesDatabaseNeedConfigured();

    public void initTablesAndFunctions();

    public Platform getPlatform();

    public String getName();

    public String getVersion();

    public int getMajorVersion();

    public int getMinorVersion();

    public String getProductVersion();

    public BinaryEncoding getBinaryEncoding();

    public String encodeForCsv(byte[] var1);

    public Table getTable(String var1, String var2, String var3, boolean var4);

    public Table getTable(Trigger var1, boolean var2);

    public String getTransactionTriggerExpression(String var1, String var2, Trigger var3);

    public String createInitialLoadSqlFor(Node var1, TriggerRouter var2, Table var3, TriggerHistory var4, Channel var5);

    public String createPurgeSqlFor(Node var1, TriggerRouter var2);

    public String createCsvDataSql(Trigger var1, TriggerHistory var2, Channel var3, String var4);

    public String createCsvPrimaryKeySql(Trigger var1, TriggerHistory var2, Channel var3, String var4);

    public boolean isBlankCharColumnSpacePadded();

    public boolean isNonBlankCharColumnSpacePadded();

    public boolean isCharColumnSpaceTrimmed();

    public boolean isEmptyStringNulled();

    public int getMaxTriggerNameLength();

    public boolean supportsTransactionId();

    public int getQueryTimeoutInSeconds();

    public boolean supportsTransactionViews();

    @Deprecated
    public boolean requiresSavepointForFallback();

    public Object createSavepoint(JdbcTemplate var1);

    @Deprecated
    public Object createSavepointForFallback(JdbcTemplate var1);

    public void rollbackToSavepoint(JdbcTemplate var1, Object var2);

    public void releaseSavepoint(JdbcTemplate var1, Object var2);

    public IColumnFilter newDatabaseColumnFilter();

    public void purge();

    public void disableSyncTriggers(JdbcTemplate var1);

    public void disableSyncTriggers(JdbcTemplate var1, String var2);

    public void enableSyncTriggers(JdbcTemplate var1);

    public String getSyncTriggersExpression();

    public String getSourceNodeExpression();

    public String getDefaultSchema();

    public String getDefaultCatalog();

    public int getStreamingResultsFetchSize();

    public String getCreateSymmetricDDL();

    public String getCreateTableXML(TriggerRouter var1);

    public String getCreateTableSQL(TriggerRouter var1);

    public boolean isBlobSyncSupported();

    public boolean isDateOverrideToTimestamp();

    public boolean isClobSyncSupported();

    public boolean isTransactionIdOverrideSupported();

    public String getIdentifierQuoteString();

    public void createTables(String var1);

    public boolean supportsGetGeneratedKeys();

    public boolean supportsReturningKeys();

    public String getSelectLastInsertIdSql(String var1);

    public long insertWithGeneratedKey(String var1, SequenceIdentifier var2);

    public long insertWithGeneratedKey(String var1, SequenceIdentifier var2, PreparedStatementCallback<Object> var3);

    public long insertWithGeneratedKey(JdbcTemplate var1, String var2, SequenceIdentifier var3, PreparedStatementCallback<Object> var4);

    public Column[] orderColumns(String[] var1, Table var2);

    public Object[] getObjectValues(BinaryEncoding var1, String[] var2, Column[] var3);

    public Object[] getObjectValues(BinaryEncoding var1, Table var2, String[] var3, String[] var4);

    public String getTablePrefix();

    public int getRouterDataPeekAheadCount();

    public boolean supportsOpenCursorsAcrossCommit();

    public Set<String> getSqlKeywords();

    public String getInitialLoadTableAlias();

    public String preProcessTriggerSqlClause(String var1);

    public String toFormattedTimestamp(Date var1);

    public void truncateTable(String var1);

    public long getDatabaseTime();

    public boolean areDatabaseTransactionsPendingSince(long var1);

    public boolean requiresAutoCommitFalseToSetFetchSize();

    public LobHandler getLobHandler();

    public boolean needsToSelectLobData();

    public boolean isLob(int var1);

    public boolean isClob(int var1);

    public boolean isBlob(int var1);

    public String getDataHasChangedCondition(Trigger var1);

    public Map<String, String> getSqlScriptReplacementTokens();

    public String scrubSql(String var1);

    public StringBuilder scrubSql(StringBuilder var1);

    public boolean canGapsOccurInCapturedDataIds();

    public String massageDataExtractionSql(String var1, Channel var2);

    public String massageForLob(String var1, Channel var2);

    public boolean escapesTemplatesForDatabaseInserts();

    public String getMasterCollation();

    public boolean supportsBatchUpdates();

    public void cleanupTriggers();

    public void addDatabaseUpgradeListener(IDatabaseUpgradeListener var1);

    public String getDriverName();

    public String getDriverVersion();

    public StatementBuilder createStatementBuilder(StatementBuilder.DmlType var1, String var2, Column[] var3, Column[] var4, Column[] var5);

    public boolean isPrimaryKeyViolation(Exception var1);

    public JdbcTemplate getJdbcTemplate();
}

