/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.oracle.OracleDbDialect;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcBatchPreparedStatementCallback
implements PreparedStatementCallback<Integer> {
    static final ILog log = LogFactory.getLog(JdbcBatchPreparedStatementCallback.class);
    private static boolean firstInitialization = true;
    BatchPreparedStatementSetter pss;
    IDbDialect dbDialect;
    int executeBatchSize;

    public JdbcBatchPreparedStatementCallback(IDbDialect dbDialect, BatchPreparedStatementSetter pss, int executeBatchSize) {
        this.pss = pss;
        this.dbDialect = dbDialect;
        this.executeBatchSize = executeBatchSize;
    }

    protected boolean setupForOracleBatching(PreparedStatement ps) {
        boolean oracleStyle = false;
        if (ps instanceof DelegatingPreparedStatement) {
            DelegatingPreparedStatement dps = (DelegatingPreparedStatement)ps;
            if (this.dbDialect instanceof OracleDbDialect) {
                try {
                    Class<?> clazz = Class.forName("oracle.jdbc.OraclePreparedStatement");
                    Statement delegate = dps.getDelegate();
                    if (clazz.isInstance(delegate)) {
                        Method method = clazz.getMethod("setExecuteBatch", Integer.TYPE);
                        method.invoke((Object)delegate, this.executeBatchSize);
                        oracleStyle = true;
                        if (firstInitialization) {
                            log.info("OracleBatchingUsed", this.executeBatchSize);
                            firstInitialization = false;
                        }
                    }
                }
                catch (Exception ex) {
                    log.warn(ex);
                }
            }
        }
        return oracleStyle;
    }

    public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
        int rowsAffected = 0;
        boolean oracleStyle = this.setupForOracleBatching(ps);
        int batchSize = this.pss.getBatchSize();
        if (JdbcUtils.supportsBatchUpdates((Connection)ps.getConnection()) && this.dbDialect.supportsBatchUpdates()) {
            for (int i = 0; i < batchSize; ++i) {
                int[] results;
                this.pss.setValues(ps, i);
                if (oracleStyle) {
                    rowsAffected += ps.executeUpdate();
                    continue;
                }
                ps.addBatch();
                if (i % this.executeBatchSize != 0 && i != batchSize - 1) continue;
                for (int j : results = ps.executeBatch()) {
                    rowsAffected += j;
                }
            }
            return rowsAffected;
        }
        for (int i = 0; i < batchSize; ++i) {
            this.pss.setValues(ps, i);
            rowsAffected += ps.executeUpdate();
        }
        return rowsAffected;
    }
}

