/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.hsqldb;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Trigger;
import org.jumpmind.symmetric.db.AbstractEmbeddedTrigger;
import org.jumpmind.symmetric.db.hsqldb.HsqlDbFunctions;

public class HsqlDbTrigger
extends AbstractEmbeddedTrigger
implements Trigger {
    protected String triggerName;
    protected Map<String, String> templates = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fire(int type, String triggerName, String tableName, Object[] oldRow, Object[] newRow) {
        Connection conn = this.findConnection(triggerName);
        if (conn == null) return;
        try {
            try {
                this.init(conn, triggerName, tableName);
                this.fire(conn, oldRow, newRow);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ex) {}
        conn.close();
        return;
    }

    protected Connection findConnection(String triggerName) {
        Connection c = null;
        Vector uris = DatabaseManager.getDatabaseURIs();
        for (String uri : uris) {
            Connection testCon = null;
            try {
                testCon = DriverManager.getConnection("jdbc:hsqldb:" + uri, new Properties());
                if (uris.size() > 1) {
                    Statement stmt = testCon.createStatement();
                    ResultSet rs = stmt.executeQuery(String.format("select count(*) from %s%s", triggerName, "_CONFIG"));
                    rs.close();
                    stmt.close();
                }
                c = testCon;
                break;
            }
            catch (SQLException e) {
                try {
                    if (testCon == null) continue;
                    testCon.close();
                }
                catch (SQLException e1) {}
            }
        }
        return c;
    }

    protected Object appendVirtualTableStringValue(Object value, StringBuilder out) {
        if (value != null && (value.getClass().getName().equals("org.hsqldb.types.Binary") || value.getClass().getName().equals("org.hsqldb.types.BinaryData"))) {
            out.append("'");
            try {
                Method getBytes = value.getClass().getMethod("getBytes", new Class[0]);
                value = HsqlDbFunctions.encodeBase64((byte[])getBytes.invoke(value, new Object[0]));
                out.append(this.escapeString(value));
                out.append("'");
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            return super.appendVirtualTableStringValue(value, out);
        }
        return value;
    }
}

