/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.hsqldb2;

import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.springframework.jdbc.core.JdbcTemplate;

public class HsqlDb2Dialect
extends AbstractDbDialect
implements IDbDialect {
    public void init(Platform pf, int queryTimeout, JdbcTemplate jdbcTemplate) {
        super.init(pf, queryTimeout, jdbcTemplate);
        jdbcTemplate.execute("SET DATABASE DEFAULT TABLE TYPE CACHED");
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schemaName, String tableName, String triggerName) {
        boolean exists = this.jdbcTemplate.queryForInt("select count(*) from INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_NAME = ?", new Object[]{triggerName}) > 0;
        return exists;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        String dropSql = String.format("DROP TRIGGER %s", triggerName);
        this.logSql(dropSql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                int count = this.jdbcTemplate.update(dropSql);
                if (count > 0) {
                    this.log.info("TriggerDropped", triggerName);
                }
            }
            catch (Exception e) {
                this.log.warn("TriggerDropError", triggerName, e.getMessage());
            }
        }
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('sync_prevented','1')");
        jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('node_value','" + nodeId + "')");
    }

    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('sync_prevented',null)");
        jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('node_value',null)");
    }

    public String getSyncTriggersExpression() {
        return " " + this.tablePrefix + "_get_session('sync_prevented') is null ";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "call IDENTITY()";
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public boolean isBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean supportsTransactionId() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("delete from " + tableName);
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return (String)this.jdbcTemplate.queryForObject("select value from INFORMATION_SCHEMA.SYSTEM_SESSIONINFO where key='CURRENT SCHEMA'", String.class);
    }

    public boolean canGapsOccurInCapturedDataIds() {
        return false;
    }
}

