/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.informix;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.AutoIncrementColumnFilter;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.model.Trigger;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformixDbDialect
extends AbstractDbDialect
implements IDbDialect {
    private Map<String, String> sqlScriptReplacementTokens = new HashMap<String, String>();

    public InformixDbDialect() {
        this.sqlScriptReplacementTokens.put("current_timestamp", "current");
    }

    @Override
    public void init(Platform pf, int queryTimeout, JdbcTemplate jdbcTemplate) {
        super.init(pf, queryTimeout, jdbcTemplate);
        Map<String, String> env = System.getenv();
        String clientIdentifierMode = env.get("DELIMIDENT");
        this.identifierQuoteString = clientIdentifierMode != null && clientIdentifierMode.equalsIgnoreCase("y") ? "\"" : "";
    }

    @Override
    public IColumnFilter newDatabaseColumnFilter() {
        return new AutoIncrementColumnFilter();
    }

    @Override
    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        return this.jdbcTemplate.queryForInt("select count(*) from systriggers where lower(trigname) = ?", new Object[]{triggerName.toLowerCase()}) > 0;
    }

    @Override
    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        jdbcTemplate.queryForList("select " + this.tablePrefix + "_triggers_set_disabled('t'), " + this.tablePrefix + "_node_set_disabled(?) from sysmaster:sysdual", new Object[]{nodeId});
    }

    @Override
    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.queryForList("select " + this.tablePrefix + "_triggers_set_disabled('f'), " + this.tablePrefix + "_node_set_disabled(null) from sysmaster:sysdual");
    }

    @Override
    public String getSyncTriggersExpression() {
        return "not $(defaultSchema)" + this.tablePrefix + "_triggers_disabled()";
    }

    @Override
    public boolean supportsTransactionId() {
        return false;
    }

    @Override
    public boolean isTransactionIdOverrideSupported() {
        return false;
    }

    @Override
    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    @Override
    public boolean isBlobSyncSupported() {
        return false;
    }

    @Override
    public boolean isClobSyncSupported() {
        return false;
    }

    @Override
    public boolean allowsNullForIdentityColumn() {
        return false;
    }

    @Override
    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    @Override
    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    @Override
    public boolean isEmptyStringNulled() {
        return false;
    }

    @Override
    public void purge() {
    }

    @Override
    public String getDefaultCatalog() {
        return null;
    }

    @Override
    public String getDefaultSchema() {
        String defaultSchema = super.getDefaultSchema();
        if (StringUtils.isBlank((String)defaultSchema)) {
            defaultSchema = (String)this.jdbcTemplate.queryForObject("select trim(user) from sysmaster:sysdual", String.class);
        }
        return defaultSchema;
    }

    @Override
    public Map<String, String> getSqlScriptReplacementTokens() {
        return this.sqlScriptReplacementTokens;
    }
}

