/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.oracle;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class OracleDbDialect
extends AbstractDbDialect
implements IDbDialect {
    static final String ORACLE_OBJECT_TYPE = "FUNCTION";
    String selectTriggerSql;
    String selectTransactionsSql;

    public void init(Platform pf, int queryTimeout, JdbcTemplate jdbcTemplate) {
        block2: {
            super.init(pf, queryTimeout, jdbcTemplate);
            try {
                this.areDatabaseTransactionsPendingSince(System.currentTimeMillis());
                this.supportsTransactionViews = true;
            }
            catch (Exception ex) {
                if (!this.parameterService.is("oracle.use.transaction.view")) break block2;
                this.log.warn(ex);
            }
        }
    }

    protected void initLobHandler() {
        this.lobHandler = new OracleLobHandler();
        try {
            Class<NativeJdbcExtractor> clazz = Class.forName(this.parameterService.getString("db.native.extractor")).asSubclass(NativeJdbcExtractor.class);
            NativeJdbcExtractor nativeJdbcExtractor = clazz.newInstance();
            ((OracleLobHandler)this.lobHandler).setNativeJdbcExtractor(nativeJdbcExtractor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createTrigger(StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table table) {
        try {
            super.createTrigger(sqlBuffer, dml, trigger, history, channel, tablePrefix, table);
        }
        catch (BadSqlGrammarException ex) {
            if (ex.getSQLException().getErrorCode() == 4095) {
                try {
                    this.log.warn("TriggerAlreadyExists", this.jdbcTemplate.queryForMap("select * " + this.selectTriggerSql, new Object[]{history.getTriggerNameForDmlType(dml), history.getSourceTableName()}));
                }
                catch (DataAccessException e) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return true;
    }

    public boolean isDateOverrideToTimestamp() {
        return true;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.tablePrefix + "_" + "transaction_id()";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    protected String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case OUTGOING_BATCH: {
                return "SEQ_SYM_OUTGOIN_BATCH_BATCH_ID";
            }
            case DATA: {
                return "SEQ_SYM_DATA_DATA_ID";
            }
            case TRIGGER_HIST: {
                return "SEQ_SYM_TRIGGER_RIGGER_HIST_ID";
            }
        }
        return null;
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select " + sequenceName + ".currval from dual";
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        return this.jdbcTemplate.queryForInt("select count(*) " + this.selectTriggerSql, new Object[]{triggerName, tableName}) > 0;
    }

    public void purge() {
        this.jdbcTemplate.update("purge recyclebin");
    }

    protected String getSymmetricPackageName() {
        return this.tablePrefix + "_pkg";
    }

    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        jdbcTemplate.update(String.format("call %s.setValue(1)", this.getSymmetricPackageName()));
        if (nodeId != null) {
            jdbcTemplate.update(String.format("call %s.setNodeValue('" + nodeId + "')", this.getSymmetricPackageName()));
        }
    }

    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.update(String.format("call %s.setValue(null)", this.getSymmetricPackageName()));
        jdbcTemplate.update(String.format("call %s.setNodeValue(null)", this.getSymmetricPackageName()));
    }

    public String getSyncTriggersExpression() {
        return this.tablePrefix + "_trigger_disabled() is null";
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        String defaultSchema = super.getDefaultSchema();
        if (StringUtils.isBlank((String)defaultSchema)) {
            defaultSchema = (String)this.jdbcTemplate.queryForObject("SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM dual", String.class);
        }
        return defaultSchema;
    }

    public boolean areDatabaseTransactionsPendingSince(long time) {
        String returnValue = (String)this.jdbcTemplate.queryForObject(this.selectTransactionsSql, String.class);
        if (returnValue != null) {
            try {
                Date date = DateUtils.parseDate((String)returnValue, (String[])new String[]{"MM/dd/yy HH:mm:ss"});
                return date.getTime() < time;
            }
            catch (ParseException e) {
                this.log.error(e);
                return true;
            }
        }
        return false;
    }

    public void setSelectTransactionsSql(String selectTransactionSql) {
        this.selectTransactionsSql = selectTransactionSql;
    }

    public void setSelectTriggerSql(String selectTriggerSql) {
        this.selectTriggerSql = selectTriggerSql;
    }

    public boolean supportsTransactionViews() {
        return this.supportsTransactionViews && this.parameterService.is("oracle.use.transaction.view");
    }

    public String massageDataExtractionSql(String sql, Channel channel) {
        if (channel != null && !channel.isContainsBigLob()) {
            sql = StringUtils.replace((String)sql, (String)"d.row_data", (String)"dbms_lob.substr(d.row_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.old_data", (String)"dbms_lob.substr(d.old_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.pk_data", (String)"dbms_lob.substr(d.pk_data, 4000, 1 )");
        }
        return sql;
    }

    public String massageForLob(String sql, Channel channel) {
        if (channel != null && !channel.isContainsBigLob()) {
            return String.format("dbms_lob.substr(%s, 4000, 1)", sql);
        }
        return super.massageForLob(sql, channel);
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        if (!trigger.isUseCaptureLobs()) {
            return "var_row_data != var_old_data";
        }
        return "dbms_lob.compare(nvl(var_row_data,'Null'),nvl(var_old_data,'Null')) != 0 ";
    }
}

