/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.postgresql;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.postgresql.PostgresSqlStatementBuilder;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgreSqlDbDialect
extends AbstractDbDialect
implements IDbDialect {
    static final String TRANSACTION_ID_EXPRESSION = "txid_current()";
    static final String SYNC_TRIGGERS_DISABLED_VARIABLE = "symmetric.triggers_disabled";
    static final String SYNC_NODE_DISABLED_VARIABLE = "symmetric.node_disabled";
    private boolean supportsTransactionId = false;
    private String transactionIdExpression = "null";

    public void init(Platform pf, int queryTimeout, JdbcTemplate jdbcTemplate) {
        super.init(pf, 0, jdbcTemplate);
    }

    protected void initTablesAndFunctionsForSpecificDialect() {
        if (this.getMajorVersion() > 8 || this.getMajorVersion() == 8 && this.getMinorVersion() >= 3) {
            this.log.info("TransactionIDSupportEnabling");
            this.supportsTransactionId = true;
            this.transactionIdExpression = TRANSACTION_ID_EXPRESSION;
        }
        try {
            this.enableSyncTriggers(this.jdbcTemplate);
        }
        catch (Exception e) {
            this.log.error("PostgreSqlCustomVariableMissing");
            throw new SymmetricException("PostgreSqlCustomVariableMissing", e);
        }
    }

    public boolean requiresAutoCommitFalseToSetFetchSize() {
        return true;
    }

    public Object[] getObjectValues(BinaryEncoding encoding, String[] values, Column[] orderedMetaData) {
        Object[] objectValues = super.getObjectValues(encoding, values, orderedMetaData);
        for (int i = 0; i < orderedMetaData.length; ++i) {
            if (orderedMetaData[i] == null || orderedMetaData[i].getTypeCode() != 2004 || objectValues[i] == null) continue;
            try {
                objectValues[i] = new SerialBlob((byte[])objectValues[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return objectValues;
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        return this.jdbcTemplate.queryForInt("select count(*) from information_schema.triggers where trigger_name = ? and event_object_table = ? and trigger_schema = ?", new Object[]{triggerName.toLowerCase(), tableName, schema == null ? this.getDefaultSchema() : schema}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        schemaName = schemaName == null ? "" : schemaName + ".";
        String dropSql = "drop trigger " + triggerName + " on " + schemaName + tableName;
        this.logSql(dropSql, sqlBuffer);
        String dropFunction = "drop function " + schemaName + "f" + triggerName + "()";
        this.logSql(dropFunction, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                this.jdbcTemplate.update(dropSql);
                this.jdbcTemplate.update(dropFunction);
            }
            catch (Exception e) {
                this.log.warn("TriggerDoesNotExist");
            }
        }
    }

    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        jdbcTemplate.queryForList("select set_config('symmetric.triggers_disabled', '1', false)");
        if (nodeId == null) {
            nodeId = "";
        }
        jdbcTemplate.queryForList("select set_config('symmetric.node_disabled', '" + nodeId + "', false)");
    }

    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.queryForList("select set_config('symmetric.triggers_disabled', '', false)");
        jdbcTemplate.queryForList("select set_config('symmetric.node_disabled', '', false)");
    }

    public String getSyncTriggersExpression() {
        return "$(defaultSchema)" + this.tablePrefix + "_triggers_disabled() = 0";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.transactionIdExpression;
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select currval('" + sequenceName + "_seq')";
    }

    public boolean requiresSavepointForFallback() {
        return true;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public boolean supportsTransactionId() {
        return this.supportsTransactionId;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        String defaultSchema = super.getDefaultSchema();
        if (StringUtils.isBlank((String)defaultSchema)) {
            defaultSchema = (String)this.jdbcTemplate.queryForObject("select current_schema()", String.class);
        }
        return defaultSchema;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    protected Array createArray(Column column, final String value) {
        if (StringUtils.isNotBlank((String)value)) {
            String jdbcTypeName = column.getJdbcTypeName();
            if (jdbcTypeName.startsWith("_")) {
                jdbcTypeName = jdbcTypeName.substring(1);
            }
            int jdbcBaseType = 12;
            if (jdbcTypeName.toLowerCase().contains("int")) {
                jdbcBaseType = 4;
            }
            final String baseTypeName = jdbcTypeName;
            final int baseType = jdbcBaseType;
            return new Array(){

                @Override
                public String getBaseTypeName() {
                    return baseTypeName;
                }

                @Override
                public void free() throws SQLException {
                }

                @Override
                public int getBaseType() {
                    return baseType;
                }

                @Override
                public Object getArray() {
                    return null;
                }

                @Override
                public Object getArray(Map<String, Class<?>> map) {
                    return null;
                }

                @Override
                public Object getArray(long index, int count) {
                    return null;
                }

                @Override
                public Object getArray(long index, int count, Map<String, Class<?>> map) {
                    return null;
                }

                @Override
                public ResultSet getResultSet() {
                    return null;
                }

                @Override
                public ResultSet getResultSet(Map<String, Class<?>> map) {
                    return null;
                }

                @Override
                public ResultSet getResultSet(long index, int count) {
                    return null;
                }

                @Override
                public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) {
                    return null;
                }

                public String toString() {
                    return value;
                }
            };
        }
        return null;
    }

    protected String cleanTextForTextBasedColumns(String text) {
        return text.replace("\u0000", "");
    }

    public StatementBuilder createStatementBuilder(StatementBuilder.DmlType type, String tableName, Column[] keys, Column[] columns, Column[] preFilteredColumns) {
        return new PostgresSqlStatementBuilder(type, tableName, keys, columns, preFilteredColumns, this.isDateOverrideToTimestamp(), this.getIdentifierQuoteString());
    }
}

