/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.postgresql;

import org.apache.commons.lang.ArrayUtils;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.load.StatementBuilder;

public class PostgresSqlStatementBuilder
extends StatementBuilder {
    public PostgresSqlStatementBuilder(StatementBuilder.DmlType type, String tableName, Column[] keys, Column[] columns, Column[] preFilteredColumns, boolean isDateOverrideToTimestamp, String identifierQuoteString) {
        super(type, tableName, keys, columns, preFilteredColumns, isDateOverrideToTimestamp, identifierQuoteString);
    }

    public String buildInsertSql(String tableName, Column[] keyColumns, Column[] columns) {
        if (keyColumns != null && keyColumns.length > 0 && keyColumns[0] != null) {
            StringBuilder sql = new StringBuilder("insert into ");
            sql.append(tableName);
            sql.append("(");
            int columnCount = this.appendColumns(sql, columns);
            sql.append(") (select ");
            this.appendColumnQuestions(sql, columnCount);
            sql.append(" where (select 1 from ");
            sql.append(tableName);
            sql.append(" where  ");
            if (keyColumns == null || keyColumns.length == 0) {
                sql.append("1 != 1");
            } else {
                this.appendColumnEquals(sql, keyColumns, " and ");
            }
            sql.append(") is null)");
            return sql.toString();
        }
        return super.buildInsertSql(tableName, this.keys, columns);
    }

    public Column[] getMetaData(boolean prefiltered) {
        if (this.dmlType == StatementBuilder.DmlType.INSERT) {
            return this.getColumnKeyMetaData(prefiltered);
        }
        return super.getMetaData(prefiltered);
    }

    public String[] getValueArray(String[] columnValues, String[] keyValues) {
        if (this.dmlType == StatementBuilder.DmlType.INSERT) {
            return (String[])ArrayUtils.addAll((Object[])columnValues, (Object[])keyValues);
        }
        return super.getValueArray(columnValues, keyValues);
    }

    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        if (this.dmlType == StatementBuilder.DmlType.INSERT) {
            int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
            int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
            return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
        }
        return super.buildTypes(keys, columns, isDateOverrideToTimestamp);
    }
}

