/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.csv.IStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.CsvUtils;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractStreamDataCommand
implements IStreamDataCommand {
    protected static final String DELIMITER = ", ";
    protected final ILog log = LogFactory.getLog(this.getClass());
    protected ITriggerRouterService triggerRouterService;
    protected IDbDialect dbDialect;

    AbstractStreamDataCommand() {
    }

    protected void selectAndEnhanceWithLobsIfEnabled(Data data, DataExtractorContext context) {
        List<Column> lobColumns;
        Table table;
        Trigger trigger;
        TriggerHistory triggerHistory = data.getTriggerHistory();
        if (triggerHistory != null && (trigger = this.findTrigger(triggerHistory)) != null && (table = this.dbDialect.getTable(trigger, true)) != null && trigger.isUseStreamLobs() && (lobColumns = this.getLobColumns(table)).size() > 0) {
            try {
                final String[] columnNames = triggerHistory.getParsedColumnNames();
                final String[] rowData = data.toParsedRowData();
                Column[] orderedColumns = this.dbDialect.orderColumns(columnNames, table);
                Object[] objectValues = this.dbDialect.getObjectValues(this.dbDialect.getBinaryEncoding(), rowData, orderedColumns);
                Map<String, Object> columnDataMap = AppUtils.toMap(columnNames, objectValues);
                Column[] pkColumns = table.getPrimaryKeyColumns();
                String sql = this.buildSelect(table, lobColumns, pkColumns);
                JdbcTemplate template = context.getJdbcTemplate();
                Object[] args = new Object[pkColumns.length];
                int[] types = new int[pkColumns.length];
                for (int i = 0; i < pkColumns.length; ++i) {
                    args[i] = columnDataMap.get(pkColumns[i].getName());
                    types[i] = pkColumns[i].getTypeCode();
                }
                template.query(sql, args, types, (RowMapper)new RowMapper<Object>(){

                    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                        LobHandler lobHandler = AbstractStreamDataCommand.this.dbDialect.getLobHandler();
                        if (lobHandler == null) {
                            lobHandler = new DefaultLobHandler();
                        }
                        for (Column col : lobColumns) {
                            String valueForCsv = null;
                            if (AbstractStreamDataCommand.this.dbDialect.isBlob(col.getTypeCode())) {
                                byte[] blobBytes = lobHandler.getBlobAsBytes(rs, col.getName());
                                valueForCsv = AbstractStreamDataCommand.this.dbDialect.encodeForCsv(blobBytes);
                            } else {
                                String clobText;
                                valueForCsv = clobText = lobHandler.getClobAsString(rs, col.getName());
                            }
                            int index = ArrayUtils.indexOf((Object[])columnNames, (Object)col.getName());
                            rowData[index] = valueForCsv;
                        }
                        return null;
                    }
                });
                data.setRowData(CsvUtils.escapeCsvData(rowData));
            }
            catch (IncorrectResultSizeDataAccessException ex) {
                this.log.warn("DataExtractorRowMissingCannotGetLobData", data.getRowData());
            }
            catch (Exception ex) {
                throw new SymmetricException("DataExtractorTroubleExtractingLobData", (Throwable)ex, data.getRowData());
            }
        }
    }

    protected Trigger findTrigger(TriggerHistory triggerHistory) {
        List<TriggerRouter> trList;
        Map<String, List<TriggerRouter>> cache;
        Trigger trigger = null;
        if (triggerHistory != null && this.triggerRouterService != null && (cache = this.triggerRouterService.getTriggerRoutersForCurrentNode(false)) != null && (trList = cache.get(triggerHistory.getTriggerId())) != null && trList.size() > 0) {
            trigger = trList.get(0).getTrigger();
        }
        return trigger;
    }

    protected String buildSelect(Table table, List<Column> lobColumns, Column[] pkColumns) {
        StringBuilder sql = new StringBuilder("select ");
        String quote = this.dbDialect.getIdentifierQuoteString();
        for (Column col : lobColumns) {
            sql.append(quote);
            sql.append(col.getName());
            sql.append(quote);
            sql.append(",");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(" from ");
        sql.append(table.getFullyQualifiedTableName());
        sql.append(" where ");
        for (Column col : pkColumns) {
            sql.append(quote);
            sql.append(col.getName());
            sql.append(quote);
            sql.append("=? and ");
        }
        sql.delete(sql.length() - 5, sql.length());
        return sql.toString();
    }

    protected List<Column> getLobColumns(Table table) {
        Column[] allColumns;
        ArrayList<Column> lobColumns = new ArrayList<Column>(1);
        for (Column column : allColumns = table.getColumns()) {
            if (!this.dbDialect.isLob(column.getTypeCode())) continue;
            lobColumns.add(column);
        }
        return lobColumns;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerRouterService) {
        this.triggerRouterService = triggerRouterService;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }
}

