/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.csv.CsvExtractor16;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.CsvUtils;

public class CsvExtractor
extends CsvExtractor16 {
    protected ITriggerRouterService triggerRouterService;

    public void init(Writer writer, DataExtractorContext context) throws IOException {
        super.init(writer, context);
        CsvUtils.write(writer, "binary", ", ", this.dbDialect.getBinaryEncoding().name());
        CsvUtils.writeLineFeed(writer);
    }

    public void begin(OutgoingBatch batch, Writer writer) throws IOException {
        CsvUtils.write(writer, "channel", ", ", batch.getChannelId());
        CsvUtils.writeLineFeed(writer);
        CsvUtils.write(writer, "batch", ", ", Long.toString(batch.getBatchId()));
        CsvUtils.writeLineFeed(writer);
    }

    public void preprocessTable(Data data, String routerId, Writer out, DataExtractorContext context) throws IOException {
        if (data.getTriggerHistory() == null) {
            throw new RuntimeException("Missing trigger_hist for table " + data.getTableName() + ": try running syncTriggers() or restarting SymmetricDS");
        }
        if (!data.getTriggerHistory().getSourceTableName().toLowerCase().equals(data.getTableName().toLowerCase())) {
            throw new RuntimeException(String.format("The table name captured in the data table (%1$s) does not match the table name recorded in the trigger_hist table (%2$s).  Please drop the symmetric triggers on %1$s and restart the server", data.getTableName(), data.getTriggerHistory().getSourceTableName()));
        }
        String triggerHistoryId = Integer.toString(data.getTriggerHistory().getTriggerHistoryId()).intern();
        if (!context.getHistoryRecordsWritten().contains(triggerHistoryId)) {
            this.writeTable(data, routerId, out, context);
            String keyCsv = data.getTriggerHistory().getPkColumnNames();
            if (StringUtils.isNotBlank((String)keyCsv)) {
                context.incrementByteCount(CsvUtils.write(out, "keys", ", ", keyCsv));
            } else {
                context.incrementByteCount(CsvUtils.write(out, "keys"));
            }
            CsvUtils.writeLineFeed(out);
            context.incrementByteCount(CsvUtils.write(out, "columns", ", ", data.getTriggerHistory().getColumnNames()));
            CsvUtils.writeLineFeed(out);
            context.addHistoryRecordWritten(data.getTableName(), triggerHistoryId);
        } else if (!context.isLastDataFromSameTriggerAndRouter(triggerHistoryId, routerId)) {
            this.writeTable(data, routerId, out, context);
        }
        if ((data.getEventType() == DataEventType.UPDATE || data.getEventType() == DataEventType.DELETE) && data.getOldData() != null && this.parameterService.is("dataextractor.old.data.enable")) {
            context.incrementByteCount(CsvUtils.write(out, "old", ", ", data.getOldData()));
            CsvUtils.writeLineFeed(out);
        }
        context.setLastRouterId(routerId);
        context.setLastTriggerHistoryId(triggerHistoryId);
    }

    protected void writeTable(Data data, String routerId, Writer out, DataExtractorContext context) throws IOException {
        Router router = this.triggerRouterService.getActiveRouterByIdForCurrentNode(routerId, false);
        String schemaName = router == null ? "" : this.getTargetName(router.getTargetSchemaName());
        context.incrementByteCount(CsvUtils.write(out, "schema", ", ", schemaName));
        CsvUtils.writeLineFeed(out);
        String catalogName = router == null ? "" : this.getTargetName(router.getTargetCatalogName());
        context.incrementByteCount(CsvUtils.write(out, "catalog", ", ", catalogName));
        CsvUtils.writeLineFeed(out);
        String tableName = router == null || router.getTargetTableName() == null ? data.getTableName() : this.getTargetName(router.getTargetTableName());
        context.incrementByteCount(CsvUtils.write(out, "table", ", ", tableName));
        CsvUtils.writeLineFeed(out);
    }

    protected String getTargetName(String name) {
        String catalogName;
        String string = catalogName = name == null ? "" : name;
        if (StringUtils.isNotBlank((String)catalogName)) {
            catalogName = AppUtils.replaceTokens(catalogName, this.parameterService.getReplacementValues(), true);
        }
        return catalogName;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerRouterService) {
        this.triggerRouterService = triggerRouterService;
    }

    public String getLegacyTableName(String currentTableName) {
        return currentTableName;
    }
}

