/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.INodeGroupDataLoaderFilter;

public abstract class AbstractTableDataLoaderFilter
implements INodeGroupDataLoaderFilter {
    private boolean autoRegister = true;
    private String[] nodeGroupIdsToApplyTo;
    private boolean loadDataInTargetDatabase = true;
    private String tableName;

    public boolean filterDelete(IDataLoaderContext context, String[] keyValues) {
        if (context.getTableName().equals(this.tableName)) {
            this.filterDeleteForTable(context, keyValues);
        }
        return this.loadDataInTargetDatabase;
    }

    protected abstract void filterDeleteForTable(IDataLoaderContext var1, String[] var2);

    public boolean filterInsert(IDataLoaderContext context, String[] columnValues) {
        if (context.getTableName().equals(this.tableName)) {
            this.filterInsertForTable(context, columnValues);
        }
        return this.loadDataInTargetDatabase;
    }

    protected abstract void filterInsertForTable(IDataLoaderContext var1, String[] var2);

    public boolean filterUpdate(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        if (context.getTableName().equals(this.tableName)) {
            this.filterUpdateForTable(context, columnValues, keyValues);
        }
        return this.loadDataInTargetDatabase;
    }

    protected abstract void filterUpdateForTable(IDataLoaderContext var1, String[] var2, String[] var3);

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setNodeGroupIdsToApplyTo(String[] nodeGroupIdsToApplyTo) {
        this.nodeGroupIdsToApplyTo = nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdToApplyTo(String nodeGroupId) {
        this.nodeGroupIdsToApplyTo = new String[]{nodeGroupId};
    }

    public void setLoadDataInTargetDatabase(boolean loadDataInTargetDatabase) {
        this.loadDataInTargetDatabase = loadDataInTargetDatabase;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

