/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.INodeGroupDataLoaderFilter;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditiveDataLoaderFilter
implements INodeGroupDataLoaderFilter {
    private static final ILog log = LogFactory.getLog(AdditiveDataLoaderFilter.class);
    private String tableName;
    private String[] additiveColumnNames;
    private String[] overrideColumnNames;
    private String[] nodeGroups;
    protected JdbcTemplate jdbcTemplate;
    private boolean autoRegister = true;

    @Override
    public boolean filterDelete(IDataLoaderContext context, String[] keyValues) {
        if (!this.tableName.equalsIgnoreCase(context.getTableName())) {
            return true;
        }
        throw new RuntimeException("delete not supported for AdditiveDataLoaderFilter, table: " + context.getTableName() + ", key(s): " + keyValues);
    }

    @Override
    public boolean filterInsert(IDataLoaderContext context, String[] columnValues) {
        if (!this.tableName.equalsIgnoreCase(context.getTableName())) {
            return true;
        }
        String[] keyValues = new String[context.getKeyNames().length];
        for (int i = 0; i < context.getKeyNames().length; ++i) {
            keyValues[i] = columnValues[context.getColumnIndex(context.getKeyNames()[i])];
        }
        boolean result = !this.update(context, columnValues, keyValues);
        return result;
    }

    @Override
    public boolean filterUpdate(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        if (!this.tableName.equalsIgnoreCase(context.getTableName())) {
            return true;
        }
        boolean result = !this.update(context, columnValues, keyValues);
        return result;
    }

    protected boolean update(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        Object[] colData = context.getObjectValues(columnValues);
        Object[] keyData = context.getObjectKeyValues(keyValues);
        StringBuilder s = new StringBuilder();
        s.append("update " + context.getTableName());
        ArrayList<Object> values = new ArrayList<Object>();
        String setClause = this.buildSetClause(context, colData, values);
        if (StringUtils.trimToNull((String)setClause) == null) {
            return false;
        }
        s.append(" set ").append(setClause);
        s.append(this.buildWhereClause(context, keyData, values));
        log.debug("Sql", s);
        return this.jdbcTemplate.update(s.toString(), values.toArray()) > 0;
    }

    protected String buildSetClause(IDataLoaderContext context, Object[] columnValues, List<Object> values) {
        StringBuilder s = new StringBuilder();
        if (this.overrideColumnNames != null || this.additiveColumnNames != null) {
            boolean firstSet = false;
            if (this.overrideColumnNames != null) {
                for (int i = 0; i < this.overrideColumnNames.length; ++i) {
                    int overrideColumnIndex = context.getColumnIndex(this.overrideColumnNames[i]);
                    Object newData = columnValues[overrideColumnIndex];
                    if (newData == null) continue;
                    if (firstSet) {
                        s.append(", ");
                    }
                    firstSet = true;
                    s.append(this.overrideColumnNames[i]);
                    s.append("=?");
                    values.add(newData);
                }
            }
            if (this.additiveColumnNames != null) {
                Object[] oldValues = context.getOldObjectValues();
                for (int i = 0; i < this.additiveColumnNames.length; ++i) {
                    int additiveColumnIndex = context.getColumnIndex(this.additiveColumnNames[i]);
                    Object oldData = oldValues == null ? null : oldValues[additiveColumnIndex];
                    Object newData = columnValues[additiveColumnIndex];
                    if (newData == null || oldData != null && newData.equals(oldData)) continue;
                    if (firstSet) {
                        s.append(", ");
                    }
                    firstSet = true;
                    s.append(this.additiveColumnNames[i]);
                    s.append("=");
                    s.append(this.additiveColumnNames[i]);
                    s.append("+");
                    s.append(newData);
                    if (oldData == null) continue;
                    s.append("-(");
                    s.append(oldData);
                    s.append(")");
                }
            }
        }
        return s.toString();
    }

    protected String buildWhereClause(IDataLoaderContext context, Object[] keyValues, List<Object> values) {
        StringBuilder s = new StringBuilder();
        s.append(" where ");
        for (int i = 0; i < context.getKeyNames().length; ++i) {
            String key = context.getKeyNames()[i];
            s.append(key);
            s.append("=?");
            values.add(keyValues[i]);
            if (i == context.getKeyNames().length - 1) continue;
            s.append(" and ");
        }
        return s.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setNodeGroups(String[] nodeGroups) {
        this.nodeGroups = nodeGroups;
    }

    @Override
    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    @Override
    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroups;
    }

    public String[] getAdditiveColumnNames() {
        return this.additiveColumnNames;
    }

    public void setAdditiveColumnNames(String[] additiveColumnNames) {
        this.additiveColumnNames = additiveColumnNames;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String[] getOverrideColumnNames() {
        return this.overrideColumnNames;
    }

    public void setOverrideColumnNames(String[] overrideColumnNames) {
        this.overrideColumnNames = overrideColumnNames;
    }
}

