/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.TableTemplate;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.INodeService;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLoaderContext
implements IDataLoaderContext {
    static final ILog log = LogFactory.getLog(DataLoaderContext.class);
    private String sourceNodeId;
    private String targetNodeId;
    private String tableName;
    private String schemaName;
    private String catalogName;
    private String channelId;
    private IncomingBatch batch;
    private boolean isSkipping;
    private transient Map<String, TableTemplate> tableTemplateMap;
    private TableTemplate tableTemplate;
    private Map<String, Object> contextCache = new HashMap<String, Object>();
    private BinaryEncoding binaryEncoding = BinaryEncoding.NONE;
    private INodeService nodeService;
    private NodeGroupLink nodeGroupLink;
    private transient Node sourceNode;
    private transient Node targetNode;
    private JdbcTemplate jdbcTemplate;

    public DataLoaderContext(INodeService nodeService, JdbcTemplate jdbcTemplate) {
        this.tableTemplateMap = new HashMap<String, TableTemplate>();
        this.nodeService = nodeService;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public NodeGroupLink getNodeGroupLink() {
        if (this.nodeGroupLink == null && this.sourceNodeId != null) {
            Node sourceNode = this.nodeService.findNode(this.sourceNodeId);
            Node targetNode = this.getTargetNode();
            if (sourceNode != null && targetNode != null) {
                this.nodeGroupLink = new NodeGroupLink(sourceNode.getNodeGroupId(), this.getTargetNode().getNodeGroupId());
            }
        }
        return this.nodeGroupLink;
    }

    @Override
    public Node getNode() {
        return this.getSourceNode();
    }

    @Override
    public Node getSourceNode() {
        if (this.sourceNode == null && this.nodeService != null && this.sourceNodeId != null) {
            this.sourceNode = this.nodeService.findNode(this.sourceNodeId);
        }
        return this.sourceNode;
    }

    @Override
    public Node getTargetNode() {
        if (this.targetNode == null && this.nodeService != null) {
            this.targetNode = this.nodeService.findIdentity();
        }
        return this.targetNode;
    }

    @Override
    public TableTemplate getTableTemplate() {
        return this.tableTemplate;
    }

    private final String getFullQualifiedTableName() {
        return this.catalogName + "." + this.schemaName + "." + this.tableName;
    }

    public void setTableTemplate(TableTemplate tableTemplate) {
        this.tableTemplate = tableTemplate;
        this.tableTemplateMap.put(this.getFullQualifiedTableName(), tableTemplate);
    }

    @Override
    public int getFilteredColumnIndex(String columnName) {
        String[] columnNames = this.tableTemplate.getFilteredColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnNames[i].equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnIndex(String columnName) {
        String[] columnNames = this.tableTemplate.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnNames[i].equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getKeyIndex(String columnName) {
        String[] columnNames = this.tableTemplate.getKeyNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnNames[i].equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Table[] getAllTablesProcessed() {
        Collection<TableTemplate> templates = this.tableTemplateMap.values();
        Table[] tables = new Table[templates.size()];
        int i = 0;
        for (TableTemplate table : templates) {
            tables[i++] = table.getTable();
        }
        return tables;
    }

    public void clearBatch() {
        this.batch = null;
    }

    @Override
    public IncomingBatch getBatch() {
        return this.batch;
    }

    public void setBatchId(long batchId) {
        this.batch = new IncomingBatch(batchId, this);
        this.isSkipping = false;
    }

    @Override
    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    @Override
    public String getNodeId() {
        return this.getSourceNodeId();
    }

    @Override
    public long getBatchId() {
        return this.batch != null ? this.batch.getBatchId() : -1L;
    }

    public void setSourceNodeId(String sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
        this.sourceNode = null;
        this.nodeGroupLink = null;
        this.getNodeGroupLink();
    }

    @Deprecated
    public void setNodeId(String sourceNodeId) {
        this.setSourceNodeId(sourceNodeId);
    }

    @Override
    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String targetNodeId) {
        this.targetNodeId = targetNodeId;
        this.targetNode = null;
        this.nodeGroupLink = null;
        this.getTargetNode();
        this.getNodeGroupLink();
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void chooseTableTemplate() {
        this.tableTemplate = this.tableTemplateMap.get(this.getFullQualifiedTableName());
    }

    @Override
    public String[] getOldData() {
        return this.tableTemplate != null ? this.tableTemplate.getOldData() : null;
    }

    @Override
    public boolean isSkipping() {
        return this.isSkipping;
    }

    public void setSkipping(boolean isSkipping) {
        this.isSkipping = isSkipping;
    }

    @Override
    public String[] getFilteredColumnNames() {
        return this.tableTemplate.getFilteredColumnNames();
    }

    @Override
    public String[] getColumnNames() {
        return this.tableTemplate.getColumnNames();
    }

    public void setColumnNames(String[] columnNames) {
        this.tableTemplate.setColumnNames(columnNames);
    }

    public void setOldData(String[] oldData) {
        this.tableTemplate.setOldData(oldData);
    }

    @Override
    public String[] getKeyNames() {
        return this.tableTemplate.getKeyNames();
    }

    public void setKeyNames(String[] keyNames) {
        this.tableTemplate.setKeyNames(keyNames);
    }

    @Override
    public Map<String, Object> getContextCache() {
        return this.contextCache;
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return this.binaryEncoding;
    }

    public void setBinaryEncoding(BinaryEncoding binaryEncoding) {
        this.binaryEncoding = binaryEncoding;
    }

    public void setBinaryEncodingType(String encoding) {
        try {
            this.binaryEncoding = BinaryEncoding.valueOf(encoding);
        }
        catch (Exception ex) {
            log.warn("EncodingUnsupported", encoding);
        }
    }

    @Override
    public Object[] getOldObjectValues() {
        String[] oldData = this.getOldData();
        if (oldData != null) {
            return this.tableTemplate.getObjectValues(this, oldData);
        }
        return null;
    }

    @Override
    public Object[] getObjectValues(String[] values) {
        return this.tableTemplate.getObjectValues(this, values);
    }

    @Override
    public Object[] getObjectKeyValues(String[] values) {
        return this.tableTemplate.getObjectKeyValues(this, values);
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }
}

