/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.jumpmind.symmetric.ddl.model.Column;

public class StatementBuilder {
    protected DmlType dmlType;
    protected String sql;
    protected int[] types;
    protected String quote;
    protected Column[] keys;
    protected Column[] columns;
    protected Column[] preFilteredColumns;

    public StatementBuilder(DmlType type, String tableName, Column[] keys, Column[] columns, Column[] preFilteredColumns, boolean isDateOverrideToTimestamp, String identifierQuoteString) {
        this.keys = keys;
        this.columns = columns;
        this.preFilteredColumns = preFilteredColumns;
        String string = this.quote = identifierQuoteString == null ? "" : identifierQuoteString;
        if (type == DmlType.INSERT) {
            this.sql = this.buildInsertSql(tableName, keys, columns);
        } else if (type == DmlType.UPDATE) {
            this.sql = this.buildUpdateSql(tableName, keys, columns);
        } else if (type == DmlType.DELETE) {
            this.sql = this.buildDeleteSql(tableName, keys);
        } else if (type == DmlType.COUNT) {
            this.sql = this.buildCountSql(tableName, keys);
        } else {
            throw new NotImplementedException("Unimplemented SQL type: " + (Object)((Object)type));
        }
        this.dmlType = type;
        this.types = this.buildTypes(keys, columns, isDateOverrideToTimestamp);
    }

    protected Column[] removeKeysFromColumns(Column[] keys, Column[] columns) {
        Column[] columnsWithoutKeys = new Column[columns.length - keys.length];
        HashSet keySet = new HashSet();
        CollectionUtils.addAll(keySet, (Object[])keys);
        int n = 0;
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (keySet.contains(column)) continue;
            columnsWithoutKeys[n++] = column;
        }
        return columnsWithoutKeys;
    }

    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        switch (this.dmlType) {
            case UPDATE: {
                int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
                int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
                return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
            }
            case INSERT: {
                return this.buildTypes(columns, isDateOverrideToTimestamp);
            }
            case DELETE: {
                return this.buildTypes(keys, isDateOverrideToTimestamp);
            }
            case COUNT: {
                return this.buildTypes(keys, isDateOverrideToTimestamp);
            }
        }
        return null;
    }

    protected int[] buildTypes(Column[] columns, boolean isDateOverrideToTimestamp) {
        ArrayList<Integer> list = new ArrayList<Integer>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            list.add(columns[i].getTypeCode());
        }
        int[] types = new int[list.size()];
        int index = 0;
        for (Integer type : list) {
            if (type == 91 && isDateOverrideToTimestamp) {
                type = 93;
            } else if (type == 6 || type == 8) {
                type = 3;
            }
            types[index++] = type;
        }
        return types;
    }

    public String buildInsertSql(String tableName, String[] columnNames) {
        StringBuilder sql = new StringBuilder("insert into " + tableName + "(");
        this.appendColumns(sql, columnNames);
        sql.append(") values (");
        this.appendColumnQuestions(sql, columnNames.length);
        sql.append(")");
        return sql.toString();
    }

    public String buildInsertSql(String tableName, Column[] keys, Column[] columns) {
        StringBuilder sql = new StringBuilder("insert into " + tableName + "(");
        int columnCount = this.appendColumns(sql, columns);
        sql.append(") values (");
        this.appendColumnQuestions(sql, columnCount);
        sql.append(")");
        return sql.toString();
    }

    public String buildUpdateSql(String tableName, String[] keyNames, String[] columnNames) {
        StringBuilder sql = new StringBuilder("update ").append(tableName).append(" set ");
        this.appendColumnEquals(sql, columnNames, ", ");
        sql.append(" where ");
        this.appendColumnEquals(sql, keyNames, " and ");
        return sql.toString();
    }

    public String buildUpdateSql(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("update ").append(tableName).append(" set ");
        this.appendColumnEquals(sql, columns, ", ");
        sql.append(" where ");
        this.appendColumnEquals(sql, keyColumns, " and ");
        return sql.toString();
    }

    public String buildDeleteSql(String tableName, String[] keyNames) {
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyNames, " and ");
        return sql.toString();
    }

    public String buildDeleteSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyColumns, " and ");
        return sql.toString();
    }

    public String buildCountSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("select count(*) from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyColumns, " and ");
        return sql.toString();
    }

    public void appendColumnEquals(StringBuilder sql, String[] names, String separator) {
        for (int i = 0; i < names.length; ++i) {
            sql.append(this.quote).append(names[i]).append(this.quote).append(" = ?").append(i + 1 < names.length ? separator : "");
        }
    }

    public void appendColumnEquals(StringBuilder sql, Column[] columns, String separator) {
        int existingCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            if (existingCount++ > 0) {
                sql.append(separator);
            }
            sql.append(this.quote).append(columns[i].getName()).append(this.quote).append(" = ?");
        }
    }

    public void appendColumns(StringBuilder sql, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            sql.append(this.quote).append(names[i]).append(this.quote).append(i + 1 < names.length ? "," : "");
        }
    }

    public int appendColumns(StringBuilder sql, Column[] columns) {
        int existingCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            if (existingCount++ > 0) {
                sql.append(",");
            }
            sql.append(this.quote).append(columns[i].getName()).append(this.quote);
        }
        return existingCount;
    }

    public void appendColumnQuestions(StringBuilder sql, int number) {
        for (int i = 0; i < number; ++i) {
            sql.append("?").append(i + 1 < number ? "," : "");
        }
    }

    public String getSql() {
        return this.sql;
    }

    public DmlType getDmlType() {
        return this.dmlType;
    }

    public int[] getTypes() {
        return this.types;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Column[] getColumnKeyMetaData(boolean prefiltered) {
        if (prefiltered) {
            return (Column[])ArrayUtils.addAll((Object[])this.preFilteredColumns, (Object[])this.keys);
        }
        return (Column[])ArrayUtils.addAll((Object[])this.columns, (Object[])this.keys);
    }

    public Column[] getMetaData(boolean prefiltered) {
        switch (this.dmlType) {
            case UPDATE: {
                return this.getColumnKeyMetaData(prefiltered);
            }
            case INSERT: {
                return this.getColumns();
            }
            case DELETE: {
                return this.getKeys();
            }
        }
        return null;
    }

    public Column[] getKeys() {
        return this.keys;
    }

    public Column[] getPreFilteredColumns() {
        return this.preFilteredColumns;
    }

    public String[] getValueArray(String[] columnValues, String[] keyValues) {
        switch (this.dmlType) {
            case UPDATE: {
                return (String[])ArrayUtils.addAll((Object[])columnValues, (Object[])keyValues);
            }
            case INSERT: {
                return columnValues;
            }
            case DELETE: {
                return keyValues;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DmlType {
        INSERT,
        UPDATE,
        DELETE,
        COUNT;

    }
}

