/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Date;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderStatistics;

public class IncomingBatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long batchId;
    private String nodeId;
    private String channelId;
    private Status status;
    private boolean errorFlag;
    private long byteCount;
    private long networkMillis;
    private long filterMillis;
    private long databaseMillis;
    private long statementCount;
    private long fallbackInsertCount;
    private long fallbackUpdateCount;
    private long missingDeleteCount;
    private long skipCount;
    private long failedRowNumber;
    private String sqlState;
    private int sqlCode;
    private String sqlMessage;
    private String lastUpdatedHostName;
    private Date lastUpdatedTime;
    private Date createTime;
    private boolean retry;

    public IncomingBatch() {
    }

    public IncomingBatch(long batchId, IDataLoaderContext context) {
        this.batchId = batchId;
        this.nodeId = context.getSourceNodeId();
        this.channelId = context.getChannelId();
        this.status = Status.LD;
    }

    public void setValues(IDataLoaderStatistics statistics, boolean isSuccess) {
        this.byteCount = statistics.getByteCount();
        this.filterMillis = statistics.getFilterMillis();
        this.databaseMillis = statistics.getDatabaseMillis();
        this.statementCount = statistics.getStatementCount();
        this.fallbackInsertCount = statistics.getFallbackInsertCount();
        this.fallbackUpdateCount = statistics.getFallbackUpdateCount();
        this.missingDeleteCount = statistics.getMissingDeleteCount();
        this.lastUpdatedTime = new Date();
        if (!isSuccess) {
            this.failedRowNumber = statistics.getStatementCount();
        }
    }

    public String getNodeBatchId() {
        return this.nodeId + "-" + this.batchId;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean isRetry) {
        this.retry = isRetry;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public long getNetworkMillis() {
        return this.networkMillis;
    }

    public void setNetworkMillis(long networkMillis) {
        this.networkMillis = networkMillis;
    }

    public long getFilterMillis() {
        return this.filterMillis;
    }

    public void setFilterMillis(long filterMillis) {
        this.filterMillis = filterMillis;
    }

    public long getDatabaseMillis() {
        return this.databaseMillis;
    }

    public void setDatabaseMillis(long databaseMillis) {
        this.databaseMillis = databaseMillis;
    }

    public long getStatementCount() {
        return this.statementCount;
    }

    public void setStatementCount(long statementCount) {
        this.statementCount = statementCount;
    }

    public long getFallbackInsertCount() {
        return this.fallbackInsertCount;
    }

    public void setFallbackInsertCount(long fallbackInsertCount) {
        this.fallbackInsertCount = fallbackInsertCount;
    }

    public long getFallbackUpdateCount() {
        return this.fallbackUpdateCount;
    }

    public void setFallbackUpdateCount(long fallbackUpdateCount) {
        this.fallbackUpdateCount = fallbackUpdateCount;
    }

    public long getMissingDeleteCount() {
        return this.missingDeleteCount;
    }

    public void setMissingDeleteCount(long missingDeleteCount) {
        this.missingDeleteCount = missingDeleteCount;
    }

    public void setSkipCount(long skipCount) {
        this.skipCount = skipCount;
    }

    public long getSkipCount() {
        return this.skipCount;
    }

    public long getFailedRowNumber() {
        return this.failedRowNumber;
    }

    public void setFailedRowNumber(long failedRowNumber) {
        this.failedRowNumber = failedRowNumber;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public void setSqlState(String sqlState) {
        this.sqlState = sqlState;
    }

    public int getSqlCode() {
        return this.sqlCode;
    }

    public void setSqlCode(int sqlCode) {
        this.sqlCode = sqlCode;
    }

    public String getSqlMessage() {
        return this.sqlMessage;
    }

    public void setSqlMessage(String sqlMessage) {
        this.sqlMessage = sqlMessage;
    }

    public String getLastUpdatedHostName() {
        return this.lastUpdatedHostName;
    }

    public void setLastUpdatedHostName(String lastUpdateHostName) {
        this.lastUpdatedHostName = lastUpdateHostName;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdateTime) {
        this.lastUpdatedTime = lastUpdateTime;
    }

    public boolean isPersistable() {
        return this.batchId >= 0L;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public String toString() {
        return Long.toString(this.batchId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        LD("Loading"),
        OK("Ok"),
        ER("Error");

        private String description;

        private Status(String desc) {
            this.description = desc;
        }

        public String toString() {
            return this.description;
        }
    }
}

