/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.List;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.OutgoingBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteNodeStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nodeId;
    private Status status = Status.NO_DATA;
    private long dataProcessed;
    private long batchesProcessed;

    public RemoteNodeStatus(String nodeId) {
        this.nodeId = nodeId;
    }

    public boolean failed() {
        return this.status != Status.NO_DATA && this.status != Status.DATA_PROCESSED;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getDataProcessed() {
        return this.dataProcessed;
    }

    public long getBatchesProcessed() {
        return this.batchesProcessed;
    }

    public void updateIncomingStatus(List<IncomingBatch> incomingBatches) {
        if (incomingBatches != null) {
            for (IncomingBatch incomingBatch : incomingBatches) {
                this.dataProcessed += incomingBatch.getStatementCount();
                ++this.batchesProcessed;
                if (incomingBatch.getStatus() != IncomingBatch.Status.ER) continue;
                this.status = Status.DATA_ERROR;
            }
        }
        if (this.status != Status.DATA_ERROR && this.dataProcessed > 0L) {
            this.status = Status.DATA_PROCESSED;
        }
    }

    public void updateOutgoingStatus(List<OutgoingBatch> outgoingBatches, List<BatchInfo> batches) {
        if (batches != null) {
            for (BatchInfo batchInfo : batches) {
                if (batchInfo.isOk()) continue;
                this.status = Status.DATA_ERROR;
            }
        }
        if (outgoingBatches != null) {
            for (OutgoingBatch outgoingBatch : outgoingBatches) {
                ++this.batchesProcessed;
                this.dataProcessed += outgoingBatch.totalEventCount();
            }
        }
        if (this.status != Status.DATA_ERROR && this.dataProcessed > 0L) {
            this.status = Status.DATA_PROCESSED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OFFLINE,
        BUSY,
        NOT_AUTHORIZED,
        REGISTRATION_REQUIRED,
        SYNC_DISABLED,
        NO_DATA,
        DATA_PROCESSED,
        DATA_ERROR,
        UNKNOWN_ERROR;

    }
}

