/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trigger
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Log logger = LogFactory.getLog(Trigger.class);
    private static int maxTriggerId;
    private static final String DEFAULT_CONDITION = "1=1";
    private String triggerId;
    private String sourceTableName;
    private String sourceSchemaName;
    private String sourceCatalogName;
    private String channelId;
    private boolean syncOnUpdate = true;
    private boolean syncOnInsert = true;
    private boolean syncOnDelete = true;
    private boolean syncOnIncomingBatch = false;
    private boolean useStreamLobs = false;
    private boolean useCaptureLobs = false;
    private String nameForInsertTrigger;
    private String nameForUpdateTrigger;
    private String nameForDeleteTrigger;
    private String syncOnUpdateCondition = "1=1";
    private String syncOnInsertCondition = "1=1";
    private String syncOnDeleteCondition = "1=1";
    private String excludedColumnNames = null;
    private String txIdExpression = null;
    private String externalSelect = null;
    private Date createTime;
    private Date lastUpdateTime;
    private String lastUpdateBy;

    public Trigger() {
        this.triggerId = Integer.toString(maxTriggerId++);
    }

    public Trigger(String tableName) {
        this.sourceTableName = tableName;
    }

    public final String qualifiedSourceTableName() {
        return this.qualifiedSourceTablePrefix() + this.sourceTableName;
    }

    public final String qualifiedSourceTablePrefix() {
        String schemaPlus = this.getSourceSchemaName() != null ? this.getSourceSchemaName() + "." : "";
        String catalogPlus = (this.getSourceCatalogName() != null ? this.getSourceCatalogName() + "." : "") + schemaPlus;
        return catalogPlus;
    }

    public void nullOutBlankFields() {
        if (StringUtils.isBlank((String)this.sourceCatalogName)) {
            this.sourceCatalogName = null;
        }
        if (StringUtils.isBlank((String)this.sourceSchemaName)) {
            this.sourceSchemaName = null;
        }
    }

    public Column[] orderColumnsForTable(Table table) {
        if (table != null) {
            int i;
            List<String> excludedColumnNames = this.getExcludedColumnNamesAsList();
            Column[] pks = table.getPrimaryKeyColumns();
            Column[] cols = table.getColumns();
            ArrayList<Column> orderedColumns = new ArrayList<Column>(cols.length);
            for (i = 0; i < pks.length; ++i) {
                orderedColumns.add(pks[i]);
            }
            for (i = 0; i < cols.length; ++i) {
                Column col = cols[i];
                if (col.isPrimaryKey() || excludedColumnNames.contains(col.getName().toLowerCase())) continue;
                orderedColumns.add(col);
            }
            return orderedColumns.toArray(new Column[orderedColumns.size()]);
        }
        return new Column[0];
    }

    public int[] getExcludedColumnIndexes(Table table) {
        if (this.excludedColumnNames != null && this.excludedColumnNames.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(this.excludedColumnNames, ",");
            int[] indexes = new int[tokenizer.countTokens()];
            Column[] columns = table.getColumns();
            ArrayList<String> columnNames = new ArrayList<String>(columns.length);
            for (Column column : columns) {
                columnNames.add(column.getName().toLowerCase());
            }
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                indexes[i++] = columnNames.indexOf(tokenizer.nextToken().toLowerCase());
            }
            return indexes;
        }
        return new int[0];
    }

    private List<String> getExcludedColumnNamesAsList() {
        if (this.excludedColumnNames != null && this.excludedColumnNames.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(this.excludedColumnNames, ",");
            ArrayList<String> columnNames = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                columnNames.add(tokenizer.nextToken().toLowerCase().trim());
            }
            return columnNames;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasChangedSinceLastTriggerBuild(Date lastTriggerBuildTime) {
        return lastTriggerBuildTime == null || this.getLastUpdateTime() == null || lastTriggerBuildTime.before(this.getLastUpdateTime());
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        int id;
        this.triggerId = triggerId;
        if (StringUtils.isNotBlank((String)triggerId) && StringUtils.isNumeric((String)triggerId) && (id = Integer.parseInt(triggerId)) >= maxTriggerId) {
            maxTriggerId = id + 1;
        }
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public boolean isSyncOnUpdate() {
        return this.syncOnUpdate;
    }

    public void setSyncOnUpdate(boolean syncOnUpdate) {
        this.syncOnUpdate = syncOnUpdate;
    }

    public boolean isSyncOnInsert() {
        return this.syncOnInsert;
    }

    public void setSyncOnInsert(boolean syncOnInsert) {
        this.syncOnInsert = syncOnInsert;
    }

    public boolean isSyncOnDelete() {
        return this.syncOnDelete;
    }

    public void setSyncOnDelete(boolean syncOnDelete) {
        this.syncOnDelete = syncOnDelete;
    }

    public boolean isSyncOnIncomingBatch() {
        return this.syncOnIncomingBatch;
    }

    public void setSyncOnIncomingBatch(boolean syncOnIncomingBatch) {
        this.syncOnIncomingBatch = syncOnIncomingBatch;
    }

    public String getNameForInsertTrigger() {
        return this.nameForInsertTrigger;
    }

    public void setNameForInsertTrigger(String nameForInsertTrigger) {
        this.nameForInsertTrigger = nameForInsertTrigger;
    }

    public String getNameForUpdateTrigger() {
        return this.nameForUpdateTrigger;
    }

    public void setNameForUpdateTrigger(String nameForUpdateTrigger) {
        this.nameForUpdateTrigger = nameForUpdateTrigger;
    }

    public String getNameForDeleteTrigger() {
        return this.nameForDeleteTrigger;
    }

    public void setNameForDeleteTrigger(String nameForDeleteTrigger) {
        this.nameForDeleteTrigger = nameForDeleteTrigger;
    }

    public String getSyncOnUpdateCondition() {
        return this.syncOnUpdateCondition;
    }

    public void setSyncOnUpdateCondition(String syncOnUpdateCondition) {
        this.syncOnUpdateCondition = syncOnUpdateCondition;
    }

    public String getSyncOnInsertCondition() {
        return this.syncOnInsertCondition;
    }

    public void setSyncOnInsertCondition(String syncOnInsertCondition) {
        this.syncOnInsertCondition = syncOnInsertCondition;
    }

    public String getSyncOnDeleteCondition() {
        return this.syncOnDeleteCondition;
    }

    public void setSyncOnDeleteCondition(String syncOnDeleteCondition) {
        this.syncOnDeleteCondition = syncOnDeleteCondition;
    }

    public String getExcludedColumnNames() {
        return this.excludedColumnNames;
    }

    public void setExcludedColumnNames(String excludedColumnNames) {
        this.excludedColumnNames = excludedColumnNames;
    }

    public String getTxIdExpression() {
        return this.txIdExpression;
    }

    public void setTxIdExpression(String txIdExpression) {
        this.txIdExpression = txIdExpression;
    }

    public String getExternalSelect() {
        return this.externalSelect;
    }

    public void setExternalSelect(String externalSelect) {
        this.externalSelect = externalSelect;
    }

    public void setLastUpdateBy(String updatedBy) {
        this.lastUpdateBy = updatedBy;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastModifiedOn) {
        this.lastUpdateTime = lastModifiedOn;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createdOn) {
        this.createTime = createdOn;
    }

    public void setUseStreamLobs(boolean useStreamLobs) {
        this.useStreamLobs = useStreamLobs;
    }

    public boolean isUseStreamLobs() {
        return this.useStreamLobs;
    }

    public void setUseCaptureLobs(boolean useCaptureLobs) {
        this.useCaptureLobs = useCaptureLobs;
    }

    public boolean isUseCaptureLobs() {
        return this.useCaptureLobs;
    }

    public long toHashedValue() {
        long hashedValue;
        long l = hashedValue = this.triggerId != null ? (long)this.triggerId.hashCode() : 0L;
        if (null != this.sourceTableName) {
            hashedValue += (long)this.sourceTableName.hashCode();
        }
        if (null != this.channelId) {
            hashedValue += (long)this.channelId.hashCode();
        }
        if (null != this.sourceSchemaName) {
            hashedValue += (long)this.sourceSchemaName.hashCode();
        }
        if (null != this.sourceCatalogName) {
            hashedValue += (long)this.sourceCatalogName.hashCode();
        }
        hashedValue += this.syncOnUpdate ? (long)"syncOnUpdate".hashCode() : 0L;
        hashedValue += this.syncOnInsert ? (long)"syncOnInsert".hashCode() : 0L;
        hashedValue += this.syncOnDelete ? (long)"syncOnDelete".hashCode() : 0L;
        hashedValue += this.syncOnIncomingBatch ? (long)"syncOnIncomingBatch".hashCode() : 0L;
        hashedValue += this.useStreamLobs ? (long)"useStreamLobs".hashCode() : 0L;
        hashedValue += this.useCaptureLobs ? (long)"useCaptureLobs".hashCode() : 0L;
        if (null != this.nameForInsertTrigger) {
            hashedValue += (long)this.nameForInsertTrigger.hashCode();
        }
        if (null != this.nameForUpdateTrigger) {
            hashedValue += (long)this.nameForUpdateTrigger.hashCode();
        }
        if (null != this.nameForDeleteTrigger) {
            hashedValue += (long)this.nameForDeleteTrigger.hashCode();
        }
        if (null != this.syncOnUpdateCondition) {
            hashedValue += (long)this.syncOnUpdateCondition.hashCode();
        }
        if (null != this.syncOnInsertCondition) {
            hashedValue += (long)this.syncOnInsertCondition.hashCode();
        }
        if (null != this.syncOnDeleteCondition) {
            hashedValue += (long)this.syncOnDeleteCondition.hashCode();
        }
        if (null != this.excludedColumnNames) {
            hashedValue += (long)this.excludedColumnNames.hashCode();
        }
        if (null != this.txIdExpression) {
            hashedValue += (long)this.txIdExpression.hashCode();
        }
        return hashedValue;
    }

    public boolean isSame(Trigger trigger) {
        return this.isSame(this.sourceCatalogName, trigger.sourceCatalogName) && this.isSame(this.sourceSchemaName, trigger.sourceSchemaName) && trigger.sourceTableName.equalsIgnoreCase(this.sourceTableName);
    }

    protected boolean isSame(String one, String two) {
        return one == null && two == null || one != null && two != null && one.equals(two);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Trigger && this.triggerId != null) {
            return this.triggerId.equals(((Trigger)obj).triggerId);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.triggerId != null ? this.triggerId.hashCode() : super.hashCode();
    }

    public String toString() {
        if (this.triggerId != null) {
            return this.triggerId;
        }
        return super.toString();
    }
}

