/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.IDataToRouteReader;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.ISqlProvider;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataToRouteReader
implements IDataToRouteReader {
    protected ILog log;
    protected BlockingQueue<Data> dataQueue;
    protected ISqlProvider sqlProvider;
    protected JdbcTemplate jdbcTemplate;
    protected ChannelRouterContext context;
    protected IDataService dataService;
    protected boolean reading = true;
    protected IDbDialect dbDialect;

    public AbstractDataToRouteReader(ILog log, ISqlProvider sqlProvider, ChannelRouterContext context, IDataService dataService) {
        this.log = log;
        this.jdbcTemplate = dataService != null ? dataService.getJdbcTemplate() : null;
        this.dbDialect = dataService != null ? dataService.getDbDialect() : null;
        this.dataQueue = new LinkedBlockingQueue<Data>(this.dbDialect != null ? this.dbDialect.getRouterDataPeekAheadCount() : 1000);
        this.sqlProvider = sqlProvider;
        this.context = context;
        this.dataService = dataService;
    }

    @Override
    public Data take() {
        Data data = null;
        try {
            int queryTimeout = this.jdbcTemplate.getQueryTimeout();
            data = this.dataQueue.poll(queryTimeout < 3600 ? 3600L : (long)queryTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn(e);
        }
        if (data == null) {
            this.log.warn("RouterDataReaderNotResponding");
        } else if (data instanceof EOD) {
            data = null;
        }
        return data;
    }

    protected PreparedStatement prepareStatment(Connection c) throws SQLException {
        throw new NotImplementedException();
    }

    protected String getSql(String sqlName, Channel channel) {
        String select = this.sqlProvider.getSql(sqlName);
        if (!channel.isUseOldDataToRoute()) {
            select = select.replace("d.old_data", "''");
        }
        if (!channel.isUseRowDataToRoute()) {
            select = select.replace("d.row_data", "''");
        }
        if (!channel.isUsePkDataToRoute()) {
            select = select.replace("d.pk_data", "''");
        }
        return this.dbDialect == null ? select : this.dbDialect.massageDataExtractionSql(select, channel);
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Throwable ex) {
            this.log.error(ex);
        }
    }

    protected void execute() {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInConnection(Connection c) throws SQLException, DataAccessException {
                Integer n;
                int dataCount = 0;
                PreparedStatement ps = null;
                ResultSet rs = null;
                boolean autoCommit = c.getAutoCommit();
                try {
                    if (AbstractDataToRouteReader.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                        c.setAutoCommit(false);
                    }
                    String channelId = AbstractDataToRouteReader.this.context.getChannel().getChannelId();
                    ps = AbstractDataToRouteReader.this.prepareStatment(c);
                    long ts = System.currentTimeMillis();
                    rs = ps.executeQuery();
                    long executeTimeInMs = System.currentTimeMillis() - ts;
                    AbstractDataToRouteReader.this.context.incrementStat(executeTimeInMs, "data.read.query.time.ms");
                    if (executeTimeInMs > 30000L) {
                        AbstractDataToRouteReader.this.log.warn("RoutedDataSelectedInTime", executeTimeInMs, channelId);
                    } else if (AbstractDataToRouteReader.this.log.isDebugEnabled()) {
                        AbstractDataToRouteReader.this.log.debug("RoutedDataSelectedInTime", executeTimeInMs, channelId);
                    }
                    int maxQueueSize = AbstractDataToRouteReader.this.dbDialect.getRouterDataPeekAheadCount();
                    int toRead = maxQueueSize - AbstractDataToRouteReader.this.dataQueue.size();
                    ArrayList<Data> memQueue = new ArrayList<Data>(toRead);
                    ts = System.currentTimeMillis();
                    while (rs.next() && AbstractDataToRouteReader.this.reading) {
                        if (StringUtils.isBlank((String)rs.getString(13))) {
                            Data data = AbstractDataToRouteReader.this.dataService.readData(rs);
                            AbstractDataToRouteReader.this.context.setLastDataIdForTransactionId(data);
                            memQueue.add(data);
                            ++dataCount;
                            AbstractDataToRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.read.total.time.ms");
                        } else {
                            AbstractDataToRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.reread.time.ms");
                        }
                        ts = System.currentTimeMillis();
                        if (toRead == 0) {
                            AbstractDataToRouteReader.this.copyToQueue(memQueue);
                            toRead = maxQueueSize - AbstractDataToRouteReader.this.dataQueue.size();
                            memQueue = new ArrayList(toRead);
                        } else {
                            --toRead;
                        }
                        AbstractDataToRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.enqueue.time.ms");
                        ts = System.currentTimeMillis();
                    }
                    ts = System.currentTimeMillis();
                    AbstractDataToRouteReader.this.copyToQueue(memQueue);
                    AbstractDataToRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.enqueue.time.ms");
                    n = dataCount;
                    Object var16_13 = null;
                }
                catch (Throwable throwable) {
                    Object var16_14 = null;
                    JdbcUtils.closeResultSet(rs);
                    JdbcUtils.closeStatement(ps);
                    rs = null;
                    ps = null;
                    if (AbstractDataToRouteReader.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                        c.commit();
                        c.setAutoCommit(autoCommit);
                    }
                    boolean done = false;
                    do {
                        if (done = AbstractDataToRouteReader.this.dataQueue.offer(new EOD())) continue;
                        AppUtils.sleep(50L);
                    } while (!done && AbstractDataToRouteReader.this.reading);
                    AbstractDataToRouteReader.this.reading = false;
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                JdbcUtils.closeStatement((Statement)ps);
                rs = null;
                ps = null;
                if (AbstractDataToRouteReader.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                    c.commit();
                    c.setAutoCommit(autoCommit);
                }
                boolean done = false;
                do {
                    if (done = AbstractDataToRouteReader.this.dataQueue.offer(new EOD())) continue;
                    AppUtils.sleep(50L);
                } while (!done && AbstractDataToRouteReader.this.reading);
                AbstractDataToRouteReader.this.reading = false;
                return n;
            }
        });
    }

    protected void copyToQueue(List<Data> memQueue) {
        while (memQueue.size() > 0 && this.reading) {
            Data d = memQueue.get(0);
            if (this.dataQueue.offer(d)) {
                memQueue.remove(0);
                continue;
            }
            AppUtils.sleep(50L);
        }
    }

    @Override
    public boolean isReading() {
        return this.reading;
    }

    @Override
    public void setReading(boolean reading) {
        this.reading = reading;
    }

    public BlockingQueue<Data> getDataQueue() {
        return this.dataQueue;
    }

    class EOD
    extends Data {
        private static final long serialVersionUID = 1L;

        EOD() {
        }
    }
}

