/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.model.DataRef;
import org.jumpmind.symmetric.route.AbstractDataToRouteReader;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.ISqlProvider;

public class DataRefRouteReader
extends AbstractDataToRouteReader {
    public static final String SELECT_DATA_TO_BATCH_SQL = "selectDataToBatchSql";

    public DataRefRouteReader(ILog log, ISqlProvider sqlProvider, ChannelRouterContext context, IDataService dataService) {
        super(log, sqlProvider, context, dataService);
    }

    protected PreparedStatement prepareStatment(Connection c) throws SQLException {
        DataRef dataRef = this.dataService.getDataRef();
        String channelId = this.context.getChannel().getChannelId();
        PreparedStatement ps = c.prepareStatement(this.getSql(SELECT_DATA_TO_BATCH_SQL, this.context.getChannel().getChannel()), 1003, 1007);
        ps.setQueryTimeout(this.jdbcTemplate.getQueryTimeout());
        ps.setFetchSize(this.jdbcTemplate.getFetchSize());
        ps.setString(1, channelId);
        ps.setLong(2, dataRef.getRefDataId());
        return ps;
    }
}

