/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubSelectDataRouter
extends AbstractDataRouter {
    private String sql;
    private JdbcTemplate jdbcTemplate;
    private IDbDialect dbDialect;

    @Override
    public Set<String> routeToNodes(IRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad) {
        TriggerRouter trigger = dataMetaData.getTriggerRouter();
        String subSelect = trigger.getRouter().getRouterExpression();
        Set<String> nodeIds = null;
        if (!StringUtils.isBlank((String)subSelect)) {
            SimpleJdbcTemplate simpleTemplate = new SimpleJdbcTemplate((JdbcOperations)this.jdbcTemplate);
            Map<String, Object> sqlParams = this.getDataObjectMap(dataMetaData, this.dbDialect);
            sqlParams.put("NODE_GROUP_ID", trigger.getRouter().getNodeGroupLink().getTargetNodeGroupId());
            List ids = simpleTemplate.query(String.format("%s%s", this.sql, subSelect), (RowMapper)new SingleColumnRowMapper(), sqlParams);
            if (ids != null) {
                nodeIds = new HashSet<String>(ids);
            }
        } else {
            nodeIds = this.toNodeIds(nodes, null);
        }
        return nodeIds;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }
}

