/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Set;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.route.ConfigurationChangedDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerDataRouter
extends ConfigurationChangedDataRouter {
    @Override
    public Set<String> routeToNodes(IRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad) {
        Set<String> nodeIds = super.routeToNodes(context, dataMetaData, nodes, initialLoad);
        if (!initialLoad) {
            for (Node node : nodes) {
                int max;
                String version = node.getSymmetricVersion();
                if (version == null || (max = Version.parseVersion(version)[0]) >= 2) continue;
                nodeIds.remove(node.getNodeId());
            }
            return nodeIds;
        }
        return nodeIds;
    }

    @Override
    public boolean isAutoRegister() {
        return false;
    }
}

