/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transport.IAcknowledgeEventListener;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.transaction.annotation.Transactional;

public class AcknowledgeService
extends AbstractService
implements IAcknowledgeService {
    private IOutgoingBatchService outgoingBatchService;
    private List<IAcknowledgeEventListener> batchEventListeners;
    private IRegistrationService registrationService;

    @Transactional
    public void ack(BatchInfo batch) {
        if (this.batchEventListeners != null) {
            for (IAcknowledgeEventListener batchEventListener : this.batchEventListeners) {
                batchEventListener.onAcknowledgeEvent(batch);
            }
        }
        if (batch.getBatchId() == -9999L) {
            if (batch.isOk()) {
                this.registrationService.markNodeAsRegistered(batch.getNodeId());
            }
        } else {
            OutgoingBatch.Status status;
            OutgoingBatch outgoingBatch = this.outgoingBatchService.findOutgoingBatch(batch.getBatchId());
            OutgoingBatch.Status status2 = status = batch.isOk() ? OutgoingBatch.Status.OK : OutgoingBatch.Status.ER;
            if (outgoingBatch != null) {
                if (outgoingBatch.getStatus() != OutgoingBatch.Status.OK) {
                    outgoingBatch.setStatus(status);
                    outgoingBatch.setErrorFlag(!batch.isOk());
                } else {
                    outgoingBatch.setErrorFlag(false);
                    this.log.warn("AckNotUpdatingBatchState", batch.getBatchId(), status.name());
                }
                outgoingBatch.setNetworkMillis(batch.getNetworkMillis());
                outgoingBatch.setFilterMillis(batch.getFilterMillis());
                outgoingBatch.setLoadMillis(batch.getDatabaseMillis());
                if (!batch.isOk() && batch.getErrorLine() != 0L) {
                    CallBackHandler handler = new CallBackHandler(batch.getErrorLine());
                    this.jdbcTemplate.query(this.getSql("selectDataIdSql"), new Object[]{outgoingBatch.getBatchId()}, (RowCallbackHandler)handler);
                    outgoingBatch.setFailedDataId(handler.getDataId());
                    outgoingBatch.setSqlCode(batch.getSqlCode());
                    outgoingBatch.setSqlState(batch.getSqlState());
                    outgoingBatch.setSqlMessage(batch.getSqlMessage());
                }
                if (status == OutgoingBatch.Status.ER) {
                    this.log.error("AckReceivedError", outgoingBatch.getNodeId(), outgoingBatch.getBatchId());
                }
                this.outgoingBatchService.updateOutgoingBatch(outgoingBatch);
            } else {
                this.log.error("BatchNotFoundForAck", batch.getBatchId(), status.name());
            }
        }
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void addAcknowledgeEventListener(IAcknowledgeEventListener statusChangeListner) {
        if (this.batchEventListeners == null) {
            this.batchEventListeners = new ArrayList<IAcknowledgeEventListener>();
        }
        this.batchEventListeners.add(statusChangeListner);
    }

    class CallBackHandler
    implements RowCallbackHandler {
        int index = 0;
        long dataId = -1L;
        long rowNumber;

        CallBackHandler(long rowNumber) {
            this.rowNumber = rowNumber;
        }

        public void processRow(ResultSet rs) throws SQLException {
            if ((long)(++this.index) == this.rowNumber) {
                this.dataId = rs.getLong(1);
            }
        }

        public long getDataId() {
            return this.dataId;
        }
    }
}

