/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterService
extends AbstractService
implements IClusterService {
    protected String serverId = AppUtils.getServerId();

    @Override
    public void initLockTable() {
        this.initLockTable("ROUTE");
        this.initLockTable("PULL");
        this.initLockTable("PUSH");
        this.initLockTable("HEARTBEAT");
        this.initLockTable("PURGE_INCOMING");
        this.initLockTable("PURGE_OUTGOING");
        this.initLockTable("PURGE_STATISTICS");
        this.initLockTable("SYNCTRIGGERS");
        this.initLockTable("PURGE_DATA_GAPS");
    }

    @Override
    public void initLockTable(String action) {
        try {
            this.jdbcTemplate.update(this.getSql("insertLockSql"), new Object[]{action});
            this.log.debug("LockInserted", action);
        }
        catch (DataIntegrityViolationException ex) {
            this.log.debug("LockInsertFailed", action);
        }
    }

    @Override
    public void clearAllLocks() {
        this.jdbcTemplate.update(this.getSql("clearAllLocksSql"));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean lock(String action) {
        if (this.isClusteringEnabled()) {
            Date timeout = DateUtils.add((Date)new Date(), (int)14, (int)((int)(-this.parameterService.getLong("cluster.lock.timeout.ms"))));
            return this.lock(action, timeout, new Date(), this.serverId);
        }
        return true;
    }

    protected boolean lock(String action, Date timeToBreakLock, Date timeLockAquired, String serverId) {
        return this.jdbcTemplate.update(this.getSql("aquireLockSql"), new Object[]{serverId, timeLockAquired, action, timeToBreakLock, serverId}) == 1;
    }

    @Override
    public Map<String, Lock> findLocks() {
        final HashMap<String, Lock> locks = new HashMap<String, Lock>();
        if (this.isClusteringEnabled()) {
            this.jdbcTemplate.query(this.getSql("findLocksSql"), (RowMapper)new RowMapper<Lock>(){

                public Lock mapRow(ResultSet rs, int rowNum) throws SQLException {
                    Lock lock = new Lock();
                    lock.setLockAction(rs.getString(1));
                    lock.setLockingServerId(rs.getString(2));
                    lock.setLockTime(rs.getTimestamp(3));
                    lock.setLastLockingServerId(rs.getString(4));
                    lock.setLastLockTime(rs.getTimestamp(5));
                    locks.put(lock.getLockAction(), lock);
                    return lock;
                }
            });
        }
        return locks;
    }

    @Override
    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void unlock(String action) {
        if (this.isClusteringEnabled() && !this.unlock(action, this.serverId)) {
            this.log.warn("ClusterUnlockFailed", action, this.serverId);
        }
    }

    protected boolean unlock(String action, String serverId) {
        return this.jdbcTemplate.update(this.getSql("releaseLockSql"), new Object[]{serverId, action, serverId}) > 0;
    }

    @Override
    public boolean isClusteringEnabled() {
        return this.parameterService.is("cluster.lock.enabled");
    }

    @Override
    public void aquireInfiniteLock(String action) {
        if (this.isClusteringEnabled()) {
            Date futureTime = DateUtils.add((Date)new Date(), (int)1, (int)100);
            this.lock(action, new Date(), futureTime, "STOPPED");
        }
    }

    @Override
    public void clearInfiniteLock(String action) {
        Map<String, Lock> all = this.findLocks();
        Lock lock = all.get(action);
        if (lock != null && "STOPPED".equals(lock.getLockingServerId())) {
            this.unlock(action, "STOPPED");
        }
    }
}

