/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.DeploymentType;
import org.jumpmind.symmetric.common.Message;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.db.JdbcBatchPreparedStatementCallback;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.load.IReloadListener;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEvent;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.DataRef;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IModelRetrievalHandler;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.CsvUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataService
extends AbstractService
implements IDataService {
    private DeploymentType deploymentType;
    private ITriggerRouterService triggerRouterService;
    private INodeService nodeService;
    private IPurgeService purgeService;
    private IConfigurationService configurationService;
    private IOutgoingBatchService outgoingBatchService;
    private List<IReloadListener> reloadListeners;
    private List<IHeartbeatListener> heartbeatListeners;
    private IStatisticManager statisticManager;
    protected Map<IHeartbeatListener, Long> lastHeartbeatTimestamps = new HashMap<IHeartbeatListener, Long>();

    @Override
    @Transactional
    public void insertReloadEvent(Node targetNode, TriggerRouter triggerRouter) {
        this.insertReloadEvent(targetNode, triggerRouter, null);
    }

    @Transactional
    public void insertReloadEvent(Node targetNode, TriggerRouter triggerRouter, String overrideInitialLoadSelect) {
        TriggerHistory history = this.lookupTriggerHistory(triggerRouter.getTrigger());
        Data data = new Data(history.getSourceTableName(), DataEventType.RELOAD, overrideInitialLoadSelect != null ? overrideInitialLoadSelect : triggerRouter.getInitialLoadSelect(), null, history, triggerRouter.getTrigger().getChannelId(), null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), triggerRouter.getRouter().getRouterId(), true);
    }

    private TriggerHistory lookupTriggerHistory(Trigger trigger) {
        TriggerHistory history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
        if (history == null) {
            this.triggerRouterService.syncTriggers();
            history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
        }
        if (history == null) {
            throw new RuntimeException("Cannot find history for trigger " + trigger.getTriggerId() + ", " + trigger.getSourceTableName());
        }
        return history;
    }

    @Override
    public void insertPurgeEvent(Node targetNode, TriggerRouter triggerRouter, boolean isLoad) {
        String sql = this.dbDialect.createPurgeSqlFor(targetNode, triggerRouter);
        TriggerHistory history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(triggerRouter.getTrigger().getTriggerId());
        Data data = new Data(history.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData(sql), null, history, triggerRouter.getTrigger().getChannelId(), null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), triggerRouter.getRouter().getRouterId(), isLoad);
    }

    @Override
    public void insertSqlEvent(Node targetNode, Trigger trigger, String sql, boolean isLoad) {
        TriggerHistory history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
        Data data = new Data(history.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData(sql), null, history, trigger.getChannelId(), null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?", isLoad);
    }

    private TriggerHistory findTriggerHistoryForGenericSync() {
        String triggerTableName = TableConstants.getTableName(this.tablePrefix, "trigger");
        TriggerHistory history = this.triggerRouterService.findTriggerHistory(triggerTableName.toUpperCase());
        if (history == null) {
            history = this.triggerRouterService.findTriggerHistory(triggerTableName);
        }
        return history;
    }

    @Override
    public void insertSqlEvent(Node targetNode, String sql, boolean isLoad) {
        TriggerHistory history = this.findTriggerHistoryForGenericSync();
        Data data = new Data(history.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData(sql), null, history, "config", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?", isLoad);
    }

    @Override
    public int countDataInRange(long firstDataId, long secondDataId) {
        return this.jdbcTemplate.queryForInt(this.getSql("countDataInRangeSql"), new Object[]{firstDataId, secondDataId});
    }

    @Override
    public void checkForAndUpdateMissingChannelIds(long firstDataId, long lastDataId) {
        int numberUpdated = this.jdbcTemplate.update(this.getSql("checkForAndUpdateMissingChannelIdSql"), new Object[]{"default", firstDataId, lastDataId});
        if (numberUpdated > 0) {
            this.log.warn("DataFoundWithWrongChannelIds", numberUpdated, firstDataId, lastDataId, "default");
        }
    }

    @Override
    public void insertCreateEvent(Node targetNode, TriggerRouter triggerRouter, String xml, boolean isLoad) {
        TriggerHistory history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(triggerRouter.getTrigger().getTriggerId());
        Data data = new Data(triggerRouter.getTrigger().getSourceTableName(), DataEventType.CREATE, CsvUtils.escapeCsvData(xml), null, history, this.parameterService.is("initial.load.use.reload.channel") && isLoad ? "reload" : triggerRouter.getTrigger().getChannelId(), null, null);
        try {
            this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?", isLoad);
        }
        catch (DataIntegrityViolationException e) {
            if (e.getRootCause() != null && e.getRootCause() instanceof DataTruncation) {
                this.log.error("InitialLoadCreateDataTruncation");
            }
            throw e;
        }
    }

    @Override
    public long insertData(final Data data) {
        long id = this.dbDialect.insertWithGeneratedKey(this.getSql("insertIntoDataSql"), SequenceIdentifier.DATA, new PreparedStatementCallback<Object>(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.setString(1, data.getTableName());
                ps.setString(2, data.getEventType().getCode());
                ps.setString(3, data.getRowData());
                ps.setString(4, data.getPkData());
                ps.setString(5, data.getOldData());
                ps.setLong(6, data.getTriggerHistory() != null ? (long)data.getTriggerHistory().getTriggerHistoryId() : -1L);
                ps.setString(7, data.getChannelId());
                return null;
            }
        });
        data.setDataId(id);
        return id;
    }

    public void insertDataEvent(DataEvent dataEvent) {
        this.insertDataEvent(this.jdbcTemplate, dataEvent.getDataId(), dataEvent.getBatchId(), dataEvent.getRouterId());
    }

    @Override
    public void insertDataEvent(long dataId, long batchId, String routerId) {
        this.insertDataEvent(this.jdbcTemplate, dataId, batchId, routerId);
    }

    @Override
    public void insertDataEvent(JdbcTemplate template, long dataId, long batchId, String routerId) {
        try {
            template.update(this.getSql("insertIntoDataEventSql"), new Object[]{dataId, batchId, StringUtils.isBlank((String)routerId) ? "?" : routerId}, new int[]{4, 4, 12});
        }
        catch (RuntimeException ex) {
            this.log.error("DataEventInsertFailed", ex, dataId, batchId, routerId);
            throw ex;
        }
    }

    @Override
    public void insertDataEvents(JdbcTemplate template, final List<DataEvent> events) {
        if (events.size() > 0) {
            JdbcBatchPreparedStatementCallback callback = new JdbcBatchPreparedStatementCallback(this.dbDialect, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    DataEvent event = (DataEvent)events.get(i);
                    ps.setLong(1, event.getDataId());
                    ps.setLong(2, event.getBatchId());
                    ps.setString(3, StringUtils.isBlank((String)event.getRouterId()) ? "?" : event.getRouterId());
                }

                public int getBatchSize() {
                    return events.size();
                }
            }, this.parameterService.getInt("db.jdbc.execute.batch.size"));
            template.execute(this.getSql("insertIntoDataEventSql"), (PreparedStatementCallback)callback);
        }
    }

    @Override
    public void insertDataAndDataEventAndOutgoingBatch(Data data, String channelId, List<Node> nodes, String routerId, boolean isLoad) {
        long dataId = this.insertData(data);
        for (Node node : nodes) {
            this.insertDataEventAndOutgoingBatch(dataId, channelId, node.getNodeId(), data.getEventType(), routerId, isLoad);
        }
    }

    @Override
    public void insertDataAndDataEventAndOutgoingBatch(Data data, String nodeId, String routerId, boolean isLoad) {
        long dataId = this.insertData(data);
        this.insertDataEventAndOutgoingBatch(dataId, data.getChannelId(), nodeId, data.getEventType(), routerId, isLoad);
    }

    @Override
    public void insertDataEventAndOutgoingBatch(long dataId, String channelId, String nodeId, DataEventType eventType, String routerId, boolean isLoad) {
        OutgoingBatch outgoingBatch = new OutgoingBatch(nodeId, this.parameterService.is("initial.load.use.reload.channel") && isLoad ? "reload" : channelId, OutgoingBatch.Status.NE);
        outgoingBatch.setLoadFlag(isLoad);
        outgoingBatch.incrementEventCount(eventType);
        this.outgoingBatchService.insertOutgoingBatch(outgoingBatch);
        this.insertDataEvent(new DataEvent(dataId, outgoingBatch.getBatchId(), routerId));
    }

    @Override
    public String reloadNode(String nodeId) {
        Node targetNode = this.nodeService.findNode(nodeId);
        if (targetNode == null) {
            return Message.get("NodeUnknown", nodeId);
        }
        if (this.nodeService.setInitialLoadEnabled(nodeId, true)) {
            return Message.get("NodeInitialLoadOpened", nodeId);
        }
        return Message.get("NodeInitialLoadFailed", nodeId);
    }

    @Override
    public void insertReloadEvents(Node targetNode) {
        this.outgoingBatchService.markAllAsSentForNode(targetNode);
        if (this.parameterService.is("datareload.batch.insert.transactional")) {
            this.newTransactionTemplate.execute((TransactionCallback)new TransactionalInsertReloadEventsDelegate(targetNode));
        } else {
            new TransactionalInsertReloadEventsDelegate(targetNode).doInTransaction(null);
        }
        this.purgeService.purgeAllIncomingEventsForNode(targetNode.getNodeId());
    }

    private void insertNodeSecurityUpdate(Node node, boolean isReload) {
        Data data = this.createData(null, null, this.tablePrefix + "_node_security", " t.node_id = '" + node.getNodeId() + "'");
        if (data != null) {
            this.insertDataAndDataEventAndOutgoingBatch(data, node.getNodeId(), "?", isReload);
        }
    }

    @Override
    @Transactional
    public void sendScript(String nodeId, String script, boolean isLoad) {
        Node targetNode = this.nodeService.findNode(nodeId);
        TriggerHistory history = this.findTriggerHistoryForGenericSync();
        Data data = new Data(history.getSourceTableName(), DataEventType.BSH, CsvUtils.escapeCsvData(script), null, history, "config", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?", isLoad);
    }

    @Override
    @Transactional
    public String sendSQL(String nodeId, String catalogName, String schemaName, String tableName, String sql, boolean isLoad) {
        Node sourceNode = this.nodeService.findIdentity();
        Node targetNode = this.nodeService.findNode(nodeId);
        if (targetNode == null) {
            return "Unknown node " + nodeId;
        }
        Set<TriggerRouter> triggerRouters = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(catalogName, schemaName, tableName, true);
        if (triggerRouters == null || triggerRouters.size() == 0) {
            return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
        }
        this.insertSqlEvent(targetNode, triggerRouters.iterator().next().getTrigger(), sql, isLoad);
        return "Successfully create SQL event for node " + targetNode.getNodeId();
    }

    @Override
    @Transactional
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName) {
        return this.reloadTable(nodeId, catalogName, schemaName, tableName, null);
    }

    @Override
    @Transactional
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName, String overrideInitialLoadSelect) {
        Node sourceNode = this.nodeService.findIdentity();
        Node targetNode = this.nodeService.findNode(nodeId);
        if (targetNode == null) {
            return "Unknown node " + nodeId;
        }
        Set<TriggerRouter> triggerRouters = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(catalogName, schemaName, tableName, true);
        if (triggerRouters == null || triggerRouters.size() == 0) {
            return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
        }
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (this.parameterService.is("initial.load.create.first")) {
                String xml = this.dbDialect.getCreateTableXML(triggerRouter);
                this.insertCreateEvent(targetNode, triggerRouter, xml, true);
            } else if (this.parameterService.is("initial.load.delete.first")) {
                this.insertPurgeEvent(targetNode, triggerRouter, true);
            }
            this.insertReloadEvent(targetNode, triggerRouter, overrideInitialLoadSelect);
        }
        return "Successfully created event to reload table " + tableName + " for node " + targetNode.getNodeId();
    }

    @Override
    public void insertHeartbeatEvent(Node node, boolean isReload) {
        String tableName = TableConstants.getTableName(this.tablePrefix, "node");
        List<NodeGroupLink> links = this.configurationService.getNodeGroupLinksFor(this.parameterService.getNodeGroupId());
        for (NodeGroupLink nodeGroupLink : links) {
            if (nodeGroupLink.getDataEventAction() != NodeGroupLinkAction.P) continue;
            Set<TriggerRouter> triggerRouters = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(nodeGroupLink, null, null, tableName, false);
            if (triggerRouters != null && triggerRouters.size() > 0) {
                Data data = this.createData(triggerRouters.iterator().next().getTrigger(), String.format(" t.node_id = '%s'", node.getNodeId()));
                if (data != null) {
                    this.insertData(data);
                    continue;
                }
                this.log.warn("TableGeneratingEventsFailure", tableName);
                continue;
            }
            this.log.warn("TableGeneratingEventsFailure", tableName);
        }
    }

    @Override
    public Data createData(String catalogName, String schemaName, String tableName) {
        return this.createData(catalogName, schemaName, tableName, null);
    }

    @Override
    public Data createData(String catalogName, String schemaName, String tableName, String whereClause) {
        Data data = null;
        Set<TriggerRouter> triggerRouters = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(catalogName, schemaName, tableName, false);
        if (triggerRouters != null && triggerRouters.size() > 0) {
            data = this.createData(triggerRouters.iterator().next().getTrigger(), whereClause);
        }
        return data;
    }

    public Data createData(Trigger trigger, String whereClause) {
        Data data = null;
        if (trigger != null) {
            TriggerHistory triggerHistory = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
            if (triggerHistory == null && (triggerHistory = this.triggerRouterService.findTriggerHistory(trigger.getSourceTableName())) == null) {
                triggerHistory = this.triggerRouterService.findTriggerHistory(trigger.getSourceTableName().toUpperCase());
            }
            if (triggerHistory != null) {
                String rowData = null;
                String pkData = null;
                if (whereClause != null) {
                    rowData = (String)this.jdbcTemplate.queryForObject(this.dbDialect.createCsvDataSql(trigger, triggerHistory, this.configurationService.getChannel(trigger.getChannelId()), whereClause), String.class);
                    if (rowData != null) {
                        rowData = rowData.trim();
                    }
                    if ((pkData = (String)this.jdbcTemplate.queryForObject(this.dbDialect.createCsvPrimaryKeySql(trigger, triggerHistory, this.configurationService.getChannel(trigger.getChannelId()), whereClause), String.class)) != null) {
                        pkData = pkData.trim();
                    }
                }
                data = new Data(trigger.getSourceTableName(), DataEventType.UPDATE, rowData, pkData, triggerHistory, trigger.getChannelId(), null, null);
            }
        }
        return data;
    }

    @Override
    public DataRef getDataRef() {
        List refs = this.getSimpleTemplate().query(this.getSql("findDataRefSql"), (RowMapper)new RowMapper<DataRef>(){

            public DataRef mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new DataRef(rs.getLong(1), rs.getDate(2));
            }
        }, new Object[0]);
        if (refs.size() > 0) {
            return (DataRef)refs.get(0);
        }
        return new DataRef(-1L, new Date());
    }

    @Override
    public List<DataGap> findDataGapsByStatus(DataGap.Status status) {
        return this.getSimpleTemplate().query(this.getSql("findDataGapsByStatusSql"), (RowMapper)new RowMapper<DataGap>(){

            public DataGap mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new DataGap(rs.getLong(1), rs.getLong(2), rs.getTimestamp(3));
            }
        }, new Object[]{status.name()});
    }

    @Override
    public List<DataGap> findDataGaps() {
        long maxDataToSelect = this.parameterService.getInt("routing.largest.gap.size");
        List<DataGap> gaps = this.findDataGapsByStatus(DataGap.Status.GP);
        boolean lastGapExists = false;
        for (DataGap dataGap : gaps) {
            lastGapExists |= dataGap.gapSize() >= maxDataToSelect - 1L;
        }
        if (!lastGapExists) {
            long maxDataId = this.findMaxDataEventDataId();
            if (maxDataId > 0L) {
                ++maxDataId;
            }
            this.insertDataGap(new DataGap(maxDataId, maxDataId + maxDataToSelect));
            gaps = this.findDataGaps();
        }
        return gaps;
    }

    public long findMaxDataEventDataId() {
        return this.jdbcTemplate.queryForLong(this.getSql("selectMaxDataEventDataIdSql"));
    }

    @Override
    public void insertDataGap(DataGap gap) {
        this.jdbcTemplate.update(this.getSql("insertDataGapSql"), new Object[]{DataGap.Status.GP.name(), AppUtils.getHostName(), gap.getStartId(), gap.getEndId()}, new int[]{12, 12, 4, 4});
    }

    @Override
    public void updateDataGap(DataGap gap, DataGap.Status status) {
        this.jdbcTemplate.update(this.getSql("updateDataGapSql"), new Object[]{status.name(), AppUtils.getHostName(), gap.getStartId(), gap.getEndId()}, new int[]{12, 12, 4, 4});
    }

    @Override
    public void saveDataRef(DataRef dataRef) {
        if (0 >= this.jdbcTemplate.update(this.getSql("updateDataRefSql"), new Object[]{dataRef.getRefDataId(), dataRef.getRefTime()}, new int[]{4, 93})) {
            this.jdbcTemplate.update(this.getSql("insertDataRefSql"), new Object[]{dataRef.getRefDataId(), dataRef.getRefTime()}, new int[]{4, 93});
        }
    }

    @Override
    public Date findCreateTimeOfEvent(long dataId) {
        try {
            return (Date)this.jdbcTemplate.queryForObject(this.getSql("findDataEventCreateTimeSql"), new Object[]{dataId}, new int[]{4}, Date.class);
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    @Override
    public Date findCreateTimeOfData(long dataId) {
        try {
            return (Date)this.jdbcTemplate.queryForObject(this.getSql("findDataCreateTimeSql"), new Object[]{dataId}, new int[]{4}, Date.class);
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    @Override
    public Map<String, String> getRowDataAsMap(Data data) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] columnNames = CsvUtils.tokenizeCsvData(data.getTriggerHistory().getColumnNames());
        String[] columnData = CsvUtils.tokenizeCsvData(data.getRowData());
        for (int i = 0; i < columnNames.length; ++i) {
            map.put(columnNames[i].toLowerCase(), columnData[i]);
        }
        return map;
    }

    @Override
    public void setRowDataFromMap(Data data, Map<String, String> map) {
        String[] columnNames = CsvUtils.tokenizeCsvData(data.getTriggerHistory().getColumnNames());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(out), ',');
        writer.setEscapeMode(2);
        for (String columnName : columnNames) {
            try {
                writer.write(map.get(columnName.toLowerCase()), true);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        writer.close();
        data.setRowData(out.toString());
    }

    protected List<IHeartbeatListener> getHeartbeatListeners(boolean force) {
        if (force) {
            return this.heartbeatListeners;
        }
        ArrayList<IHeartbeatListener> listeners = new ArrayList<IHeartbeatListener>();
        if (listeners != null) {
            long ts = System.currentTimeMillis();
            for (IHeartbeatListener iHeartbeatListener : this.heartbeatListeners) {
                Long lastHeartbeatTimestamp = this.lastHeartbeatTimestamps.get(iHeartbeatListener);
                if (lastHeartbeatTimestamp != null && lastHeartbeatTimestamp > ts - iHeartbeatListener.getTimeBetweenHeartbeatsInSeconds() * 1000L) continue;
                listeners.add(iHeartbeatListener);
            }
        }
        return listeners;
    }

    protected void updateLastHeartbeatTime(List<IHeartbeatListener> listeners) {
        if (listeners != null) {
            Long ts = System.currentTimeMillis();
            for (IHeartbeatListener iHeartbeatListener : listeners) {
                this.lastHeartbeatTimestamps.put(iHeartbeatListener, ts);
            }
        }
    }

    @Override
    @Transactional
    public void heartbeat(boolean force) {
        List<IHeartbeatListener> listeners = this.getHeartbeatListeners(force);
        if (listeners.size() > 0) {
            Node me = this.nodeService.findIdentity();
            if (me != null) {
                this.log.info("NodeVersionUpdating");
                Calendar now = Calendar.getInstance();
                now.set(14, 0);
                me.setDeploymentType(this.deploymentType.getDeploymentType());
                me.setHeartbeatTime(now.getTime());
                me.setTimezoneOffset(AppUtils.getTimezoneOffset());
                me.setSymmetricVersion(Version.version());
                me.setDatabaseType(this.dbDialect.getName());
                me.setDatabaseVersion(this.dbDialect.getVersion());
                me.setBatchInErrorCount(this.outgoingBatchService.countOutgoingBatchesInError());
                if (this.parameterService.is("auto.update.node.values.from.properties")) {
                    this.log.info("NodeConfigurationUpdating");
                    me.setSchemaVersion(this.parameterService.getString("schema.version"));
                    me.setExternalId(this.parameterService.getExternalId());
                    me.setNodeGroupId(this.parameterService.getNodeGroupId());
                    if (!StringUtils.isBlank((String)this.parameterService.getSyncUrl())) {
                        me.setSyncUrl(this.parameterService.getSyncUrl());
                    }
                }
                this.nodeService.updateNode(me);
                this.nodeService.updateNodeHostForCurrentNode();
                this.log.info("NodeVersionUpdated");
                Set<Node> children = this.nodeService.findNodesThatOriginatedFromNodeId(me.getNodeId());
                for (IHeartbeatListener l : listeners) {
                    l.heartbeat(me, children);
                }
                this.updateLastHeartbeatTime(listeners);
            } else {
                this.log.debug("HeartbeatUpdatingFailureNodeNotConfigured");
            }
        }
    }

    @Override
    public void setReloadListeners(List<IReloadListener> listeners) {
        this.reloadListeners = listeners;
    }

    @Override
    public void addReloadListener(IReloadListener listener) {
        if (this.reloadListeners == null) {
            this.reloadListeners = new ArrayList<IReloadListener>();
        }
        this.reloadListeners.add(listener);
    }

    @Override
    public boolean removeReloadListener(IReloadListener listener) {
        if (this.reloadListeners != null) {
            return this.reloadListeners.remove(listener);
        }
        return false;
    }

    public void setHeartbeatListeners(List<IHeartbeatListener> listeners) {
        this.heartbeatListeners = listeners;
    }

    @Override
    public void addHeartbeatListener(IHeartbeatListener listener) {
        if (this.heartbeatListeners == null) {
            this.heartbeatListeners = new ArrayList<IHeartbeatListener>();
        }
        this.heartbeatListeners.add(listener);
    }

    public boolean removeHeartbeatListener(IHeartbeatListener listener) {
        if (this.heartbeatListeners != null) {
            return this.heartbeatListeners.remove(listener);
        }
        return false;
    }

    private final String getOrderByDataId(boolean descending) {
        return descending ? " order by d.data_id desc" : "order by d.data_id asc";
    }

    @Override
    public List<Number> listDataIds(long batchId, boolean descending) {
        return this.jdbcTemplate.query(this.getSql("selectEventDataIdsSql", this.getOrderByDataId(descending)), new Object[]{batchId}, (RowMapper)new SingleColumnRowMapper());
    }

    @Override
    public List<Data> listData(long batchId, long startDataId, String channelId, boolean descending, final int maxRowsToRetrieve) {
        final ArrayList<Data> list = new ArrayList<Data>(maxRowsToRetrieve);
        this.handleDataSelect(batchId, startDataId, channelId, descending, new IModelRetrievalHandler<Data, String>(){

            @Override
            public boolean retrieved(Data data, String routerId, int count) throws IOException {
                list.add(data);
                return count < maxRowsToRetrieve;
            }
        });
        return list;
    }

    @Override
    public void handleDataSelect(final long batchId, final long startDataId, final String channelId, final boolean descending, final IModelRetrievalHandler<Data, String> handler) {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object doInConnection(Connection conn) throws SQLException, DataAccessException {
                PreparedStatement ps;
                ResultSet rs;
                block10: {
                    rs = null;
                    ps = null;
                    boolean autoCommitFlag = conn.getAutoCommit();
                    try {
                        if (DataService.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                            conn.setAutoCommit(false);
                        }
                        String orderBy = DataService.this.getOrderByDataId(descending);
                        String startAtDataIdSql = startDataId >= 0L ? (descending ? " and d.data_id <= ? " : " and d.data_id >= ? ") : "";
                        String sql = DataService.this.dbDialect.massageDataExtractionSql(DataService.this.getSql("selectEventDataToExtractSql", startAtDataIdSql, orderBy), DataService.this.configurationService.getNodeChannel(channelId, false).getChannel());
                        ps = conn.prepareStatement(sql, 1003, 1007);
                        ps.setQueryTimeout(DataService.this.jdbcTemplate.getQueryTimeout());
                        ps.setFetchSize(DataService.this.dbDialect.getStreamingResultsFetchSize());
                        ps.setLong(1, batchId);
                        if (StringUtils.isNotBlank((String)startAtDataIdSql)) {
                            ps.setLong(2, startDataId);
                        }
                        long ts = System.currentTimeMillis();
                        rs = ps.executeQuery();
                        long executeTimeInMs = System.currentTimeMillis() - ts;
                        if (executeTimeInMs > 30000L) {
                            DataService.this.log.warn("LongRunningOperation", "selecting data to extract", executeTimeInMs);
                        }
                        int count = 0;
                        boolean continueReading = true;
                        ts = System.currentTimeMillis();
                        while (rs.next() && continueReading) {
                            try {
                                continueReading = handler.retrieved(DataService.this.readData(rs), rs.getString(13), ++count);
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            executeTimeInMs = System.currentTimeMillis() - ts;
                            if (executeTimeInMs <= 600000L) continue;
                            DataService.this.log.warn("LongRunningOperation", "extracted " + count + " data for batch " + batchId, executeTimeInMs);
                            ts = System.currentTimeMillis();
                        }
                        Object var16_14 = null;
                        if (!DataService.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) break block10;
                    }
                    catch (Throwable throwable) {
                        Object var16_15 = null;
                        if (DataService.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                            conn.commit();
                            conn.setAutoCommit(autoCommitFlag);
                        }
                        JdbcUtils.closeResultSet(rs);
                        JdbcUtils.closeStatement(ps);
                        throw throwable;
                    }
                    conn.commit();
                    conn.setAutoCommit(autoCommitFlag);
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                JdbcUtils.closeStatement((Statement)ps);
                return null;
            }
        });
    }

    @Override
    public Data readData(ResultSet results) throws SQLException {
        Data data = new Data();
        data.setDataId(results.getLong(1));
        data.setTableName(results.getString(2));
        data.setEventType(DataEventType.getEventType(results.getString(3)));
        data.setRowData(results.getString(4));
        data.setPkData(results.getString(5));
        data.setOldData(results.getString(6));
        data.setCreateTime(results.getDate(7));
        int histId = results.getInt(8);
        data.setTriggerHistory(this.triggerRouterService.getTriggerHistory(histId));
        if (data.getTriggerHistory() == null) {
            data.setTriggerHistory(new TriggerHistory(histId));
        }
        data.setChannelId(results.getString(9));
        data.setTransactionId(results.getString(10));
        data.setSourceNodeId(results.getString(11));
        data.setExternalData(results.getString(12));
        return data;
    }

    @Override
    public long findMaxDataId() {
        return this.jdbcTemplate.queryForLong(this.getSql("selectMaxDataIdSql"));
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPurgeService(IPurgeService purgeService) {
        this.purgeService = purgeService;
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    public void setDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransactionalInsertReloadEventsDelegate
    implements TransactionCallback<Object> {
        Node targetNode;

        public TransactionalInsertReloadEventsDelegate(Node targetNode) {
            this.targetNode = targetNode;
        }

        public Object doInTransaction(TransactionStatus status) {
            TriggerRouter triggerRouter2;
            Node sourceNode = DataService.this.nodeService.findIdentity();
            if (DataService.this.reloadListeners != null) {
                for (IReloadListener listener : DataService.this.reloadListeners) {
                    listener.beforeReload(this.targetNode);
                }
            }
            DataService.this.insertNodeSecurityUpdate(this.targetNode, true);
            ArrayList<TriggerRouter> triggerRouters = new ArrayList<TriggerRouter>(DataService.this.triggerRouterService.getAllTriggerRoutersForReloadForCurrentNode(sourceNode.getNodeGroupId(), this.targetNode.getNodeGroupId()));
            Iterator iterator = triggerRouters.iterator();
            while (iterator.hasNext()) {
                triggerRouter2 = (TriggerRouter)iterator.next();
                Trigger trigger = triggerRouter2.getTrigger();
                Table table = DataService.this.dbDialect.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false);
                if (table != null) continue;
                DataService.this.log.warn("TriggerTableMissing", trigger.qualifiedSourceTableName());
                iterator.remove();
            }
            if (DataService.this.parameterService.is("initial.load.create.first")) {
                for (TriggerRouter triggerRouter2 : triggerRouters) {
                    String xml = DataService.this.dbDialect.getCreateTableXML(triggerRouter2);
                    DataService.this.insertCreateEvent(this.targetNode, triggerRouter2, xml, true);
                }
            }
            if (DataService.this.parameterService.is("initial.load.delete.first")) {
                iterator = triggerRouters.listIterator(triggerRouters.size());
                while (iterator.hasPrevious()) {
                    triggerRouter2 = (TriggerRouter)iterator.previous();
                    DataService.this.insertPurgeEvent(this.targetNode, triggerRouter2, true);
                }
            }
            for (TriggerRouter trigger : triggerRouters) {
                DataService.this.insertReloadEvent(this.targetNode, trigger);
            }
            if (DataService.this.reloadListeners != null) {
                for (IReloadListener listener : DataService.this.reloadListeners) {
                    listener.afterReload(this.targetNode);
                }
            }
            DataService.this.nodeService.setInitialLoadEnabled(this.targetNode.getNodeId(), false);
            DataService.this.insertNodeSecurityUpdate(this.targetNode, DataService.this.parameterService.is("initial.load.use.reload.channel"));
            DataService.this.statisticManager.incrementNodesLoaded(1L);
            return null;
        }
    }
}

