/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.List;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IPullService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.impl.AbstractOfflineDetectorService;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.TransportException;

public class PullService
extends AbstractOfflineDetectorService
implements IPullService {
    private INodeService nodeService;
    private IDataLoaderService dataLoaderService;
    private IRegistrationService registrationService;
    private IClusterService clusterService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteNodeStatuses pullData() {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses();
        Node identity = this.nodeService.findIdentity(false);
        if (identity == null || identity.isSyncEnabled()) {
            if (this.clusterService.lock("PULL")) {
                try {
                    this.registrationService.registerWithServer();
                    List<Node> nodes = this.nodeService.findNodesToPull();
                    if (nodes != null && nodes.size() > 0) {
                        for (Node node : nodes) {
                            RemoteNodeStatus status = statuses.add(node);
                            try {
                                this.log.debug("DataPulling", node.toString());
                                this.dataLoaderService.loadDataFromPull(node, status);
                                if (status.getDataProcessed() > 0L || status.getBatchesProcessed() > 0L) {
                                    this.log.info("DataPulled", node.toString(), status.getDataProcessed(), status.getBatchesProcessed());
                                    continue;
                                }
                                this.log.debug("DataPulled", node.toString(), status.getDataProcessed(), status.getBatchesProcessed());
                            }
                            catch (ConnectException ex) {
                                this.log.warn("TransportFailedConnectionUnavailable", node.getSyncUrl() == null ? this.parameterService.getRegistrationUrl() : node.getSyncUrl());
                                this.fireOffline(ex, node, status);
                            }
                            catch (ConnectionRejectedException ex) {
                                this.log.warn("TransportFailedConnectionBusy");
                                this.fireOffline(ex, node, status);
                            }
                            catch (AuthenticationException ex) {
                                this.log.warn("AuthenticationFailed");
                                this.fireOffline(ex, node, status);
                            }
                            catch (SyncDisabledException ex) {
                                this.log.warn("SyncDisabled");
                                this.fireOffline(ex, node, status);
                            }
                            catch (SocketException ex) {
                                this.log.warn("Message", ex.getMessage());
                                this.fireOffline(ex, node, status);
                            }
                            catch (TransportException ex) {
                                this.log.warn("Message", ex.getMessage());
                                this.fireOffline(ex, node, status);
                            }
                            catch (IOException ex) {
                                this.log.error(ex);
                                this.fireOffline(ex, node, status);
                            }
                        }
                    }
                    Object var9_15 = null;
                    this.clusterService.unlock("PULL");
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    this.clusterService.unlock("PULL");
                    throw throwable;
                }
            } else {
                this.log.info("DataPullingFailedLock");
            }
        }
        return statuses;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDataLoaderService(IDataLoaderService dataLoaderService) {
        this.dataLoaderService = dataLoaderService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }
}

