/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IPushService;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractOfflineDetectorService;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.TransportException;

public class PushService
extends AbstractOfflineDetectorService
implements IPushService {
    private IDataExtractorService extractor;
    private IAcknowledgeService ackService;
    private ITransportManager transportManager;
    private INodeService nodeService;
    private IClusterService clusterService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteNodeStatuses pushData() {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses();
        Node identity = this.nodeService.findIdentity(false);
        if (identity != null && identity.isSyncEnabled()) {
            if (this.clusterService.lock("PUSH")) {
                try {
                    NodeSecurity identitySecurity = this.nodeService.findNodeSecurity(identity.getNodeId());
                    List<Node> nodes = this.nodeService.findNodesToPushTo();
                    if (nodes != null && nodes.size() > 0) {
                        if (identitySecurity != null) {
                            for (Node node : nodes) {
                                this.log.debug("DataPushing", node);
                                RemoteNodeStatus status = this.pushToNode(node, identity, identitySecurity);
                                statuses.add(status);
                                if (status.getBatchesProcessed() > 0L) {
                                    this.log.info("DataPushed", node);
                                } else if (status.failed()) {
                                    this.log.warn("DataPushingFailed");
                                }
                                this.log.debug("DataPushingCompleted", node);
                            }
                        } else {
                            this.log.error("NodeSecurityMissing", identity.getNodeId());
                        }
                    }
                    Object var9_8 = null;
                    this.clusterService.unlock("PUSH");
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this.clusterService.unlock("PUSH");
                    throw throwable;
                }
            } else {
                this.log.info("DataPushingFailedLock");
            }
        }
        return statuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RemoteNodeStatus pushToNode(Node remote, Node identity, NodeSecurity identitySecurity) {
        RemoteNodeStatus status;
        block25: {
            IOutgoingTransport transport;
            block24: {
                status = new RemoteNodeStatus(remote.getNodeId());
                transport = null;
                transport = this.transportManager.getPushTransport(remote, identity, identitySecurity.getNodePassword(), this.parameterService.getRegistrationUrl());
                List<OutgoingBatch> extractedBatches = this.extractor.extract(remote, transport);
                if (extractedBatches.size() <= 0) break block24;
                this.log.info("DataSent", remote);
                BufferedReader reader = transport.readResponse();
                String ackString = reader.readLine();
                String ackExtendedString = reader.readLine();
                this.log.debug("DataAckReading", ackString);
                this.log.debug("DataAckExtendedReading", ackExtendedString);
                if (StringUtils.isBlank((String)ackString)) {
                    this.log.error("DataAckReadingFailed");
                }
                List<BatchInfo> batches = this.transportManager.readAcknowledgement(ackString, ackExtendedString);
                for (BatchInfo batchInfo : batches) {
                    this.log.debug("DataAckSaving", batchInfo.getBatchId(), batchInfo.isOk() ? "OK" : "error");
                    this.ackService.ack(batchInfo);
                }
                status.updateOutgoingStatus(extractedBatches, batches);
            }
            Object var14_21 = null;
            try {
                transport.close();
            }
            catch (Exception e) {}
            break block25;
            {
                catch (ConnectException ex) {
                    this.log.warn("TransportFailedConnectionUnavailable", remote.getSyncUrl() == null ? this.parameterService.getRegistrationUrl() : remote.getSyncUrl());
                    this.fireOffline(ex, remote, status);
                    Object var14_22 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block25;
                }
                catch (ConnectionRejectedException ex) {
                    this.log.warn("TransportFailedConnectionBusy");
                    this.fireOffline(ex, remote, status);
                    Object var14_23 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block25;
                }
                catch (SocketException ex) {
                    this.log.warn("Message", ex.getMessage());
                    this.fireOffline(ex, remote, status);
                    Object var14_24 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block25;
                }
                catch (TransportException ex) {
                    this.log.warn("Message", ex.getMessage());
                    this.fireOffline(ex, remote, status);
                    Object var14_25 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block25;
                }
                catch (AuthenticationException ex) {
                    this.log.warn("AuthenticationFailed");
                    this.fireOffline(ex, remote, status);
                    Object var14_26 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block25;
                }
                catch (SyncDisabledException ex) {
                    this.log.warn("SyncDisabled");
                    this.fireOffline(ex, remote, status);
                    Object var14_27 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block25;
                }
                catch (RegistrationRequiredException ex) {
                    this.log.warn("RegistrationRequired");
                    this.fireOffline(ex, remote, status);
                    Object var14_28 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block25;
                }
                catch (Exception ex) {
                    this.log.error(ex);
                    this.fireOffline(ex, remote, status);
                    Object var14_29 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_30 = null;
                try {
                    transport.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return status;
    }

    public void setExtractor(IDataExtractorService extractor) {
        this.extractor = extractor;
    }

    public void setTransportManager(ITransportManager tm) {
        this.transportManager = tm;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAckService(IAcknowledgeService ackService) {
        this.ackService = ackService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }
}

