/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.RegistrationRequest;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.RegistrationFailedException;
import org.jumpmind.symmetric.service.RegistrationRedirectException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.util.RandomTimeSlot;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationService
extends AbstractService
implements IRegistrationService {
    private INodeService nodeService;
    private IDataExtractorService dataExtractorService;
    private IDataService dataService;
    private IDataLoaderService dataLoaderService;
    private ITransportManager transportManager;
    private RandomTimeSlot randomTimeSlot;
    private INodePasswordFilter nodePasswordFilter;
    private IStatisticManager statisticManager;

    @Override
    public boolean registerNode(Node node, OutputStream out, boolean isRequestedRegistration) throws IOException {
        return this.registerNode(node, null, null, out, isRequestedRegistration);
    }

    @Override
    public boolean registerNode(Node node, String remoteHost, String remoteAddress, OutputStream out, boolean isRequestedRegistration) throws IOException {
        String redirectUrl;
        if (!this.nodeService.isRegistrationServer()) {
            NodeSecurity security;
            Node identity = this.nodeService.findIdentity();
            NodeSecurity nodeSecurity = security = identity == null ? null : this.nodeService.findNodeSecurity(identity.getNodeId());
            if (security == null || security.getInitialLoadTime() == null) {
                this.saveRegisgtrationRequest(new RegistrationRequest(node, RegistrationRequest.RegistrationStatus.RQ, remoteHost, remoteAddress));
                this.log.warn("RegistrationNotAllowedNoInitialLoad");
                return false;
            }
        }
        if ((redirectUrl = this.getRedirectionUrlFor(node.getExternalId())) != null) {
            this.log.info("RegistrationRedirecting", node.getExternalId(), redirectUrl);
            this.saveRegisgtrationRequest(new RegistrationRequest(node, RegistrationRequest.RegistrationStatus.RR, remoteHost, remoteAddress));
            throw new RegistrationRedirectException(redirectUrl);
        }
        String nodeId = StringUtils.isBlank((String)node.getNodeId()) ? this.nodeService.getNodeIdGenerator().selectNodeId(this.nodeService, node) : node.getNodeId();
        Node targetNode = this.nodeService.findNode(nodeId);
        NodeSecurity security = this.nodeService.findNodeSecurity(nodeId);
        if ((targetNode == null || security == null || !security.isRegistrationEnabled()) && this.parameterService.is("auto.registration")) {
            this.openRegistration(node);
            nodeId = StringUtils.isBlank((String)node.getNodeId()) ? this.nodeService.getNodeIdGenerator().selectNodeId(this.nodeService, node) : node.getNodeId();
            security = this.nodeService.findNodeSecurity(nodeId);
        } else if (targetNode == null || security == null || !security.isRegistrationEnabled()) {
            this.saveRegisgtrationRequest(new RegistrationRequest(node, RegistrationRequest.RegistrationStatus.RQ, remoteHost, remoteAddress));
            return false;
        }
        node.setNodeId(nodeId);
        this.jdbcTemplate.update(this.getSql("registerNodeSql"), new Object[]{node.getSyncUrl(), node.getSchemaVersion(), node.getDatabaseType(), node.getDatabaseVersion(), node.getSymmetricVersion(), node.getNodeId()}, new int[]{12, 12, 12, 12, 12, 12});
        if (node.getSymmetricVersion() != null && Version.isOlderThanVersion(node.getSymmetricVersion(), "1.6.0")) {
            this.markNodeAsRegistered(nodeId);
        }
        if (this.parameterService.is("auto.reload") && (security != null && security.getInitialLoadTime() == null || isRequestedRegistration)) {
            this.dataService.reloadNode(node.getNodeId());
        }
        this.dataExtractorService.extractConfigurationStandalone(node, out, new String[0]);
        this.saveRegisgtrationRequest(new RegistrationRequest(node, RegistrationRequest.RegistrationStatus.OK, remoteHost, remoteAddress));
        this.statisticManager.incrementNodesRegistered(1L);
        return true;
    }

    @Override
    public List<RegistrationRequest> getRegistrationRequests(boolean includeNodesWithOpenRegistrations) {
        List requests = this.jdbcTemplate.query(this.getSql("selectRegistrationRequestSql"), (RowMapper)new RegistrationRequestMapper(), new Object[]{RegistrationRequest.RegistrationStatus.RQ.name()});
        if (!includeNodesWithOpenRegistrations) {
            Collection<Node> nodes = this.nodeService.findNodesWithOpenRegistration();
            Iterator i = requests.iterator();
            while (i.hasNext()) {
                RegistrationRequest registrationRequest = (RegistrationRequest)i.next();
                for (Node node : nodes) {
                    if (!node.getNodeGroupId().equals(registrationRequest.getNodeGroupId()) || !node.getExternalId().equals(registrationRequest.getExternalId())) continue;
                    i.remove();
                }
            }
        }
        return requests;
    }

    @Override
    public void saveRegisgtrationRequest(RegistrationRequest request) {
        String externalId = request.getExternalId() == null ? "" : request.getExternalId();
        String nodeGroupId = request.getNodeGroupId() == null ? "" : request.getNodeGroupId();
        int count = this.jdbcTemplate.update(this.getSql("updateRegistrationRequestSql"), new Object[]{request.getLastUpdateBy(), request.getLastUpdateTime(), request.getRegisteredNodeId(), request.getStatus().name(), nodeGroupId, externalId, request.getIpAddress(), request.getHostName(), RegistrationRequest.RegistrationStatus.RQ.name()});
        if (count == 0) {
            this.jdbcTemplate.update(this.getSql("insertRegistrationRequestSql"), new Object[]{request.getLastUpdateBy(), request.getLastUpdateTime(), request.getRegisteredNodeId(), request.getStatus().name(), nodeGroupId, externalId, request.getIpAddress(), request.getHostName()});
        }
    }

    @Override
    public String getRedirectionUrlFor(String externalId) {
        List list = this.jdbcTemplate.queryForList(this.getSql("getRegistrationRedirectUrlSql"), new Object[]{externalId}, new int[]{12}, String.class);
        if (list.size() > 0) {
            return this.transportManager.resolveURL((String)list.get(0), this.parameterService.getRegistrationUrl());
        }
        return null;
    }

    @Override
    public void saveRegistrationRedirect(String externalIdToRedirect, String nodeIdToRedirectTo) {
        int count = this.jdbcTemplate.update(this.getSql("updateRegistrationRedirectUrlSql"), new Object[]{nodeIdToRedirectTo, externalIdToRedirect}, new int[]{12, 12});
        if (count == 0) {
            this.jdbcTemplate.update(this.getSql("insertRegistrationRedirectUrlSql"), new Object[]{nodeIdToRedirectTo, externalIdToRedirect}, new int[]{12, 12});
        }
    }

    @Override
    public void markNodeAsRegistered(String nodeId) {
        this.jdbcTemplate.update(this.getSql("registerNodeSecuritySql"), new Object[]{nodeId});
    }

    @Override
    public Map<String, String> getRegistrationRedirectMap() {
        return (Map)this.jdbcTemplate.query(this.getSql("getRegistrationRedirectSql"), new Object[0], (ResultSetExtractor)new ResultSetExtractor<Map<String, String>>(){

            public Map<String, String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, String> results = new HashMap<String, String>();
                while (rs.next()) {
                    results.put(rs.getString(1), rs.getString(2));
                }
                return results;
            }
        });
    }

    private void sleepBeforeRegistrationRetry() {
        try {
            long sleepTimeInMs = 1000L * (long)this.randomTimeSlot.getRandomValueSeededByExternalId();
            this.log.warn("NodeRegisteringFailed", sleepTimeInMs);
            Thread.sleep(sleepTimeInMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isRegisteredWithServer() {
        return this.nodeService.findIdentity() != null;
    }

    @Override
    public void registerWithServer() {
        boolean registered = this.isRegisteredWithServer();
        int maxNumberOfAttempts = this.parameterService.getInt("registration.number.of.attempts");
        while (!(registered || maxNumberOfAttempts >= 0 && maxNumberOfAttempts <= 0)) {
            boolean errorOccurred = false;
            try {
                this.log.info("NodeRegistering");
                registered = this.dataLoaderService.loadDataFromPull(null).getStatus() == RemoteNodeStatus.Status.DATA_PROCESSED;
            }
            catch (ConnectException e) {
                this.log.warn("NodeRegisteringFailedConnection");
            }
            catch (UnknownHostException e) {
                this.log.warn("NodeRegisteringFailedConnection");
            }
            catch (Exception e) {
                this.log.error(e);
            }
            if (!(registered || --maxNumberOfAttempts >= 0 && maxNumberOfAttempts <= 0)) {
                registered = this.isRegisteredWithServer();
            } else {
                Node node = this.nodeService.findIdentity();
                if (node != null) {
                    this.log.info("NodeRegistered", node.getNodeId());
                } else if (!errorOccurred) {
                    this.log.error("NodeRegisteringFailedIdentityMissing");
                    registered = false;
                } else {
                    this.log.error("NodeRegisteringFailedUnavailable");
                    registered = false;
                }
            }
            if (registered || maxNumberOfAttempts == 0) continue;
            this.sleepBeforeRegistrationRetry();
        }
        if (!registered) {
            throw new RegistrationFailedException(String.format("Failed after trying to register %s times.", this.parameterService.getString("registration.number.of.attempts")));
        }
    }

    @Override
    public synchronized void reOpenRegistration(String nodeId) {
        Node node = this.nodeService.findNode(nodeId);
        String password = this.nodeService.getNodeIdGenerator().generatePassword(this.nodeService, node);
        password = this.filterPasswordOnSaveIfNeeded(password);
        if (node != null) {
            int updateCount = this.jdbcTemplate.update(this.getSql("reopenRegistrationSql"), new Object[]{password, nodeId});
            if (updateCount == 0) {
                this.jdbcTemplate.update(this.getSql("openRegistrationNodeSecuritySql"), new Object[]{nodeId, password, this.nodeService.findNode(nodeId).getNodeId()});
            }
        } else {
            this.log.warn("NodeReregisteringFailed", nodeId);
        }
    }

    @Override
    public synchronized String openRegistration(String nodeGroup, String externalId) {
        Node node = new Node();
        node.setExternalId(externalId);
        node.setNodeGroupId(nodeGroup);
        return this.openRegistration(node);
    }

    protected synchronized String openRegistration(Node node) {
        Node me = this.nodeService.findIdentity();
        if (me != null || this.parameterService.getExternalId().equals(node.getExternalId()) && this.parameterService.getNodeGroupId().equals(node.getNodeGroupId())) {
            String nodeId = this.nodeService.getNodeIdGenerator().generateNodeId(this.nodeService, node);
            Node existingNode = this.nodeService.findNode(nodeId);
            if (existingNode == null) {
                this.nodeService.deleteNodeSecurity(nodeId);
                String password = this.nodeService.getNodeIdGenerator().generatePassword(this.nodeService, node);
                password = this.filterPasswordOnSaveIfNeeded(password);
                this.nodeService.insertNode(nodeId, node.getNodeGroupId(), node.getExternalId(), me.getNodeId());
                this.jdbcTemplate.update(this.getSql("openRegistrationNodeSecuritySql"), new Object[]{nodeId, password, me.getNodeId()});
                this.nodeService.insertNodeGroup(node.getNodeGroupId(), null);
                this.log.info("NodeRegistrationOpened", node.getExternalId(), node.getNodeGroupId(), nodeId);
            } else {
                this.reOpenRegistration(nodeId);
            }
            return nodeId;
        }
        throw new IllegalStateException("This node has not been configured.  Could not find a row in the identity table.");
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    @Override
    public boolean isAutoRegistration() {
        return this.parameterService.is("auto.registration");
    }

    public void setDataLoaderService(IDataLoaderService dataLoaderService) {
        this.dataLoaderService = dataLoaderService;
    }

    public void setTransportManager(ITransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public void setRandomTimeSlot(RandomTimeSlot randomTimeSlot) {
        this.randomTimeSlot = randomTimeSlot;
    }

    @Override
    public void setNodePasswordFilter(INodePasswordFilter nodePasswordFilter) {
        this.nodePasswordFilter = nodePasswordFilter;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    private String filterPasswordOnSaveIfNeeded(String password) {
        String s = password;
        if (this.nodePasswordFilter != null) {
            s = this.nodePasswordFilter.onNodeSecuritySave(password);
        }
        return s;
    }

    @Override
    public boolean isRegistrationOpen(String nodeGroupId, String externalId) {
        Node node = this.nodeService.findNodeByExternalId(nodeGroupId, externalId);
        if (node != null) {
            NodeSecurity security = this.nodeService.findNodeSecurity(node.getNodeId());
            return security != null && security.isRegistrationEnabled();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegistrationRequestMapper
    implements RowMapper<RegistrationRequest> {
        RegistrationRequestMapper() {
        }

        public RegistrationRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
            RegistrationRequest request = new RegistrationRequest();
            request.setNodeGroupId(rs.getString(1));
            request.setExternalId(rs.getString(2));
            request.setStatus(RegistrationRequest.RegistrationStatus.valueOf(RegistrationRequest.RegistrationStatus.class, rs.getString(3)));
            request.setHostName(rs.getString(4));
            request.setIpAddress(rs.getString(5));
            request.setAttemptCount(rs.getLong(6));
            request.setRegisteredNodeId(rs.getString(7));
            request.setCreateTime(rs.getTimestamp(8));
            request.setLastUpdateBy(rs.getString(7));
            request.setLastUpdateTime(rs.getTimestamp(8));
            return request;
        }
    }
}

