/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.ChannelStats;
import org.jumpmind.symmetric.statistic.ChannelStatsByPeriodMap;
import org.jumpmind.symmetric.statistic.HostStats;
import org.jumpmind.symmetric.statistic.HostStatsByPeriodMap;
import org.jumpmind.symmetric.statistic.JobStats;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticService
extends AbstractService
implements IStatisticService {
    @Override
    public void save(ChannelStats stats) {
        this.jdbcTemplate.update(this.getSql("insertChannelStatsSql"), new Object[]{stats.getNodeId(), stats.getHostName(), stats.getChannelId(), stats.getStartTime(), stats.getEndTime(), stats.getDataRouted(), stats.getDataUnRouted(), stats.getDataEventInserted(), stats.getDataExtracted(), stats.getDataBytesExtracted(), stats.getDataExtractedErrors(), stats.getDataSent(), stats.getDataBytesSent(), stats.getDataSentErrors(), stats.getDataLoaded(), stats.getDataBytesLoaded(), stats.getDataLoadedErrors()}, new int[]{12, 12, 12, 93, 93, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5});
    }

    @Override
    public void save(JobStats stats) {
        this.jdbcTemplate.update(this.getSql("insertJobStatsSql"), new Object[]{stats.getNodeId(), stats.getHostName(), stats.getJobName(), stats.getStartTime(), stats.getEndTime(), stats.getProcessedCount()}, new int[]{12, 12, 12, 93, 93, -5});
    }

    @Override
    public List<JobStats> getJobStatsForPeriod(Date start, Date end, String nodeId) {
        return this.jdbcTemplate.query(this.getSql("selectChannelStatsSql"), (RowMapper)new JobStatsMapper(), new Object[]{start, end, nodeId});
    }

    @Override
    public TreeMap<Date, Map<String, ChannelStats>> getChannelStatsForPeriod(Date start, Date end, String nodeId, int periodSizeInMinutes) {
        List list = this.jdbcTemplate.query(this.getSql("selectChannelStatsSql"), (RowMapper)new ChannelStatsMapper(), new Object[]{start, end, nodeId});
        return new ChannelStatsByPeriodMap(start, end, list, periodSizeInMinutes);
    }

    @Override
    public void save(HostStats stats) {
        this.jdbcTemplate.update(this.getSql("insertHostStatsSql"), new Object[]{stats.getNodeId(), stats.getHostName(), stats.getStartTime(), stats.getEndTime(), stats.getRestarted(), stats.getNodesPulled(), stats.getNodesPushed(), stats.getNodesRejected(), stats.getNodesRegistered(), stats.getNodesLoaded(), stats.getNodesDisabled(), stats.getPurgedDataRows(), stats.getPurgedDataEventRows(), stats.getPurgedBatchOutgoingRows(), stats.getPurgedBatchIncomingRows(), stats.getTriggersCreatedCount(), stats.getTriggersRebuiltCount(), stats.getTriggersRemovedCount(), stats.getTotalNodesPullTime(), stats.getTotalNodesPushTime()}, new int[]{12, 12, 93, 93, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5});
    }

    @Override
    public TreeMap<Date, HostStats> getHostStatsForPeriod(Date start, Date end, String nodeId, int periodSizeInMinutes) {
        List list = this.jdbcTemplate.query(this.getSql("selectHostStatsSql"), (RowMapper)new HostStatsMapper(), new Object[]{start, end, nodeId});
        return new HostStatsByPeriodMap(start, end, list, periodSizeInMinutes);
    }

    public Date truncateToMinutes(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HostStatsMapper
    implements RowMapper<HostStats> {
        HostStatsMapper() {
        }

        public HostStats mapRow(ResultSet rs, int rowNum) throws SQLException {
            HostStats stats = new HostStats();
            stats.setNodeId(rs.getString(1));
            stats.setHostName(rs.getString(2));
            stats.setStartTime(StatisticService.this.truncateToMinutes(rs.getTimestamp(3)));
            stats.setEndTime(StatisticService.this.truncateToMinutes(rs.getTimestamp(4)));
            stats.setRestarted(rs.getLong(5));
            stats.setNodesPulled(rs.getLong(6));
            stats.setNodesPushed(rs.getLong(7));
            stats.setNodesRejected(rs.getLong(8));
            stats.setNodesRegistered(rs.getLong(9));
            stats.setNodesLoaded(rs.getLong(10));
            stats.setNodesDisabled(rs.getLong(11));
            stats.setPurgedDataRows(rs.getLong(12));
            stats.setPurgedDataEventRows(rs.getLong(13));
            stats.setPurgedBatchOutgoingRows(rs.getLong(14));
            stats.setPurgedBatchIncomingRows(rs.getLong(15));
            stats.setTriggersCreatedCount(rs.getLong(16));
            stats.setTriggersRebuiltCount(rs.getLong(17));
            stats.setTriggersRemovedCount(rs.getLong(18));
            stats.setTotalNodesPullTime(rs.getLong(19));
            stats.setTotalNodesPushTime(rs.getLong(20));
            return stats;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChannelStatsMapper
    implements RowMapper<ChannelStats> {
        ChannelStatsMapper() {
        }

        public ChannelStats mapRow(ResultSet rs, int rowNum) throws SQLException {
            ChannelStats stats = new ChannelStats();
            stats.setNodeId(rs.getString(1));
            stats.setHostName(rs.getString(2));
            stats.setChannelId(rs.getString(3));
            stats.setStartTime(StatisticService.this.truncateToMinutes(rs.getTimestamp(4)));
            stats.setEndTime(StatisticService.this.truncateToMinutes(rs.getTimestamp(5)));
            stats.setDataRouted(rs.getLong(6));
            stats.setDataUnRouted(rs.getLong(7));
            stats.setDataEventInserted(rs.getLong(8));
            stats.setDataExtracted(rs.getLong(9));
            stats.setDataBytesExtracted(rs.getLong(10));
            stats.setDataExtractedErrors(rs.getLong(11));
            stats.setDataSent(rs.getLong(12));
            stats.setDataBytesSent(rs.getLong(13));
            stats.setDataSentErrors(rs.getLong(14));
            stats.setDataLoaded(rs.getLong(15));
            stats.setDataBytesLoaded(rs.getLong(16));
            stats.setDataLoadedErrors(rs.getLong(17));
            return stats;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JobStatsMapper
    implements RowMapper<JobStats> {
        JobStatsMapper() {
        }

        public JobStats mapRow(ResultSet rs, int rowNum) throws SQLException {
            JobStats stats = new JobStats();
            stats.setNodeId(rs.getString(1));
            stats.setHostName(rs.getString(2));
            stats.setJobName(rs.getString(3));
            stats.setStartTime(StatisticService.this.truncateToMinutes(rs.getTimestamp(4)));
            stats.setEndTime(StatisticService.this.truncateToMinutes(rs.getTimestamp(5)));
            stats.setProcessedCount(rs.getLong(6));
            return stats;
        }
    }
}

