/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.Message;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.config.ITriggerCreationListener;
import org.jumpmind.symmetric.config.TriggerFailureListener;
import org.jumpmind.symmetric.config.TriggerSelector;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ext.IExtraConfigTables;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerReBuildReason;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerRouterService
extends AbstractService
implements ITriggerRouterService {
    private Map<String, List<String>> rootConfigChannelTableNames;
    private IClusterService clusterService;
    private IConfigurationService configurationService;
    private Map<String, Router> routersCache;
    private Map<String, TriggerRoutersCache> triggerRouterCacheByNodeGroupId = new HashMap<String, TriggerRoutersCache>();
    private long triggerRouterCacheTime;
    private long routersCacheTime;
    private List<ITriggerCreationListener> triggerCreationListeners;
    private TriggerFailureListener failureListener = new TriggerFailureListener();
    private IStatisticManager statisticManager;
    private List<IExtraConfigTables> extraConfigTables = new ArrayList<IExtraConfigTables>();
    private HashMap<Integer, TriggerHistory> historyMap = new HashMap();

    public TriggerRouterService() {
        this.addTriggerCreationListeners(this.failureListener);
    }

    @Override
    public List<Trigger> getTriggers() {
        return this.jdbcTemplate.query("select " + this.getSql("selectTriggersColumnList", "selectTriggersSql"), (RowMapper)new TriggerMapper());
    }

    @Override
    public boolean isTriggerBeingUsed(String triggerId) {
        return this.jdbcTemplate.queryForInt(this.getSql("countTriggerRoutersByTriggerIdSql"), new Object[]{triggerId}) > 0;
    }

    @Override
    public boolean doesTriggerExist(String triggerId) {
        return this.jdbcTemplate.queryForInt(this.getSql("countTriggerByTriggerIdSql"), new Object[]{triggerId}) > 0;
    }

    @Override
    public boolean doesTriggerExistForTable(String tableName) {
        return this.jdbcTemplate.queryForInt(this.getSql("countTriggerByTableNameSql"), new Object[]{tableName}) > 0;
    }

    @Override
    public void deleteTrigger(Trigger trigger) {
        this.jdbcTemplate.update(this.getSql("deleteTriggerSql"), new Object[]{trigger.getTriggerId()});
    }

    protected void deleteTriggerHistory(TriggerHistory history) {
        this.jdbcTemplate.update(this.getSql("deleteTriggerHistorySql"), new Object[]{history.getTriggerHistoryId()});
    }

    @Override
    public void createTriggersOnChannelForTables(String channelId, String catalogName, String schemaName, List<String> tables, String lastUpdateBy) {
        for (String table : tables) {
            Trigger trigger = new Trigger();
            trigger.setChannelId(channelId);
            trigger.setSourceCatalogName(catalogName);
            trigger.setSourceSchemaName(schemaName);
            trigger.setSourceTableName(table);
            trigger.setTriggerId(table);
            trigger.setLastUpdateBy(lastUpdateBy);
            trigger.setLastUpdateTime(new Date());
            trigger.setCreateTime(new Date());
            this.saveTrigger(trigger);
        }
    }

    @Override
    public void createTriggersOnChannelForTables(String channelId, Set<Table> tables, String lastUpdateBy) {
        for (Table table : tables) {
            Trigger trigger = new Trigger();
            trigger.setChannelId(channelId);
            trigger.setSourceTableName(table.getName());
            trigger.setTriggerId(table.getName());
            trigger.setLastUpdateBy(lastUpdateBy);
            trigger.setLastUpdateTime(new Date());
            trigger.setCreateTime(new Date());
            this.saveTrigger(trigger);
        }
    }

    @Override
    public void inactivateTriggerHistory(TriggerHistory history) {
        this.jdbcTemplate.update(this.getSql("inactivateTriggerHistorySql"), new Object[]{history.getErrorMessage(), history.getTriggerHistoryId()});
    }

    @Override
    public Map<Long, TriggerHistory> getHistoryRecords() {
        HashMap<Long, TriggerHistory> retMap = new HashMap<Long, TriggerHistory>();
        this.jdbcTemplate.query(this.getSql("allTriggerHistSql"), (RowMapper)new TriggerHistoryMapper(retMap));
        return retMap;
    }

    protected boolean isTriggerNameInUse(String triggerId, String triggerName) {
        return this.jdbcTemplate.queryForInt(this.getSql("selectTriggerNameInUseSql"), new Object[]{triggerName, triggerName, triggerName, triggerId}) > 0;
    }

    @Override
    public TriggerHistory findTriggerHistory(String sourceTableName) {
        HashMap<Long, TriggerHistory> retMap = new HashMap<Long, TriggerHistory>();
        this.jdbcTemplate.query(this.getSql("allTriggerHistSql", "triggerHistBySourceTableWhereSql"), new Object[]{sourceTableName}, new int[]{12}, (RowMapper)new TriggerHistoryMapper(retMap));
        if (retMap.size() > 0) {
            return (TriggerHistory)retMap.values().iterator().next();
        }
        return null;
    }

    @Override
    public TriggerHistory getTriggerHistory(int histId) {
        TriggerHistory history = this.historyMap.get(histId);
        if (history == null && histId >= 0) {
            try {
                history = (TriggerHistory)this.jdbcTemplate.queryForObject(this.getSql("triggerHistSql"), new Object[]{histId}, (RowMapper)new TriggerHistoryMapper());
                this.historyMap.put(histId, history);
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
        }
        return history;
    }

    @Override
    public TriggerHistory getNewestTriggerHistoryForTrigger(String triggerId) {
        try {
            return (TriggerHistory)this.jdbcTemplate.queryForObject(this.getSql("latestTriggerHistSql"), new Object[]{triggerId}, (RowMapper)new TriggerHistoryMapper());
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    @Override
    public List<TriggerHistory> getActiveTriggerHistories() {
        return this.jdbcTemplate.query(this.getSql("allTriggerHistSql", "activeTriggerHistSql"), (RowMapper)new TriggerHistoryMapper());
    }

    private String getNewestVersionOfRootConfigChannelTableNames() {
        TreeSet<String> ordered = new TreeSet<String>(this.rootConfigChannelTableNames.keySet());
        return ordered.last();
    }

    private String getMajorVersion(String version) {
        String majorVersion = Integer.toString(Version.parseVersion(version)[0]);
        List<String> tables = this.rootConfigChannelTableNames.get(majorVersion);
        if (tables == null) {
            String newestVersion = this.getNewestVersionOfRootConfigChannelTableNames();
            this.log.warn("TriggersDefaultVersionWarning", newestVersion, majorVersion);
            majorVersion = newestVersion;
        }
        return majorVersion;
    }

    @Override
    public List<TriggerRouter> getTriggerRoutersForRegistration(String version, NodeGroupLink nodeGroupLink, String ... tablesToExclude) {
        int initialLoadOrder = 1;
        String majorVersion = this.getMajorVersion(version);
        ArrayList<String> tables = new ArrayList<String>((Collection)this.rootConfigChannelTableNames.get(majorVersion));
        if (this.extraConfigTables != null) {
            for (IExtraConfigTables extraTables : this.extraConfigTables) {
                tables.addAll(extraTables.provideTableNames());
            }
        }
        if (tablesToExclude != null) {
            for (String tableToExclude : tablesToExclude) {
                String tablename = TableConstants.getTableName(this.tablePrefix, tableToExclude);
                if (tables.remove(tablename) || tables.remove(tablename.toUpperCase())) continue;
                tables.remove(tablename.toLowerCase());
            }
        }
        ArrayList<TriggerRouter> triggers = new ArrayList<TriggerRouter>(tables.size());
        for (int j = 0; j < tables.size(); ++j) {
            String tableName = (String)tables.get(j);
            boolean syncChanges = !TableConstants.getTablesThatDoNotSync(this.tablePrefix).contains(tableName);
            TriggerRouter trigger = this.buildRegistrationTriggerRouter(version, tableName, syncChanges, nodeGroupLink);
            trigger.setInitialLoadOrder(initialLoadOrder++);
            if (tableName.equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, "trigger"))) {
                trigger.getRouter().setRouterType("trigger");
            }
            triggers.add(trigger);
        }
        return triggers;
    }

    protected TriggerRouter buildRegistrationTriggerRouter(String version, String tableName, boolean syncChanges, NodeGroupLink nodeGroupLink) {
        boolean autoSyncConfig = this.parameterService.is("auto.sync.configuration");
        TriggerRouter triggerRouter = new TriggerRouter();
        Trigger trigger = triggerRouter.getTrigger();
        trigger.setTriggerId(Integer.toString(Math.abs(tableName.hashCode())));
        trigger.setSyncOnDelete(syncChanges && autoSyncConfig);
        trigger.setSyncOnInsert(syncChanges && autoSyncConfig);
        trigger.setSyncOnUpdate(syncChanges && autoSyncConfig);
        trigger.setSyncOnIncomingBatch(true);
        trigger.setSourceTableName(tableName);
        trigger.setChannelId("config");
        Router router = triggerRouter.getRouter();
        router.setRouterType("configurationChanged");
        router.setNodeGroupLink(nodeGroupLink);
        trigger.setLastUpdateTime(new Date(Version.version().hashCode()));
        router.setLastUpdateTime(trigger.getLastUpdateTime());
        triggerRouter.setLastUpdateTime(trigger.getLastUpdateTime());
        return triggerRouter;
    }

    private String getTriggerRouterSql() {
        return this.getTriggerRouterSql(null);
    }

    private String getTriggerRouterSql(String sql) {
        return this.getSql("select", "selectTriggersColumnList", ",", "selectRoutersColumnList", ",", "selectTriggerRoutersColumnList", "selectTriggerRoutersSql", sql);
    }

    @Override
    public List<TriggerRouter> getTriggerRouters() {
        return this.jdbcTemplate.query(this.getTriggerRouterSql(), (RowMapper)new TriggerRouterMapper());
    }

    @Override
    public Set<TriggerRouter> getTriggerRouterForTableForCurrentNode(String catalogName, String schemaName, String tableName, boolean refreshCache) {
        return this.getTriggerRouterForTableForCurrentNode(null, catalogName, schemaName, tableName, refreshCache);
    }

    @Override
    public Set<TriggerRouter> getTriggerRouterForTableForCurrentNode(NodeGroupLink link, String catalogName, String schemaName, String tableName, boolean refreshCache) {
        TriggerRoutersCache cache = this.getTriggerRoutersCacheForCurrentNode(refreshCache);
        Collection<List<TriggerRouter>> triggerRouters = cache.triggerRoutersByTriggerId.values();
        HashSet<TriggerRouter> returnList = new HashSet<TriggerRouter>();
        for (List<TriggerRouter> list : triggerRouters) {
            for (TriggerRouter triggerRouter : list) {
                if (!this.isMatch(link, triggerRouter) || !this.isMatch(catalogName, schemaName, tableName, triggerRouter.getTrigger())) continue;
                returnList.add(triggerRouter);
            }
        }
        return returnList;
    }

    protected boolean isMatch(NodeGroupLink link, TriggerRouter router) {
        if (link != null && router != null && router.getRouter() != null) {
            return link.getSourceNodeGroupId().equals(router.getRouter().getNodeGroupLink().getSourceNodeGroupId()) && link.getTargetNodeGroupId().equals(router.getRouter().getNodeGroupLink().getTargetNodeGroupId());
        }
        return true;
    }

    protected boolean isMatch(String catalogName, String schemaName, String tableName, Trigger trigger) {
        if (!StringUtils.isBlank((String)tableName) && !tableName.equals(trigger.getSourceTableName())) {
            return false;
        }
        if (StringUtils.isBlank((String)tableName) && !StringUtils.isBlank((String)trigger.getSourceTableName())) {
            return false;
        }
        if (!StringUtils.isBlank((String)catalogName) && !catalogName.equals(trigger.getSourceCatalogName())) {
            return false;
        }
        if (StringUtils.isBlank((String)catalogName) && !StringUtils.isBlank((String)trigger.getSourceCatalogName())) {
            return false;
        }
        if (!StringUtils.isBlank((String)schemaName) && !schemaName.equals(trigger.getSourceSchemaName())) {
            return false;
        }
        return !StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)trigger.getSourceSchemaName());
    }

    protected List<TriggerRouter> getConfigurationTablesTriggerRoutersForCurrentNode(String sourceNodeGroupId) {
        ArrayList<TriggerRouter> triggers = new ArrayList<TriggerRouter>();
        List<NodeGroupLink> links = this.configurationService.getNodeGroupLinksFor(sourceNodeGroupId);
        for (NodeGroupLink nodeGroupLink : links) {
            triggers.addAll(this.getTriggerRoutersForRegistration(Version.version(), nodeGroupLink, new String[0]));
            if (NodeGroupLinkAction.P != nodeGroupLink.getDataEventAction()) continue;
            triggers.add(this.buildRegistrationTriggerRouter(Version.version(), TableConstants.getTableName(this.tablePrefix, "node_host"), true, nodeGroupLink));
            this.log.debug("TriggerHistCreating", TableConstants.getTableName(this.tablePrefix, "node_host"));
        }
        return triggers;
    }

    protected void mergeInConfigurationTablesTriggerRoutersForCurrentNode(String sourceNodeGroupId, List<TriggerRouter> configuredInDatabase) {
        List<TriggerRouter> virtualConfigTriggers = this.getConfigurationTablesTriggerRoutersForCurrentNode(sourceNodeGroupId);
        for (TriggerRouter trigger : virtualConfigTriggers) {
            if (!trigger.getRouter().getNodeGroupLink().getSourceNodeGroupId().equalsIgnoreCase(sourceNodeGroupId) || this.doesTriggerRouterExistInList(configuredInDatabase, trigger)) continue;
            configuredInDatabase.add(trigger);
        }
    }

    protected boolean doesTriggerRouterExistInList(List<TriggerRouter> triggerRouters, TriggerRouter triggerRouter) {
        for (TriggerRouter checkMe : triggerRouters) {
            if (!checkMe.isSame(triggerRouter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersForCurrentNode(boolean refreshCache) {
        return this.getTriggerRoutersCacheForCurrentNode((boolean)refreshCache).triggerRoutersByTriggerId;
    }

    @Override
    public List<Trigger> getTriggersForCurrentNode(boolean refreshCache) {
        Map<String, List<TriggerRouter>> triggerRouters = this.getTriggerRoutersForCurrentNode(refreshCache);
        ArrayList<Trigger> triggers = new ArrayList<Trigger>(triggerRouters.size());
        for (List<TriggerRouter> list : triggerRouters.values()) {
            if (list.size() <= 0) continue;
            triggers.add(list.get(0).getTrigger());
        }
        return triggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TriggerRoutersCache getTriggerRoutersCacheForCurrentNode(boolean refreshCache) {
        TriggerRoutersCache cache;
        String myNodeGroupId = this.parameterService.getNodeGroupId();
        long triggerRouterCacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        TriggerRoutersCache triggerRoutersCache = cache = this.triggerRouterCacheByNodeGroupId == null ? null : this.triggerRouterCacheByNodeGroupId.get(myNodeGroupId);
        if (cache == null || refreshCache || System.currentTimeMillis() - this.triggerRouterCacheTime > triggerRouterCacheTimeoutInMs) {
            TriggerRouterService triggerRouterService = this;
            synchronized (triggerRouterService) {
                this.triggerRouterCacheTime = System.currentTimeMillis();
                HashMap<String, TriggerRoutersCache> newTriggerRouterCacheByNodeGroupId = new HashMap<String, TriggerRoutersCache>();
                List<TriggerRouter> triggerRouters = this.getAllTriggerRoutersForCurrentNode(myNodeGroupId);
                HashMap<String, List<TriggerRouter>> triggerRoutersByTriggerId = new HashMap<String, List<TriggerRouter>>(triggerRouters.size());
                HashMap<String, Router> routers = new HashMap<String, Router>(triggerRouters.size());
                for (TriggerRouter triggerRouter : triggerRouters) {
                    String triggerId = triggerRouter.getTrigger().getTriggerId();
                    ArrayList<TriggerRouter> list = (ArrayList<TriggerRouter>)triggerRoutersByTriggerId.get(triggerId);
                    if (list == null) {
                        list = new ArrayList<TriggerRouter>();
                        triggerRoutersByTriggerId.put(triggerId, list);
                    }
                    list.add(triggerRouter);
                    routers.put(triggerRouter.getRouter().getRouterId(), triggerRouter.getRouter());
                }
                newTriggerRouterCacheByNodeGroupId.put(myNodeGroupId, new TriggerRoutersCache(triggerRoutersByTriggerId, routers));
                this.triggerRouterCacheByNodeGroupId = newTriggerRouterCacheByNodeGroupId;
                cache = this.triggerRouterCacheByNodeGroupId == null ? null : this.triggerRouterCacheByNodeGroupId.get(myNodeGroupId);
            }
        }
        return cache;
    }

    @Override
    public Router getActiveRouterByIdForCurrentNode(String routerId, boolean refreshCache) {
        return this.getTriggerRoutersCacheForCurrentNode((boolean)refreshCache).routersByRouterId.get(routerId);
    }

    @Override
    public List<Router> getRoutersByGroupLink(NodeGroupLink link) {
        return this.jdbcTemplate.query(this.getSql("select", "selectRoutersColumnList", "selectRouterByNodeGroupLinkWhereSql"), (RowMapper)new RouterMapper(), new Object[]{link.getSourceNodeGroupId(), link.getTargetNodeGroupId()});
    }

    @Override
    public Router getRouterById(String routerId) {
        return this.getRouterById(routerId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Router getRouterById(String routerId, boolean refreshCache) {
        long routerCacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        Map<String, Router> cache = this.routersCache;
        if (cache == null || refreshCache || System.currentTimeMillis() - this.routersCacheTime > routerCacheTimeoutInMs) {
            TriggerRouterService triggerRouterService = this;
            synchronized (triggerRouterService) {
                this.routersCacheTime = System.currentTimeMillis();
                List<Router> routers = this.getRouters();
                cache = new HashMap<String, Router>(routers.size());
                for (Router router : routers) {
                    cache.put(router.getRouterId(), router);
                }
                this.routersCache = cache;
            }
        }
        return cache.get(routerId);
    }

    @Override
    public List<Router> getRouters() {
        return this.jdbcTemplate.query(this.getSql("select", "selectRoutersColumnList", "selectRoutersSql"), (RowMapper)new RouterMapper());
    }

    @Override
    public List<TriggerRouter> getAllTriggerRoutersForCurrentNode(String sourceNodeGroupId) {
        List triggers = this.jdbcTemplate.query(this.getTriggerRouterSql("activeTriggersForSourceNodeGroupSql"), new Object[]{sourceNodeGroupId}, (RowMapper)new TriggerRouterMapper());
        this.mergeInConfigurationTablesTriggerRoutersForCurrentNode(sourceNodeGroupId, triggers);
        return triggers;
    }

    @Override
    public List<TriggerRouter> getAllTriggerRoutersForReloadForCurrentNode(String sourceNodeGroupId, String targetNodeGroupId) {
        return this.jdbcTemplate.query(this.getTriggerRouterSql("activeTriggersForReloadSql"), new Object[]{sourceNodeGroupId, targetNodeGroupId, "config"}, (RowMapper)new TriggerRouterMapper());
    }

    @Override
    public TriggerRouter findTriggerRouterById(String triggerId, String routerId) {
        List configs = this.jdbcTemplate.query(this.getTriggerRouterSql("selectTriggerRouterSql"), new Object[]{triggerId, routerId}, (RowMapper)new TriggerRouterMapper());
        if (configs.size() > 0) {
            return (TriggerRouter)configs.get(0);
        }
        return null;
    }

    @Override
    public Trigger getTriggerById(String triggerId) {
        List triggers = this.jdbcTemplate.query(this.getTriggerRouterSql("selectTriggerByIdSql"), new Object[]{triggerId}, (RowMapper)new TriggerRouterMapper());
        if (triggers.size() > 0) {
            return ((TriggerRouter)triggers.get(0)).getTrigger();
        }
        return null;
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannel(String nodeGroupId) {
        final HashMap<String, List<TriggerRouter>> retMap = new HashMap<String, List<TriggerRouter>>();
        this.jdbcTemplate.query(this.getTriggerRouterSql("selectGroupTriggersSql"), new Object[]{nodeGroupId}, (RowMapper)new TriggerRouterMapper(){

            public TriggerRouter mapRow(ResultSet rs, int arg1) throws SQLException {
                TriggerRouter config = super.mapRow(rs, arg1);
                ArrayList<TriggerRouter> list = (ArrayList<TriggerRouter>)retMap.get(config.getTrigger().getChannelId());
                if (list == null) {
                    list = new ArrayList<TriggerRouter>();
                    retMap.put(config.getTrigger().getChannelId(), list);
                }
                list.add(config);
                return config;
            }
        });
        return retMap;
    }

    @Override
    public void insert(TriggerHistory newHistRecord) {
        this.jdbcTemplate.update(this.getSql("insertTriggerHistorySql"), new Object[]{newHistRecord.getTriggerId(), newHistRecord.getSourceTableName(), newHistRecord.getTableHash(), newHistRecord.getCreateTime(), newHistRecord.getColumnNames(), newHistRecord.getPkColumnNames(), newHistRecord.getLastTriggerBuildReason().getCode(), newHistRecord.getNameForDeleteTrigger(), newHistRecord.getNameForInsertTrigger(), newHistRecord.getNameForUpdateTrigger(), newHistRecord.getSourceSchemaName(), newHistRecord.getSourceCatalogName(), newHistRecord.getTriggerRowHash(), newHistRecord.getErrorMessage()}, new int[]{12, 12, -5, 93, 12, 12, 1, 12, 12, 12, 12, 12, -5, 12});
    }

    @Override
    public void deleteTriggerRouter(TriggerRouter triggerRouter) {
        this.jdbcTemplate.update(this.getSql("deleteTriggerRouterSql"), new Object[]{triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()});
    }

    @Override
    public void saveTriggerRouter(TriggerRouter triggerRouter) {
        this.saveTriggerRouter(triggerRouter, false);
    }

    @Override
    public void saveTriggerRouter(TriggerRouter triggerRouter, boolean updateTriggerRouterTableOnly) {
        if (!updateTriggerRouterTableOnly) {
            this.saveTrigger(triggerRouter.getTrigger());
            this.saveRouter(triggerRouter.getRouter());
        }
        triggerRouter.setLastUpdateTime(new Date());
        if (0 == this.jdbcTemplate.update(this.getSql("updateTriggerRouterSql"), new Object[]{triggerRouter.getInitialLoadOrder(), triggerRouter.getInitialLoadSelect(), triggerRouter.isPingBackEnabled() ? 1 : 0, triggerRouter.getLastUpdateBy(), triggerRouter.getLastUpdateTime(), triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()}, new int[]{4, 12, 5, 12, 93, 12, 12})) {
            triggerRouter.setCreateTime(triggerRouter.getLastUpdateTime());
            this.jdbcTemplate.update(this.getSql("insertTriggerRouterSql"), new Object[]{triggerRouter.getInitialLoadOrder(), triggerRouter.getInitialLoadSelect(), triggerRouter.isPingBackEnabled() ? 1 : 0, triggerRouter.getCreateTime(), triggerRouter.getLastUpdateBy(), triggerRouter.getLastUpdateTime(), triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()}, new int[]{4, 12, 5, 93, 12, 93, 12, 12});
        }
    }

    protected void resetTriggerRouterCacheByNodeGroupId() {
        this.triggerRouterCacheTime = 0L;
    }

    @Override
    public void saveRouter(Router router) {
        router.setLastUpdateTime(new Date());
        router.nullOutBlankFields();
        if (0 == this.jdbcTemplate.update(this.getSql("updateRouterSql"), new Object[]{router.getTargetCatalogName(), router.getTargetSchemaName(), router.getTargetTableName(), router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId(), router.getRouterType(), router.getRouterExpression(), router.isSyncOnUpdate() ? 1 : 0, router.isSyncOnInsert() ? 1 : 0, router.isSyncOnDelete() ? 1 : 0, router.getLastUpdateBy(), router.getLastUpdateTime(), router.getRouterId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 93, 12})) {
            router.setCreateTime(router.getLastUpdateTime());
            this.jdbcTemplate.update(this.getSql("insertRouterSql"), new Object[]{router.getTargetCatalogName(), router.getTargetSchemaName(), router.getTargetTableName(), router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId(), router.getRouterType(), router.getRouterExpression(), router.isSyncOnUpdate() ? 1 : 0, router.isSyncOnInsert() ? 1 : 0, router.isSyncOnDelete() ? 1 : 0, router.getCreateTime(), router.getLastUpdateBy(), router.getLastUpdateTime(), router.getRouterId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 93, 12, 93, 12});
        }
        this.resetTriggerRouterCacheByNodeGroupId();
    }

    @Override
    public boolean isRouterBeingUsed(String routerId) {
        return this.jdbcTemplate.queryForInt(this.getSql("countTriggerRoutersByRouterIdSql"), new Object[]{routerId}) > 0;
    }

    @Override
    public void deleteRouter(Router router) {
        if (router != null) {
            this.jdbcTemplate.update(this.getSql("deleteRouterSql"), new Object[]{router.getRouterId()});
        }
    }

    @Override
    public void saveTrigger(Trigger trigger) {
        trigger.setLastUpdateTime(new Date());
        trigger.nullOutBlankFields();
        if (0 == this.jdbcTemplate.update(this.getSql("updateTriggerSql"), new Object[]{trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), trigger.getChannelId(), trigger.isSyncOnUpdate() ? 1 : 0, trigger.isSyncOnInsert() ? 1 : 0, trigger.isSyncOnDelete() ? 1 : 0, trigger.isSyncOnIncomingBatch() ? 1 : 0, trigger.isUseStreamLobs() ? 1 : 0, trigger.isUseCaptureLobs() ? 1 : 0, trigger.getNameForUpdateTrigger(), trigger.getNameForInsertTrigger(), trigger.getNameForDeleteTrigger(), trigger.getSyncOnUpdateCondition(), trigger.getSyncOnInsertCondition(), trigger.getSyncOnDeleteCondition(), trigger.getTxIdExpression(), trigger.getExcludedColumnNames(), trigger.getLastUpdateBy(), trigger.getLastUpdateTime(), trigger.getExternalSelect(), trigger.getTriggerId()}, new int[]{12, 12, 12, 12, 5, 5, 5, 5, 5, 5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 93, 12, 12})) {
            trigger.setCreateTime(trigger.getLastUpdateTime());
            this.jdbcTemplate.update(this.getSql("insertTriggerSql"), new Object[]{trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), trigger.getChannelId(), trigger.isSyncOnUpdate() ? 1 : 0, trigger.isSyncOnInsert() ? 1 : 0, trigger.isSyncOnDelete() ? 1 : 0, trigger.isSyncOnIncomingBatch() ? 1 : 0, trigger.isUseStreamLobs() ? 1 : 0, trigger.isUseCaptureLobs() ? 1 : 0, trigger.getNameForUpdateTrigger(), trigger.getNameForInsertTrigger(), trigger.getNameForDeleteTrigger(), trigger.getSyncOnUpdateCondition(), trigger.getSyncOnInsertCondition(), trigger.getSyncOnDeleteCondition(), trigger.getTxIdExpression(), trigger.getExcludedColumnNames(), trigger.getCreateTime(), trigger.getLastUpdateBy(), trigger.getLastUpdateTime(), trigger.getExternalSelect(), trigger.getTriggerId()}, new int[]{12, 12, 12, 12, 5, 5, 5, 5, 5, 5, 12, 12, 12, 12, 12, 12, 12, 12, 93, 12, 93, 12, 12});
        }
    }

    @Override
    public void syncTriggers() {
        this.syncTriggers(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncTriggers(StringBuilder sqlBuffer, boolean gen_always) {
        if (this.clusterService.lock("SYNCTRIGGERS")) {
            TriggerRouterService triggerRouterService = this;
            synchronized (triggerRouterService) {
                try {
                    this.log.info("TriggersSynchronizing");
                    this.configurationService.reloadChannels();
                    List<Trigger> triggersForCurrentNode = this.getTriggersForCurrentNode();
                    this.inactivateTriggers(triggersForCurrentNode, sqlBuffer);
                    this.updateOrCreateDatabaseTriggers(triggersForCurrentNode, sqlBuffer, gen_always);
                    this.resetTriggerRouterCacheByNodeGroupId();
                    Object var6_5 = null;
                    this.clusterService.unlock("SYNCTRIGGERS");
                    this.log.info("TriggersSynchronized");
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.clusterService.unlock("SYNCTRIGGERS");
                    this.log.info("TriggersSynchronized");
                    throw throwable;
                }
            }
        }
        this.log.info("TriggersSynchronizingFailedLock");
    }

    protected Set<String> getTriggerIdsFrom(List<Trigger> triggersThatShouldBeActive) {
        HashSet<String> triggerIds = new HashSet<String>(triggersThatShouldBeActive.size());
        for (Trigger trigger : triggersThatShouldBeActive) {
            triggerIds.add(trigger.getTriggerId());
        }
        return triggerIds;
    }

    protected void inactivateTriggers(List<Trigger> triggersThatShouldBeActive, StringBuilder sqlBuffer) {
        List<TriggerHistory> activeHistories = this.getActiveTriggerHistories();
        Set<String> triggerIdsThatShouldBeActive = this.getTriggerIdsFrom(triggersThatShouldBeActive);
        for (TriggerHistory history : activeHistories) {
            if (triggerIdsThatShouldBeActive.contains(history.getTriggerId())) continue;
            this.log.info("TriggersRemoving", history.getSourceTableName());
            this.dbDialect.removeTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForInsertTrigger(), history.getSourceTableName(), history);
            this.dbDialect.removeTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForDeleteTrigger(), history.getSourceTableName(), history);
            this.dbDialect.removeTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForUpdateTrigger(), history.getSourceTableName(), history);
            if (this.parameterService.is("auto.sync.triggers") && this.triggerCreationListeners != null) {
                for (ITriggerCreationListener l : this.triggerCreationListeners) {
                    l.triggerInactivated(null, history);
                }
            }
            boolean triggerExists = this.dbDialect.doesTriggerExist(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForInsertTrigger());
            triggerExists |= this.dbDialect.doesTriggerExist(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForUpdateTrigger());
            if (triggerExists |= this.dbDialect.doesTriggerExist(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForDeleteTrigger())) {
                this.log.warn("TriggersRemovingFailed", history.getTriggerId(), history.getTriggerHistoryId());
                continue;
            }
            this.inactivateTriggerHistory(history);
        }
    }

    protected List<TriggerRouter> toList(Collection<List<TriggerRouter>> source) {
        ArrayList<TriggerRouter> list = new ArrayList<TriggerRouter>();
        for (List<TriggerRouter> triggerRouters : source) {
            for (TriggerRouter triggerRouter : triggerRouters) {
                list.add(triggerRouter);
            }
        }
        return list;
    }

    protected List<Trigger> getTriggersForCurrentNode() {
        return new TriggerSelector(this.toList(this.getTriggerRoutersForCurrentNode(true).values())).select();
    }

    protected void updateOrCreateDatabaseTriggers(List<Trigger> triggers, StringBuilder sqlBuffer, boolean gen_always) {
        for (Trigger trigger : triggers) {
            TriggerHistory newestHistory = null;
            try {
                TriggerReBuildReason reason = TriggerReBuildReason.NEW_TRIGGERS;
                Table table = this.dbDialect.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false);
                String errorMessage = null;
                Channel channel = this.configurationService.getChannel(trigger.getChannelId());
                if (channel == null) {
                    errorMessage = Message.get("TriggerFoundWithInvalidChannelId", trigger.getTriggerId(), trigger.getChannelId(), "default");
                    this.log.error("TriggerFoundWithInvalidChannelId", trigger.getTriggerId(), trigger.getChannelId(), "default");
                    trigger.setChannelId("default");
                }
                if (table != null) {
                    TriggerHistory latestHistoryBeforeRebuild = this.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
                    boolean forceRebuildOfTriggers = false;
                    if (latestHistoryBeforeRebuild == null) {
                        reason = TriggerReBuildReason.NEW_TRIGGERS;
                        forceRebuildOfTriggers = true;
                    } else if (TriggerHistory.calculateTableHashFor(table) != latestHistoryBeforeRebuild.getTableHash()) {
                        reason = TriggerReBuildReason.TABLE_SCHEMA_CHANGED;
                        forceRebuildOfTriggers = true;
                    } else if (trigger.hasChangedSinceLastTriggerBuild(latestHistoryBeforeRebuild.getCreateTime()) || trigger.toHashedValue() != latestHistoryBeforeRebuild.getTriggerRowHash()) {
                        reason = TriggerReBuildReason.TABLE_SYNC_CONFIGURATION_CHANGED;
                        forceRebuildOfTriggers = true;
                    } else if (gen_always) {
                        reason = TriggerReBuildReason.FORCED;
                        forceRebuildOfTriggers = true;
                    }
                    boolean supportsTriggers = this.dbDialect.getPlatform().getPlatformInfo().isTriggersSupported();
                    newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.INSERT, reason, latestHistoryBeforeRebuild, null, trigger.isSyncOnInsert() && supportsTriggers, table);
                    newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.UPDATE, reason, latestHistoryBeforeRebuild, newestHistory, trigger.isSyncOnUpdate() && supportsTriggers, table);
                    newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.DELETE, reason, latestHistoryBeforeRebuild, newestHistory, trigger.isSyncOnDelete() && supportsTriggers, table);
                    if (latestHistoryBeforeRebuild != null && newestHistory != null) {
                        this.inactivateTriggerHistory(latestHistoryBeforeRebuild);
                    }
                    if (newestHistory == null) continue;
                    newestHistory.setErrorMessage(errorMessage);
                    if (!this.parameterService.is("auto.sync.triggers") || this.triggerCreationListeners == null) continue;
                    for (ITriggerCreationListener l : this.triggerCreationListeners) {
                        l.triggerCreated(trigger, newestHistory);
                    }
                    continue;
                }
                this.log.error("TriggerTableMissing", trigger.qualifiedSourceTableName());
                if (this.triggerCreationListeners == null) continue;
                for (ITriggerCreationListener l : this.triggerCreationListeners) {
                    l.tableDoesNotExist(trigger);
                }
            }
            catch (Exception ex) {
                this.log.error("TriggerSynchronizingFailed", ex, trigger.qualifiedSourceTableName());
                if (newestHistory != null) {
                    this.dbDialect.removeTrigger(null, trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), newestHistory.getNameForInsertTrigger(), trigger.getSourceTableName(), newestHistory);
                    this.dbDialect.removeTrigger(null, trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), newestHistory.getNameForUpdateTrigger(), trigger.getSourceTableName(), newestHistory);
                    this.dbDialect.removeTrigger(null, trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), newestHistory.getNameForDeleteTrigger(), trigger.getSourceTableName(), newestHistory);
                }
                if (this.triggerCreationListeners == null) continue;
                for (ITriggerCreationListener l : this.triggerCreationListeners) {
                    l.triggerFailed(trigger, ex);
                }
            }
        }
    }

    protected TriggerHistory rebuildTriggerIfNecessary(StringBuilder sqlBuffer, boolean forceRebuild, Trigger trigger, DataEventType dmlType, TriggerReBuildReason reason, TriggerHistory oldhist, TriggerHistory hist, boolean triggerIsActive, Table table) {
        boolean isDeadTrigger;
        boolean triggerExists = false;
        boolean triggerRemoved = false;
        TriggerHistory newTriggerHist = new TriggerHistory(table, trigger, reason);
        int maxTriggerNameLength = this.dbDialect.getMaxTriggerNameLength();
        newTriggerHist.setNameForInsertTrigger(this.getTriggerName(DataEventType.INSERT, maxTriggerNameLength, trigger).toUpperCase());
        newTriggerHist.setNameForUpdateTrigger(this.getTriggerName(DataEventType.UPDATE, maxTriggerNameLength, trigger).toUpperCase());
        newTriggerHist.setNameForDeleteTrigger(this.getTriggerName(DataEventType.DELETE, maxTriggerNameLength, trigger).toUpperCase());
        String oldTriggerName = null;
        String oldSourceSchema = null;
        String oldCatalogName = null;
        if (oldhist != null) {
            oldTriggerName = oldhist.getTriggerNameForDmlType(dmlType);
            oldSourceSchema = oldhist.getSourceSchemaName();
            oldCatalogName = oldhist.getSourceCatalogName();
            triggerExists = this.dbDialect.doesTriggerExist(oldCatalogName, oldSourceSchema, oldhist.getSourceTableName(), oldTriggerName);
        } else {
            oldTriggerName = newTriggerHist.getTriggerNameForDmlType(dmlType);
            oldSourceSchema = trigger.getSourceSchemaName();
            oldCatalogName = trigger.getSourceCatalogName();
            triggerExists = this.dbDialect.doesTriggerExist(oldCatalogName, oldSourceSchema, trigger.getSourceTableName(), oldTriggerName);
        }
        if (!triggerExists && forceRebuild) {
            reason = TriggerReBuildReason.TRIGGERS_MISSING;
        }
        if ((forceRebuild || !triggerIsActive) && triggerExists) {
            this.dbDialect.removeTrigger(sqlBuffer, oldCatalogName, oldSourceSchema, oldTriggerName, trigger.getSourceTableName(), oldhist);
            triggerExists = false;
            triggerRemoved = true;
        }
        boolean bl = isDeadTrigger = !trigger.isSyncOnInsert() && !trigger.isSyncOnUpdate() && !trigger.isSyncOnDelete();
        if (hist == null && (oldhist == null || !triggerExists && triggerIsActive || isDeadTrigger && forceRebuild)) {
            this.insert(newTriggerHist);
            hist = this.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
        }
        try {
            if (!triggerExists && triggerIsActive) {
                this.dbDialect.createTrigger(sqlBuffer, dmlType, trigger, hist, this.configurationService.getChannel(trigger.getChannelId()), this.tablePrefix, table);
                if (triggerRemoved) {
                    this.statisticManager.incrementTriggersRebuiltCount(1L);
                } else {
                    this.statisticManager.incrementTriggersCreatedCount(1L);
                }
            } else if (triggerRemoved) {
                this.statisticManager.incrementTriggersRemovedCount(1L);
            }
        }
        catch (RuntimeException ex) {
            if (!this.dbDialect.doesTriggerExist(hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), hist.getTriggerNameForDmlType(dmlType))) {
                this.log.warn("TriggerHistCleanup", hist.getTriggerHistoryId());
                hist.setErrorMessage(ex.getMessage());
                this.inactivateTriggerHistory(hist);
            }
            throw ex;
        }
        return hist;
    }

    protected String replaceCharsForTriggerName(String triggerName) {
        return triggerName.replaceAll("[^a-zA-Z0-9_]|[a|e|i|o|u|A|E|I|O|U]", "");
    }

    protected String getTriggerName(DataEventType dml, int maxTriggerNameLength, Trigger trigger) {
        String triggerName = null;
        switch (dml) {
            case INSERT: {
                if (StringUtils.isBlank((String)trigger.getNameForInsertTrigger())) break;
                triggerName = trigger.getNameForInsertTrigger();
                break;
            }
            case UPDATE: {
                if (StringUtils.isBlank((String)trigger.getNameForUpdateTrigger())) break;
                triggerName = trigger.getNameForUpdateTrigger();
                break;
            }
            case DELETE: {
                if (StringUtils.isBlank((String)trigger.getNameForDeleteTrigger())) break;
                triggerName = trigger.getNameForDeleteTrigger();
            }
        }
        if (StringUtils.isBlank(triggerName)) {
            String triggerPrefix1 = this.tablePrefix + "_";
            String triggerSuffix1 = "on_" + dml.getCode().toLowerCase() + "_for_";
            String triggerSuffix2 = this.replaceCharsForTriggerName(trigger.getTriggerId());
            String triggerSuffix3 = this.replaceCharsForTriggerName("_" + this.parameterService.getNodeGroupId());
            triggerName = triggerPrefix1 + triggerSuffix1 + triggerSuffix2 + triggerSuffix3;
            if (triggerName.length() > maxTriggerNameLength && maxTriggerNameLength > 0) {
                triggerName = triggerPrefix1 + triggerSuffix1 + triggerSuffix2;
            }
        }
        if ((triggerName = triggerName.toUpperCase()).length() > maxTriggerNameLength && maxTriggerNameLength > 0) {
            triggerName = triggerName.substring(0, maxTriggerNameLength - 1);
            this.log.debug("TriggerNameTruncated", dml.name().toLowerCase(), trigger.getTriggerId(), maxTriggerNameLength);
        }
        int duplicateCount = 0;
        while (this.isTriggerNameInUse(trigger.getTriggerId(), triggerName)) {
            String duplicateSuffix = Integer.toString(++duplicateCount);
            if (triggerName.length() + duplicateSuffix.length() > maxTriggerNameLength) {
                triggerName = triggerName.substring(0, triggerName.length() - duplicateSuffix.length()) + duplicateSuffix;
                continue;
            }
            triggerName = triggerName + duplicateSuffix;
        }
        return triggerName;
    }

    public void setRootConfigChannelTableNames(Map<String, List<String>> configChannelTableNames) {
        this.rootConfigChannelTableNames = configChannelTableNames;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setTriggerCreationListeners(List<ITriggerCreationListener> autoTriggerCreationListeners) {
        if (this.triggerCreationListeners != null) {
            for (ITriggerCreationListener l : this.triggerCreationListeners) {
                this.addTriggerCreationListeners(l);
            }
        }
    }

    @Override
    public void addTriggerCreationListeners(ITriggerCreationListener l) {
        if (this.triggerCreationListeners == null) {
            this.triggerCreationListeners = new ArrayList<ITriggerCreationListener>();
        }
        this.triggerCreationListeners.add(l);
    }

    @Override
    public void addExtraConfigTables(IExtraConfigTables extension) {
        this.extraConfigTables.add(extension);
    }

    @Override
    public Map<Trigger, Exception> getFailedTriggers() {
        return this.failureListener.getFailures();
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TriggerRoutersCache {
        Map<String, List<TriggerRouter>> triggerRoutersByTriggerId = new HashMap<String, List<TriggerRouter>>();
        Map<String, Router> routersByRouterId = new HashMap<String, Router>();

        public TriggerRoutersCache(Map<String, List<TriggerRouter>> triggerRoutersByTriggerId, Map<String, Router> routersByRouterId) {
            this.triggerRoutersByTriggerId = triggerRoutersByTriggerId;
            this.routersByRouterId = routersByRouterId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TriggerRouterMapper
    implements RowMapper<TriggerRouter> {
        private TriggerMapper triggerMapper;
        private RouterMapper routerMapper;

        TriggerRouterMapper() {
            this.triggerMapper = new TriggerMapper();
            this.routerMapper = new RouterMapper();
        }

        public TriggerRouter mapRow(ResultSet rs, int rowNum) throws SQLException {
            TriggerRouter triggerRouter = new TriggerRouter();
            triggerRouter.setTrigger(this.triggerMapper.mapRow(rs, rowNum));
            triggerRouter.setRouter(this.routerMapper.mapRow(rs, rowNum));
            triggerRouter.setCreateTime(rs.getTimestamp("create_time"));
            triggerRouter.setLastUpdateTime(rs.getTimestamp("last_update_time"));
            triggerRouter.setLastUpdateBy(rs.getString("last_update_by"));
            triggerRouter.setInitialLoadOrder(rs.getInt("initial_load_order"));
            triggerRouter.setInitialLoadSelect(rs.getString("initial_load_select"));
            triggerRouter.setPingBackEnabled(rs.getBoolean("ping_back_enabled"));
            return triggerRouter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TriggerMapper
    implements RowMapper<Trigger> {
        TriggerMapper() {
        }

        public Trigger mapRow(ResultSet rs, int rowNum) throws SQLException {
            Trigger trigger = new Trigger();
            trigger.setTriggerId(rs.getString("trigger_id"));
            trigger.setChannelId(rs.getString("channel_id"));
            trigger.setSourceTableName(rs.getString("source_table_name"));
            trigger.setSyncOnInsert(rs.getBoolean("sync_on_insert"));
            trigger.setSyncOnUpdate(rs.getBoolean("sync_on_update"));
            trigger.setSyncOnDelete(rs.getBoolean("sync_on_delete"));
            trigger.setSyncOnIncomingBatch(rs.getBoolean("sync_on_incoming_batch"));
            trigger.setUseStreamLobs(rs.getBoolean("use_stream_lobs"));
            trigger.setUseCaptureLobs(rs.getBoolean("use_capture_lobs"));
            trigger.setNameForDeleteTrigger(rs.getString("name_for_delete_trigger"));
            trigger.setNameForInsertTrigger(rs.getString("name_for_insert_trigger"));
            trigger.setNameForUpdateTrigger(rs.getString("name_for_update_trigger"));
            String schema = rs.getString("source_schema_name");
            trigger.setSourceSchemaName(schema);
            String catalog = rs.getString("source_catalog_name");
            trigger.setSourceCatalogName(catalog);
            String condition = rs.getString("sync_on_insert_condition");
            if (!StringUtils.isBlank((String)condition)) {
                trigger.setSyncOnInsertCondition(condition);
            }
            if (!StringUtils.isBlank((String)(condition = rs.getString("sync_on_update_condition")))) {
                trigger.setSyncOnUpdateCondition(condition);
            }
            if (!StringUtils.isBlank((String)(condition = rs.getString("sync_on_delete_condition")))) {
                trigger.setSyncOnDeleteCondition(condition);
            }
            if (!StringUtils.isBlank((String)(condition = rs.getString("external_select")))) {
                trigger.setExternalSelect(condition);
            }
            trigger.setTxIdExpression(rs.getString("tx_id_expression"));
            trigger.setCreateTime(rs.getTimestamp("t_create_time"));
            trigger.setLastUpdateTime(rs.getTimestamp("t_last_update_time"));
            trigger.setLastUpdateBy(rs.getString("t_last_update_by"));
            trigger.setExcludedColumnNames(rs.getString("excluded_column_names"));
            return trigger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RouterMapper
    implements RowMapper<Router> {
        RouterMapper() {
        }

        public Router mapRow(ResultSet rs, int rowNum) throws SQLException {
            Router router = new Router();
            router.setSyncOnInsert(rs.getBoolean("r_sync_on_insert"));
            router.setSyncOnUpdate(rs.getBoolean("r_sync_on_update"));
            router.setSyncOnDelete(rs.getBoolean("r_sync_on_delete"));
            router.setTargetCatalogName(rs.getString("target_catalog_name"));
            router.setNodeGroupLink(TriggerRouterService.this.configurationService.getNodeGroupLinkFor(rs.getString("source_node_group_id"), rs.getString("target_node_group_id")));
            router.setTargetSchemaName(rs.getString("target_schema_name"));
            router.setTargetTableName(rs.getString("target_table_name"));
            String condition = rs.getString("router_expression");
            if (!StringUtils.isBlank((String)condition)) {
                router.setRouterExpression(condition);
            }
            router.setRouterType(rs.getString("router_type"));
            router.setRouterId(rs.getString("router_id"));
            router.setCreateTime(rs.getTimestamp("r_create_time"));
            router.setLastUpdateTime(rs.getTimestamp("r_last_update_time"));
            router.setLastUpdateBy(rs.getString("r_last_update_by"));
            return router;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TriggerHistoryMapper
    implements RowMapper<TriggerHistory> {
        Map<Long, TriggerHistory> retMap = null;

        TriggerHistoryMapper() {
        }

        TriggerHistoryMapper(Map<Long, TriggerHistory> map) {
            this.retMap = map;
        }

        public TriggerHistory mapRow(ResultSet rs, int i) throws SQLException {
            TriggerHistory hist = new TriggerHistory();
            hist.setTriggerHistoryId(rs.getInt(1));
            hist.setTriggerId(rs.getString(2));
            hist.setSourceTableName(rs.getString(3));
            hist.setTableHash(rs.getInt(4));
            hist.setCreateTime(rs.getTimestamp(5));
            hist.setPkColumnNames(rs.getString(6));
            hist.setColumnNames(rs.getString(7));
            hist.setLastTriggerBuildReason(TriggerReBuildReason.fromCode(rs.getString(8)));
            hist.setNameForDeleteTrigger(rs.getString(9));
            hist.setNameForInsertTrigger(rs.getString(10));
            hist.setNameForUpdateTrigger(rs.getString(11));
            hist.setSourceSchemaName(rs.getString(12));
            hist.setSourceCatalogName(rs.getString(13));
            hist.setTriggerRowHash(rs.getLong(14));
            hist.setErrorMessage(rs.getString(15));
            if (this.retMap != null) {
                this.retMap.put(Long.valueOf(hist.getTriggerHistoryId()), hist);
            }
            return hist;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeGroupLinkMapper
    implements RowMapper<NodeGroupLink> {
        NodeGroupLinkMapper() {
        }

        public NodeGroupLink mapRow(ResultSet rs, int num) throws SQLException {
            NodeGroupLink node_groupTarget = new NodeGroupLink();
            node_groupTarget.setSourceNodeGroupId(rs.getString(1));
            node_groupTarget.setTargetNodeGroupId(rs.getString(2));
            node_groupTarget.setDataEventAction(NodeGroupLinkAction.fromCode(rs.getString(3)));
            return node_groupTarget;
        }
    }
}

