/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.INotificationService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.statistic.ChannelStats;
import org.jumpmind.symmetric.statistic.HostStats;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.statistic.JobStats;
import org.jumpmind.symmetric.util.AppUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticManager
implements IStatisticManager {
    private static final String UNKNOWN = "Unknown";
    static final ILog log = LogFactory.getLog(StatisticManager.class);
    private Map<String, ChannelStats> channelStats = new HashMap<String, ChannelStats>();
    private List<JobStats> jobStats = new ArrayList<JobStats>();
    private HostStats hostStats;
    protected INodeService nodeService;
    protected IStatisticService statisticService;
    protected INotificationService notificationService;
    protected IParameterService parameterService;
    protected IConfigurationService configurationService;
    private static final int NUMBER_OF_PERMITS = 1000;
    Semaphore channelStatsLock = new Semaphore(1000, true);
    Semaphore hostStatsLock = new Semaphore(1000, true);
    Semaphore jobStatsLock = new Semaphore(1000, true);

    protected void init() {
        this.incrementRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobStats(String jobName, long startTime, long endTime, long processedCount) {
        this.jobStatsLock.acquireUninterruptibly();
        try {
            JobStats stats = new JobStats(jobName, startTime, endTime, processedCount);
            this.jobStats.add(stats);
            Object var10_6 = null;
            this.jobStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.jobStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataRouted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataRouted(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataUnRouted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).setDataUnRouted(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataExtracted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataExtracted(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataBytesExtracted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataBytesExtracted(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataExtractedErrors(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataExtractedErrors(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataEventInserted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataEventInserted(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataSent(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataSent(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataBytesSent(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataBytesSent(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataSentErrors(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataSentErrors(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataLoaded(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataLoaded(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataBytesLoaded(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataBytesLoaded(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataLoadedErrors(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataLoadedErrors(count);
            Object var5_3 = null;
            this.channelStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.channelStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementRestart() {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementRestarted(1L);
            Object var2_1 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNodesPulled(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesPulled(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNodesPushed(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesPushed(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementTotalNodesPulledTime(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTotalNodesPullTime(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementTotalNodesPushedTime(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTotalNodesPushTime(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNodesRejected(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesRejected(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNodesRegistered(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesRegistered(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNodesLoaded(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesLoaded(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNodesDisabled(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesDisabled(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementPurgedBatchIncomingRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedBatchIncomingRows(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementPurgedBatchOutgoingRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedBatchOutgoingRows(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementPurgedDataRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedDataRows(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementPurgedDataEventRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedDataEventRows(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementTriggersRemovedCount(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTriggersRemovedCount(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementTriggersRebuiltCount(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTriggersRebuiltCount(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementTriggersCreatedCount(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTriggersCreatedCount(count);
            Object var4_2 = null;
            this.hostStatsLock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.hostStatsLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean recordStatistics = this.parameterService.is("statistic.record.enable", false);
        if (this.channelStats != null) {
            this.channelStatsLock.acquireUninterruptibly(1000);
            try {
                if (recordStatistics) {
                    Date endTime = new Date();
                    for (ChannelStats stats : this.channelStats.values()) {
                        Node node;
                        if (stats.getNodeId().equals(UNKNOWN) && (node = this.nodeService.getCachedIdentity()) != null) {
                            stats.setNodeId(node.getNodeId());
                        }
                        stats.setEndTime(endTime);
                        this.statisticService.save(stats);
                    }
                }
                this.resetChannelStats(true);
                Object var7_6 = null;
                this.channelStatsLock.release(1000);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.channelStatsLock.release(1000);
                throw throwable;
            }
        }
        if (this.hostStats != null) {
            this.hostStatsLock.acquireUninterruptibly(1000);
            try {
                if (recordStatistics) {
                    Node node;
                    if (this.hostStats.getNodeId().equals(UNKNOWN) && (node = this.nodeService.getCachedIdentity()) != null) {
                        this.hostStats.setNodeId(node.getNodeId());
                    }
                    this.hostStats.setEndTime(new Date());
                    this.statisticService.save(this.hostStats);
                }
                this.hostStats = null;
                Object var9_10 = null;
                this.hostStatsLock.release(1000);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.hostStatsLock.release(1000);
                throw throwable;
            }
        }
        if (this.jobStats != null) {
            Node node;
            List<JobStats> toFlush = null;
            this.jobStatsLock.acquireUninterruptibly(1000);
            try {
                toFlush = this.jobStats;
                this.jobStats = new ArrayList<JobStats>();
                Object var11_13 = null;
                this.jobStatsLock.release(1000);
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.jobStatsLock.release(1000);
                throw throwable;
            }
            if (toFlush != null && recordStatistics && (node = this.nodeService.getCachedIdentity()) != null) {
                String nodeId = node.getNodeId();
                String serverId = AppUtils.getServerId();
                for (JobStats stats : toFlush) {
                    stats.setNodeId(nodeId);
                    stats.setHostName(serverId);
                    this.statisticService.save(stats);
                }
            }
        }
    }

    @Override
    public Map<String, ChannelStats> getWorkingChannelStats() {
        if (this.channelStats != null) {
            return new HashMap<String, ChannelStats>(this.channelStats);
        }
        return new HashMap<String, ChannelStats>();
    }

    @Override
    public HostStats getWorkingHostStats() {
        if (this.hostStats != null) {
            return new HostStats(this.hostStats);
        }
        return new HostStats();
    }

    protected void resetChannelStats(boolean force) {
        if (force) {
            this.channelStats = null;
        }
        if (this.channelStats == null) {
            List<NodeChannel> channels = this.configurationService.getNodeChannels(false);
            this.channelStats = new HashMap<String, ChannelStats>(channels.size());
            for (NodeChannel nodeChannel : channels) {
                this.getChannelStats(nodeChannel.getChannelId());
            }
        }
    }

    protected ChannelStats getChannelStats(String channelId) {
        this.resetChannelStats(false);
        ChannelStats stats = this.channelStats.get(channelId);
        if (stats == null) {
            Node node = this.nodeService.getCachedIdentity();
            if (node != null) {
                stats = new ChannelStats(node.getNodeId(), AppUtils.getServerId(), new Date(), null, channelId);
                this.channelStats.put(channelId, stats);
            } else {
                stats = new ChannelStats(UNKNOWN, AppUtils.getServerId(), new Date(), null, channelId);
            }
        }
        return stats;
    }

    protected HostStats getHostStats() {
        if (this.hostStats == null) {
            Node node = this.nodeService.getCachedIdentity();
            this.hostStats = node != null ? new HostStats(node.getNodeId(), AppUtils.getServerId(), new Date(), null) : new HostStats(UNKNOWN, AppUtils.getServerId(), new Date(), null);
        }
        return this.hostStats;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStatisticService(IStatisticService statisticService) {
        this.statisticService = statisticService;
    }

    public void setNotificationService(INotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

