/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transform.DeleteAction;
import org.jumpmind.symmetric.transform.IColumnTransform;
import org.jumpmind.symmetric.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.transform.ITransformService;
import org.jumpmind.symmetric.transform.IgnoreColumnException;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformPoint;
import org.jumpmind.symmetric.transform.TransformTable;
import org.jumpmind.symmetric.transform.TransformedData;
import org.jumpmind.symmetric.util.AppUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformer {
    protected final ILog log = LogFactory.getLog(this.getClass());
    protected ITransformService transformService;
    protected IDbDialect dbDialect;
    protected IParameterService parameterService;
    protected String tablePrefix;

    protected boolean isEligibleForTransform(String catalogName, String schemaName, String tableName) {
        return !tableName.toLowerCase().startsWith(this.tablePrefix);
    }

    protected List<TransformedData> transform(StatementBuilder.DmlType dmlType, ICacheContext context, NodeGroupLink nodeGroupLink, String catalogName, String schemaName, String tableName, String[] columnNames, String[] columnValues, String[] keyNames, String[] keyValues, String[] oldData) {
        String fullyQualifiedName;
        List<TransformTable> transformationsToPerform;
        if (this.isEligibleForTransform(catalogName, schemaName, tableName) && (transformationsToPerform = this.findTablesToTransform(nodeGroupLink, fullyQualifiedName = this.getFullyQualifiedTableName(catalogName, schemaName, tableName))) != null && transformationsToPerform.size() > 0) {
            Map<String, String> sourceKeyValues;
            Map<String, String> sourceValues = AppUtils.toMap(columnNames, columnValues);
            Map<String, String> oldSourceValues = AppUtils.toMap(columnNames, oldData);
            Map<String, String> map = sourceKeyValues = oldSourceValues.size() > 0 ? oldSourceValues : sourceValues;
            if (keyNames != null && oldSourceValues.size() == 0) {
                sourceKeyValues = AppUtils.toMap(keyNames, keyValues);
            }
            if (dmlType == StatementBuilder.DmlType.DELETE) {
                sourceValues = oldSourceValues;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("TransformStarted", transformationsToPerform.size(), dmlType.toString(), fullyQualifiedName, sourceValues);
            }
            ArrayList<TransformedData> dataThatHasBeenTransformed = new ArrayList<TransformedData>();
            for (TransformTable transformation : transformationsToPerform) {
                dataThatHasBeenTransformed.addAll(this.transform(dmlType, context, transformation, sourceKeyValues, oldSourceValues, sourceValues));
            }
            return dataThatHasBeenTransformed;
        }
        return null;
    }

    protected List<TransformedData> transform(StatementBuilder.DmlType dmlType, ICacheContext context, TransformTable transformation, Map<String, String> sourceKeyValues, Map<String, String> oldSourceValues, Map<String, String> sourceValues) {
        try {
            List<TransformedData> dataToTransform = this.create(context, dmlType, transformation, sourceKeyValues, oldSourceValues, sourceValues);
            ArrayList<TransformedData> dataThatHasBeenTransformed = new ArrayList<TransformedData>(dataToTransform.size());
            if (this.log.isDebugEnabled()) {
                this.log.debug("TransformDataCreated", dataToTransform.size(), transformation.getTransformId(), transformation.getFullyQualifiedTargetTableName());
            }
            int transformNumber = 0;
            for (TransformedData targetData : dataToTransform) {
                ++transformNumber;
                if (this.perform(context, targetData, transformation, sourceValues, oldSourceValues)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("TransformedDataReadyForApplication", targetData.getTargetDmlType().toString(), transformNumber, ArrayUtils.toString((Object)targetData.getColumnNames()), ArrayUtils.toString((Object)targetData.getColumnValues()));
                    }
                    dataThatHasBeenTransformed.add(targetData);
                    continue;
                }
                this.log.debug("TransformNotPerformed", transformNumber);
            }
            return dataThatHasBeenTransformed;
        }
        catch (IgnoreRowException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("TransformRowIgnored", "transformation aborted during tranformation of key");
            }
            return new ArrayList<TransformedData>(0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean perform(ICacheContext context, TransformedData data, TransformTable transformation, Map<String, String> sourceValues, Map<String, String> oldSourceValues) throws IgnoreRowException {
        boolean persistData = false;
        try {
            for (TransformColumn transformColumn : transformation.getTransformColumns()) {
                if (transformColumn.getSourceColumnName() == null || sourceValues.containsKey(transformColumn.getSourceColumnName())) {
                    IColumnTransform<?> transform = this.transformService.getColumnTransforms().get(transformColumn.getTransformType());
                    if (transform != null && !(transform instanceof ISingleValueColumnTransform)) continue;
                    try {
                        String value = (String)this.transformColumn(context, data, transformColumn, sourceValues, oldSourceValues);
                        data.put(transformColumn, value, false);
                    }
                    catch (IgnoreColumnException e) {}
                    continue;
                }
                this.log.warn("TransformSourceColumnNotFound", transformColumn.getSourceColumnName(), transformation.getTransformId());
            }
            if (data.getTargetDmlType() != StatementBuilder.DmlType.DELETE) {
                if (data.getTargetDmlType() != StatementBuilder.DmlType.INSERT) return true;
                if (!transformation.isUpdateFirst()) return true;
                data.setTargetDmlType(StatementBuilder.DmlType.UPDATE);
                return true;
            }
            DeleteAction deleteAction = transformation.getDeleteAction();
            switch (deleteAction) {
                case DEL_ROW: {
                    data.setTargetDmlType(StatementBuilder.DmlType.DELETE);
                    return true;
                }
                case UPDATE_COL: {
                    data.setTargetDmlType(StatementBuilder.DmlType.UPDATE);
                    return true;
                }
                default: {
                    if (!this.log.isDebugEnabled()) return persistData;
                    this.log.debug("TransformNoActionNotConfiguredToDelete", transformation.getTransformId());
                }
            }
            return persistData;
        }
        catch (IgnoreRowException ex) {
            if (!this.log.isDebugEnabled()) return persistData;
            this.log.debug("TransformRowIgnored", ArrayUtils.toString((Object)data.getKeyValues()));
        }
        return persistData;
    }

    protected List<TransformedData> create(ICacheContext context, StatementBuilder.DmlType dmlType, TransformTable transformation, Map<String, String> sourceKeyValues, Map<String, String> oldSourceValues, Map<String, String> sourceValues) throws IgnoreRowException {
        ArrayList<TransformedData> datas = new ArrayList<TransformedData>();
        datas.add(new TransformedData(transformation, dmlType, sourceKeyValues, oldSourceValues, sourceValues));
        List<TransformColumn> columns = transformation.getPrimaryKeyColumns();
        if (columns == null || columns.size() == 0) {
            this.log.error("TransformNoPrimaryKeyDefined", transformation.getTransformId());
        } else {
            for (TransformColumn transformColumn : columns) {
                ArrayList<TransformedData> newDatas = null;
                for (TransformedData data : datas) {
                    try {
                        Object columnValue = this.transformColumn(context, data, transformColumn, sourceKeyValues, oldSourceValues);
                        if (columnValue instanceof String) {
                            data.put(transformColumn, (String)columnValue, true);
                            continue;
                        }
                        if (!(columnValue instanceof List)) continue;
                        List values = (List)columnValue;
                        if (values.size() > 0) {
                            data.put(transformColumn, (String)values.get(0), true);
                            if (values.size() <= 1) continue;
                            if (newDatas == null) {
                                newDatas = new ArrayList<TransformedData>(values.size() - 1);
                            }
                            for (int i = 1; i < values.size(); ++i) {
                                TransformedData newData = data.copy();
                                newData.put(transformColumn, (String)values.get(i), true);
                                newDatas.add(newData);
                            }
                            continue;
                        }
                        throw new IgnoreRowException();
                    }
                    catch (IgnoreColumnException e) {
                    }
                }
                if (newDatas == null) continue;
                datas.addAll(newDatas);
                newDatas = null;
            }
        }
        return datas;
    }

    protected Object transformColumn(ICacheContext context, TransformedData data, TransformColumn transformColumn, Map<String, String> sourceValues, Map<String, String> oldSourceValues) throws IgnoreRowException, IgnoreColumnException {
        String value;
        String returnValue = null;
        returnValue = value = transformColumn.getSourceColumnName() != null ? sourceValues.get(transformColumn.getSourceColumnName()) : null;
        IColumnTransform<?> transform = this.transformService.getColumnTransforms().get(transformColumn.getTransformType());
        if (transform != null) {
            String oldValue = oldSourceValues.get(transformColumn.getSourceColumnName());
            returnValue = transform.transform(context, transformColumn, data, sourceValues, value, oldValue);
        }
        return returnValue;
    }

    protected String getFullyQualifiedTableName(String catalogName, String schemaName, String tableName) {
        if (!StringUtils.isBlank((String)schemaName)) {
            tableName = schemaName + "." + tableName;
        }
        if (!StringUtils.isBlank((String)catalogName)) {
            tableName = catalogName + "." + tableName;
        }
        return tableName;
    }

    protected abstract TransformPoint getTransformPoint();

    protected List<TransformTable> findTablesToTransform(NodeGroupLink nodeGroupLink, String fullyQualifiedSourceTableName) {
        Map<String, List<TransformTable>> transformMap = this.transformService.findTransformsFor(nodeGroupLink, this.getTransformPoint(), true);
        List<TransformTable> transforms = transformMap != null ? transformMap.get(fullyQualifiedSourceTableName) : null;
        return transforms;
    }

    public void setTransformService(ITransformService transformService) {
        this.transformService = transformService;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public boolean isAutoRegister() {
        return true;
    }
}

