/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.transform.IMultipleValueColumnTransform;
import org.jumpmind.symmetric.transform.IgnoreColumnException;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformedData;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplierColumnTransform
implements IMultipleValueColumnTransform,
IBuiltInExtensionPoint {
    protected SimpleJdbcTemplate jdbcTemplate;
    public static final String NAME = "multiply";

    @Override
    public boolean isAutoRegister() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> transform(ICacheContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String value, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        return this.jdbcTemplate.query(column.getTransformExpression(), (RowMapper)new SingleColumnRowMapper(String.class), sourceValues);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = new SimpleJdbcTemplate((JdbcOperations)jdbcTemplate);
    }
}

