/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.transform.IgnoreColumnException;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstrColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    protected IDbDialect dbDialect;
    public static final String NAME = "substr";

    @Override
    public boolean isAutoRegister() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String transform(ICacheContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String value, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String expression;
        if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)(expression = column.getTransformExpression()))) {
            String[] tokens = expression.split(",");
            if (tokens.length == 1) {
                int index = Integer.parseInt(tokens[0]);
                if (value.length() > index) {
                    return value.substring(index);
                }
                return "";
            }
            if (tokens.length > 1) {
                int beginIndex = Integer.parseInt(tokens[0]);
                int endIndex = Integer.parseInt(tokens[1]);
                if (value.length() > endIndex && endIndex > beginIndex) {
                    return value.substring(beginIndex, endIndex);
                }
                if (value.length() > beginIndex) {
                    return value.substring(beginIndex);
                }
                return "";
            }
        }
        return value;
    }

    protected String[] prepend(String v, String[] array) {
        String[] dest = new String[array.length + 1];
        dest[0] = v;
        for (int i = 0; i < array.length; ++i) {
            dest[i + 1] = array[i];
        }
        return dest;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }
}

