/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transform.DeleteAction;
import org.jumpmind.symmetric.transform.IColumnTransform;
import org.jumpmind.symmetric.transform.ITransformService;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformPoint;
import org.jumpmind.symmetric.transform.TransformTable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformService
extends AbstractService
implements ITransformService {
    private Map<NodeGroupLink, Map<TransformPoint, Map<String, List<TransformTable>>>> transformsCacheByNodeGroupLinkByTransformPoint;
    private long lastCacheTimeInMs;
    private Map<String, IColumnTransform<?>> columnTransforms = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<TransformTable>> findTransformsFor(NodeGroupLink nodeGroupLink, TransformPoint transformPoint, boolean useCache) {
        Map<TransformPoint, Map<String, List<TransformTable>>> byTransformPoint;
        long cacheTimeoutInMs = this.parameterService.getLong("cache.transform.time.ms");
        TransformService transformService = this;
        synchronized (transformService) {
            if (System.currentTimeMillis() - this.lastCacheTimeInMs >= cacheTimeoutInMs || this.transformsCacheByNodeGroupLinkByTransformPoint == null || !useCache) {
                this.refreshCache();
            }
        }
        if (this.transformsCacheByNodeGroupLinkByTransformPoint != null && (byTransformPoint = this.transformsCacheByNodeGroupLinkByTransformPoint.get(nodeGroupLink)) != null) {
            return byTransformPoint.get((Object)transformPoint);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCache() {
        TransformService transformService = this;
        synchronized (transformService) {
            this.transformsCacheByNodeGroupLinkByTransformPoint = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshCache() {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.transform.time.ms");
        TransformService transformService = this;
        synchronized (transformService) {
            if (System.currentTimeMillis() - this.lastCacheTimeInMs >= cacheTimeoutInMs || this.transformsCacheByNodeGroupLinkByTransformPoint == null) {
                this.transformsCacheByNodeGroupLinkByTransformPoint = new HashMap<NodeGroupLink, Map<TransformPoint, Map<String, List<TransformTable>>>>();
                List<TransformTable> transforms = this.getTransformTablesFromDB();
                for (TransformTable transformTable : transforms) {
                    List<TransformTable> tables;
                    Map<String, List<TransformTable>> byTableName;
                    NodeGroupLink nodeGroupLink = transformTable.getNodeGroupLink();
                    Map<TransformPoint, Map<String, List<TransformTable>>> byTransformPoint = this.transformsCacheByNodeGroupLinkByTransformPoint.get(nodeGroupLink);
                    if (byTransformPoint == null) {
                        byTransformPoint = new HashMap<TransformPoint, Map<String, List<TransformTable>>>();
                        this.transformsCacheByNodeGroupLinkByTransformPoint.put(nodeGroupLink, byTransformPoint);
                    }
                    if ((byTableName = byTransformPoint.get((Object)transformTable.getTransformPoint())) == null) {
                        byTableName = new HashMap<String, List<TransformTable>>();
                        byTransformPoint.put(transformTable.getTransformPoint(), byTableName);
                    }
                    if ((tables = byTableName.get(transformTable.getFullyQualifiedSourceTableName())) == null) {
                        tables = new ArrayList<TransformTable>();
                        byTableName.put(transformTable.getFullyQualifiedSourceTableName(), tables);
                    }
                    tables.add(transformTable);
                }
                this.lastCacheTimeInMs = System.currentTimeMillis();
            }
        }
    }

    private List<TransformTable> getTransformTablesFromDB() {
        List transforms = this.jdbcTemplate.query(this.getSql("selectTransformTable"), (RowMapper)new TransformTableMapper());
        List<TransformColumn> columns = this.getTransformColumnsFromDB();
        for (TransformTable transformTable : transforms) {
            for (TransformColumn column : columns) {
                if (!column.getTransformId().equals(transformTable.getTransformId())) continue;
                transformTable.addTransformColumn(column);
            }
        }
        return transforms;
    }

    private List<TransformColumn> getTransformColumnsFromDB() {
        List columns = this.jdbcTemplate.query(this.getSql("selectTransformColumn"), (RowMapper)new TransformColumnMapper());
        return columns;
    }

    @Override
    public List<TransformTable> getTransformTables() {
        return this.getTransformTablesFromDB();
    }

    @Override
    public List<TransformColumn> getTransformColumns() {
        return this.getTransformColumnsFromDB();
    }

    @Override
    public List<TransformColumn> getTransformColumnsForTable() {
        List columns = this.jdbcTemplate.query(this.getSql("selectTransformColumnForTable"), (RowMapper)new TransformColumnMapper());
        return columns;
    }

    @Override
    @Transactional
    public void saveTransformTable(TransformTable transformTable) {
        if (this.jdbcTemplate.update(this.getSql("updateTransformTableSql"), new Object[]{transformTable.getNodeGroupLink().getSourceNodeGroupId(), transformTable.getNodeGroupLink().getTargetNodeGroupId(), transformTable.getSourceCatalogName(), transformTable.getSourceSchemaName(), transformTable.getSourceTableName(), transformTable.getTargetCatalogName(), transformTable.getTargetSchemaName(), transformTable.getTargetTableName(), transformTable.getTransformPoint().toString(), transformTable.isUpdateFirst(), transformTable.getDeleteAction().toString(), transformTable.getTransformOrder(), transformTable.getTransformId()}) == 0) {
            this.jdbcTemplate.update(this.getSql("insertTransformTableSql"), new Object[]{transformTable.getNodeGroupLink().getSourceNodeGroupId(), transformTable.getNodeGroupLink().getTargetNodeGroupId(), transformTable.getSourceCatalogName(), transformTable.getSourceSchemaName(), transformTable.getSourceTableName(), transformTable.getTargetCatalogName(), transformTable.getTargetSchemaName(), transformTable.getTargetTableName(), transformTable.getTransformPoint().toString(), transformTable.isUpdateFirst(), transformTable.getDeleteAction().toString(), transformTable.getTransformOrder(), transformTable.getTransformId()});
        }
        this.deleteTransformColumns(transformTable.getTransformId());
        List<TransformColumn> columns = transformTable.getTransformColumns();
        if (columns != null) {
            for (TransformColumn transformColumn : columns) {
                this.saveTransformColumn(transformColumn);
            }
        }
        this.refreshCache();
    }

    public void deleteTransformColumns(String transformTableId) {
        this.jdbcTemplate.update(this.getSql("deleteTransformColumnsSql"), new Object[]{transformTableId});
    }

    @Override
    public void deleteTransformTable(String transformTableId) {
        this.deleteTransformColumns(transformTableId);
        this.jdbcTemplate.update(this.getSql("deleteTransformTableSql"), new Object[]{transformTableId});
        this.refreshCache();
    }

    @Override
    public void saveTransformColumn(TransformColumn transformColumn) {
        if (this.jdbcTemplate.update(this.getSql("updateTransformColumnSql"), new Object[]{transformColumn.getSourceColumnName(), transformColumn.isPk(), transformColumn.getTransformType(), transformColumn.getTransformExpression(), transformColumn.getTransformOrder(), transformColumn.getTransformId(), transformColumn.getIncludeOn().toDbValue(), transformColumn.getTargetColumnName()}) == 0) {
            this.jdbcTemplate.update(this.getSql("insertTransformColumnSql"), new Object[]{transformColumn.getTransformId(), transformColumn.getIncludeOn().toDbValue(), transformColumn.getTargetColumnName(), transformColumn.getSourceColumnName(), transformColumn.isPk(), transformColumn.getTransformType(), transformColumn.getTransformExpression(), transformColumn.getTransformOrder()});
        }
    }

    @Override
    public void deleteTransformColumn(String transformTableId, Boolean includeOn, String targetColumnName) {
        String includeOnAsChar = null;
        includeOnAsChar = includeOn != false ? "Y" : "N";
        this.jdbcTemplate.update(this.getSql("deleteTransformColumnSql"), new Object[]{transformTableId, includeOnAsChar, targetColumnName});
        this.refreshCache();
    }

    @Override
    public Map<String, IColumnTransform<?>> getColumnTransforms() {
        return this.columnTransforms;
    }

    @Override
    public void addColumnTransform(String name, IColumnTransform<?> transform) {
        this.columnTransforms.put(name, transform);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransformColumnMapper
    implements RowMapper<TransformColumn> {
        TransformColumnMapper() {
        }

        public TransformColumn mapRow(ResultSet rs, int rowNum) throws SQLException {
            TransformColumn col = new TransformColumn();
            col.setTransformId(rs.getString(1));
            col.setIncludeOn(TransformColumn.IncludeOnType.decode(rs.getString(2)));
            col.setTargetColumnName(rs.getString(3));
            col.setSourceColumnName(rs.getString(4));
            col.setPk(rs.getBoolean(5));
            col.setTransformType(rs.getString(6));
            col.setTransformExpression(rs.getString(7));
            col.setTransformOrder(rs.getInt(8));
            return col;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransformTableMapper
    implements RowMapper<TransformTable> {
        TransformTableMapper() {
        }

        public TransformTable mapRow(ResultSet rs, int rowNum) throws SQLException {
            TransformTable table = new TransformTable();
            table.setTransformId(rs.getString(1));
            table.setNodeGroupLink(new NodeGroupLink(rs.getString(2), rs.getString(3)));
            table.setSourceCatalogName(rs.getString(4));
            table.setSourceSchemaName(rs.getString(5));
            table.setSourceTableName(rs.getString(6));
            table.setTargetCatalogName(rs.getString(7));
            table.setTargetSchemaName(rs.getString(8));
            table.setTargetTableName(rs.getString(9));
            table.setTransformPoint(TransformPoint.valueOf(rs.getString(10)));
            table.setTransformOrder(rs.getInt(11));
            table.setUpdateFirst(rs.getBoolean(12));
            table.setDeleteAction(DeleteAction.valueOf(rs.getString(13)));
            return table;
        }
    }
}

