/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.transform.DeleteAction;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformTable {
    protected String transformId;
    protected String sourceCatalogName;
    protected String sourceSchemaName;
    protected String sourceTableName;
    protected String targetCatalogName;
    protected String targetSchemaName;
    protected String targetTableName;
    protected TransformPoint transformPoint;
    protected NodeGroupLink nodeGroupLink;
    protected List<TransformColumn> transformColumns;
    protected List<TransformColumn> primaryKeyColumns;
    protected DeleteAction deleteAction = DeleteAction.NONE;
    protected boolean updateFirst = false;
    protected int transformOrder = 0;

    public String getFullyQualifiedSourceTableName() {
        return Table.getFullyQualifiedTableName((String)this.sourceTableName, (String)this.sourceSchemaName, (String)this.sourceCatalogName);
    }

    public String getFullyQualifiedTargetTableName() {
        return Table.getFullyQualifiedTableName((String)this.targetTableName, (String)this.targetSchemaName, (String)this.targetCatalogName);
    }

    public String getTransformId() {
        return this.transformId;
    }

    public void setTransformId(String transformId) {
        this.transformId = transformId;
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    public void setTargetCatalogName(String targetCatalogName) {
        this.targetCatalogName = targetCatalogName;
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public void setTransformPoint(TransformPoint transformPoint) {
        this.transformPoint = transformPoint;
    }

    public TransformPoint getTransformPoint() {
        return this.transformPoint;
    }

    public void setTransformColumns(List<TransformColumn> transformColumns) {
        this.transformColumns = transformColumns;
        this.primaryKeyColumns = new ArrayList<TransformColumn>();
        if (transformColumns != null) {
            for (TransformColumn transformColumn : transformColumns) {
                if (!transformColumn.isPk()) continue;
                this.primaryKeyColumns.add(transformColumn);
            }
        }
    }

    public List<TransformColumn> getTransformColumns() {
        return this.transformColumns;
    }

    public List<TransformColumn> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<TransformColumn> getTransformColumnFor(String columnName) {
        ArrayList<TransformColumn> columns = new ArrayList<TransformColumn>(2);
        for (TransformColumn column : this.transformColumns) {
            if (!column.getSourceColumnName().equals(columnName)) continue;
            columns.add(column);
        }
        return columns;
    }

    public void addTransformColumn(TransformColumn column) {
        if (this.transformColumns == null) {
            this.transformColumns = new ArrayList<TransformColumn>();
        }
        if (this.primaryKeyColumns == null) {
            this.primaryKeyColumns = new ArrayList<TransformColumn>();
        }
        this.transformColumns.add(column);
        if (column.isPk()) {
            this.primaryKeyColumns.add(column);
        }
    }

    public void setDeleteAction(DeleteAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setTransformOrder(int transformOrder) {
        this.transformOrder = transformOrder;
    }

    public int getTransformOrder() {
        return this.transformOrder;
    }

    public void setUpdateFirst(boolean updateFirst) {
        this.updateFirst = updateFirst;
    }

    public boolean isUpdateFirst() {
        return this.updateFirst;
    }

    public void setNodeGroupLink(NodeGroupLink nodeGroupLink) {
        this.nodeGroupLink = nodeGroupLink;
    }

    public NodeGroupLink getNodeGroupLink() {
        return this.nodeGroupLink;
    }

    public int hashCode() {
        if (this.transformId != null) {
            return this.transformId.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.transformId != null) {
            if (obj instanceof TransformTable) {
                return this.transformId.equals(((TransformTable)obj).transformId);
            }
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this.transformId != null) {
            return this.transformId;
        }
        return super.toString();
    }
}

